/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PCSC ISO14443-3A Component of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P3A_PCSC_H
#define PHPALI14443P3A_PCSC_H

#include <ph_Status.h>
#include <phpalI14443p3a.h>

phStatus_t phpalI14443p3a_Pcsc_RequestA(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t * pAtqa
    );

phStatus_t phpalI14443p3a_Pcsc_WakeUpA(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t * pAtqa
    );

phStatus_t phpalI14443p3a_Pcsc_HaltA(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams
    );

phStatus_t phpalI14443p3a_Pcsc_Anticollision(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t bCascadeLevel,
    uint8_t * pUidIn,
    uint8_t bNvbUidIn,
    uint8_t * pUidOut,
    uint8_t * pNvbUidOut
    );

phStatus_t phpalI14443p3a_Pcsc_Select(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t bCascadeLevel,
    uint8_t * pUidIn,
    uint8_t * pSak
    );

phStatus_t phpalI14443p3a_Pcsc_ActivateCard(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t * pUidIn,
    uint8_t bLenUidIn,
    uint8_t * pUidOut,
    uint8_t * pLenUidOut,
    uint8_t * pSak,
    uint8_t * pMoreCardsAvailable
    );

phStatus_t phpalI14443p3a_Pcsc_Exchange(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint16_t wOption,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint8_t ** ppRxBuffer,
    uint16_t * pRxLength
    );

phStatus_t phpalI14443p3a_Pcsc_GetSerialNo(
    phpalI14443p3a_Pcsc_DataParams_t * pDataParams,
    uint8_t * pRxBuffer,
    uint8_t * pRxLength
    );

#endif /* PHPALI14443P3A_PCSC_H */
