/*
 * Copyright 2013, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * RdCardSim specific HAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RDCARDSIM_H
#define PHHALHW_RDCARDSIM_H

#include <ph_Status.h>
#include <phhalHw.h>

#define PHHAL_HW_RDCARDSIM_INTBUFFER                4        /**< Number of tmp buffer toi divide the total buffer **/

#define PHHAL_HW_RDCARDSIM_DEFAULT_TIMEOUT          5500U     /**< Default timeout in microseconds */
#define PHHAL_HW_RDCARDSIM_FIELD_OFF_DEFAULT        5500U     /**< Default Field-Off time. In us */
#define PHHAL_HW_RDCARDSIM_FIELD_RECOVERY_DEFAULT   5500U     /**< Default Field-Recovery time. In us*/
#define PHHAL_HW_RDCARDSIM_RX2TXWAIT_DEFAULT        75U      /**< Default is set to below 86 - 9.5 (etu) as the reader model will handle the correct timing. In us*/

phStatus_t phhalHw_RdCardSim_SetConfig(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t wValue
    );

phStatus_t phhalHw_RdCardSim_GetConfig(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint16_t   wConfig,
    uint16_t * pValue
    );

phStatus_t phhalHw_RdCardSim_FieldOn(
    phhalHw_RdCardSim_DataParams_t * pDataParams
    );

phStatus_t phhalHw_RdCardSim_FieldOff(
    phhalHw_RdCardSim_DataParams_t * pDataParams
    );

phStatus_t phhalHw_RdCardSim_FieldReset(
    phhalHw_RdCardSim_DataParams_t * pDataParams
    );

phStatus_t phhalHw_RdCardSim_Wait(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t   bUnit,
    uint16_t  wTimeout
    );

phStatus_t phhalHw_RdCardSim_Exchange(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint16_t    wOption,
    uint8_t   * pTxBuffer,
    uint16_t    wTxLength,
    uint8_t  ** ppRxBuffer,
    uint16_t  * pRxLength
    );

phStatus_t phhalHw_RdCardSim_ApplyProtocolSettings(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bCardType
    );

phStatus_t phhalHw_RdCardSim_MfcAuthenticateKeyNo(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint16_t wKeyNo,
    uint16_t wKeyVersion,
    uint8_t * pUid
    );

phStatus_t phhalHw_RdCardSim_MfcAuthenticate(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint8_t * pKey,
    uint8_t * pUid
    );

phStatus_t phhalHw_RdCardSim_WriteRegister(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t bValue
    );

phStatus_t phhalHw_RdCardSim_ReadRegister(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t * pValue
    );

phStatus_t phhalHw_RdCardSim_ReadRegister32(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint32_t * pValue
    );

#endif /* PHHALHW_RDCARDSIM_H */
