/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Callback HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phhalHw.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_CALLBACK

#include "phhalHw_Callback.h"

phStatus_t phhalHw_Callback_Init(
                                 phhalHw_Callback_DataParams_t * pDataParams,
                                 uint16_t wSizeOfDataParams,
                                 cbExchange pExchangeCb,
                                 cbWriteRegister pWriteRegisterCb,
                                 cbReadRegister pReadRegisterCb,
                                 cbApplyProtocolSettings pApplyProtocolSettingsCb,
                                 cbMfcAuthenticate pMfcAuthenticateCb,
                                 cbMfcAuthenticateKey pMfcAuthenticateKeyCb,
                                 cbSetConfig pSetConfigCb,
                                 cbGetConfig pGetConfigCb,
                                 cbFieldOn pFieldOnCb,
                                 cbFieldOff pFieldOffCb,
                                 cbFieldReset pFieldResetCb,
                                 cbWait pWaitCb,
                                 void * pCallbackContext
                                 )
{
    if (sizeof(phhalHw_Callback_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_HAL);
    }
	PH_ASSERT_NULL (pDataParams);

    pDataParams->wId                = PH_COMP_HAL | PHHAL_HW_CALLBACK_ID;
    pDataParams->pExchangeCb        = pExchangeCb;
    pDataParams->pWriteRegisterCb   = pWriteRegisterCb;
    pDataParams->pReadRegisterCb    = pReadRegisterCb;
    pDataParams->pApplyProtocolSettingsCb = pApplyProtocolSettingsCb;
    pDataParams->pMfcAuthenticateCb = pMfcAuthenticateCb;
    pDataParams->pMfcAuthenticateKeyCb = pMfcAuthenticateKeyCb;
    pDataParams->pSetConfigCb       = pSetConfigCb;
    pDataParams->pGetConfigCb       = pGetConfigCb;
    pDataParams->pFieldOnCb         = pFieldOnCb;
    pDataParams->pFieldOffCb        = pFieldOffCb;
    pDataParams->pFieldResetCb      = pFieldResetCb;
    pDataParams->pWaitCb            = pWaitCb;
    pDataParams->pCbContext         = pCallbackContext;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
}

phStatus_t phhalHw_Callback_Exchange(
                                     phhalHw_Callback_DataParams_t * pDataParams,
                                     uint16_t wOption,
                                     uint8_t * pTxBuffer,
                                     uint16_t wTxLength,
                                     uint8_t ** ppRxBuffer,
                                     uint16_t * pRxLength
                                     )
{
	uint16_t	PH_MEMLOC_REM RxLength;
	uint8_t *	PH_MEMLOC_REM pRxBuffer;

	/* Check if caller has provided valid RxBuffer */
	if (ppRxBuffer == NULL)
	{
		ppRxBuffer = &pRxBuffer;
	}
	if (pRxLength == NULL)
	{
		pRxLength = &RxLength;
	}

    if (pDataParams->pExchangeCb == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }

    return (*pDataParams->pExchangeCb)(wOption, pTxBuffer, wTxLength, ppRxBuffer, pRxLength, pDataParams->pCbContext);
}

phStatus_t phhalHw_Callback_WriteRegister(
    phhalHw_Callback_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t bValue
    )
{
    if (pDataParams->pWriteRegisterCb)
    {
        return (*pDataParams->pWriteRegisterCb)(bAddress, bValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_ReadRegister(
    phhalHw_Callback_DataParams_t * pDataParams,
    uint8_t bAddress,
    uint8_t * pValue
    )
{
    if (pDataParams->pReadRegisterCb)
    {
        return (*pDataParams->pReadRegisterCb)(bAddress, pValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_ApplyProtocolSettings(
    phhalHw_Callback_DataParams_t * pDataParams,
    uint8_t bCardType
    )
{
    if (pDataParams->pApplyProtocolSettingsCb)
    {
        return (*pDataParams->pApplyProtocolSettingsCb)(bCardType, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_MfcAuthenticateKeyNo(
    phhalHw_Callback_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint16_t wKeyNo,
    uint16_t wKeyVersion,
    uint8_t * pUid
    )
{
    if (pDataParams->pMfcAuthenticateCb)
    {
        return (*pDataParams->pMfcAuthenticateCb)(bBlockNo, bKeyType, wKeyNo, wKeyVersion, pUid, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_MfcAuthenticate(
    phhalHw_Callback_DataParams_t * pDataParams,
    uint8_t bBlockNo,
    uint8_t bKeyType,
    uint8_t * pKey,
    uint8_t * pUid
    )
{
    if (pDataParams->pMfcAuthenticateKeyCb)
    {
        return (*pDataParams->pMfcAuthenticateKeyCb)(bBlockNo, bKeyType, pKey, pUid, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_SetConfig(
                                      phhalHw_Callback_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t wValue
                                      )
{
    if (pDataParams->pSetConfigCb)
    {
        return (*pDataParams->pSetConfigCb)(wConfig, wValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_GetConfig(
                                      phhalHw_Callback_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t * pValue
                                      )
{
    if (pDataParams->pGetConfigCb)
    {
        return (*pDataParams->pGetConfigCb)(wConfig, pValue, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_FieldOn(
                                    phhalHw_Callback_DataParams_t * pDataParams
                                    )
{
    if (pDataParams->pFieldOnCb)
    {
        return (*pDataParams->pFieldOnCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_FieldOff(
                                     phhalHw_Callback_DataParams_t * pDataParams
                                     )
{
    if (pDataParams->pFieldOffCb)
    {
        return (*pDataParams->pFieldOffCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_FieldReset(
                                       phhalHw_Callback_DataParams_t * pDataParams
                                       )
{
    if (pDataParams->pFieldResetCb)
    {
        return (*pDataParams->pFieldResetCb)(pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_Callback_Wait(
                                 phhalHw_Callback_DataParams_t * pDataParams,
                                 uint8_t bUnit,
                                 uint16_t wTimeout
                                 )
{
    if (pDataParams->pWaitCb)
    {
        return (*pDataParams->pWaitCb)(bUnit, wTimeout, pDataParams->pCbContext);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);
    }
}

#endif /* NXPBUILD__PHHAL_HW_CALLBACK */
