/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (Secure Access Module) implementation for Reader Library
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 03. Jan 2024
 *
 */

#ifndef PHBALREG_SAM_H
#define PHBALREG_SAM_H

#include <ph_Status.h>

#define PH_BAL_RESERVED_TX_BUFFER_LEN       13U
#define PH_BAL_RESERVED_RX_BUFFER_LEN       8U

phStatus_t phbalReg_Sam_GetPortList(phbalReg_Sam_DataParams_t * pDataParams, uint16_t wPortBufSize, uint8_t * pPortNames,
    uint16_t * pNumOfPorts);

phStatus_t phbalReg_Sam_SetPort(phbalReg_Sam_DataParams_t * pDataParams, uint8_t * pPortName);

phStatus_t phbalReg_Sam_OpenPort(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_ClosePort(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_Exchange(phbalReg_Sam_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pTxBuffer,
    uint16_t wTxBufLen, uint16_t wRxBufSize, uint8_t * pRxBuffer, uint16_t * pRxBufLen);

phStatus_t phbalReg_Sam_SetConfig(phbalReg_Sam_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue );

phStatus_t phbalReg_Sam_GetConfig( phbalReg_Sam_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

#endif /* PHBALREG_SAM_H */
