/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_PS6000USB_EX_H
#define PHBALREG_PS6000USB_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_Ps6000Usb_Ex_LoadFunctions(
    phbalReg_Ps6000Usb_DataParams_t * pDataParams
    );

phStatus_t phbalReg_Ps6000Usb_Ex_UnLoadFunctions(
    phbalReg_Ps6000Usb_DataParams_t * pDataParams
    );

/* define the dll that has to be loaded */
#define PHBAL_REG_PS6000USB_EX_DLL_NAME                                           "PS6000.dll"

/* define the function names that have to be loaded */


/* PS6000 API FUNCTIONS:*/
#define PHBAL_REG_PS6000USB_EX_OPEN_UNIT_FNAME                                    "_ps6000OpenUnit@8"
#define PHBAL_REG_PS6000USB_EX_OPEN_UNIT_ASYNC_FNAME                              "_ps6000OpenUnitAsync@8"
#define PHBAL_REG_PS6000USB_EX_OPEN_UNIT_PROGRESS_FNAME                           "_ps6000OpenUnitProgress@12"
#define PHBAL_REG_PS6000USB_EX_GET_UNIT_INFO_FNAME                                "_ps6000GetUnitInfo@20"
#define PHBAL_REG_PS6000USB_EX_FLASH_LED_FNAME                                    "_ps6000FlashLed@8"
#define PHBAL_REG_PS6000USB_EX_CLOSE_UNIT_FNAME                                   "_ps6000CloseUnit@4"
#define PHBAL_REG_PS6000USB_EX_MEMORY_SEGMENTS_FNAME                              "_ps6000MemorySegments@12"
#define PHBAL_REG_PS6000USB_EX_SET_CHANNEL_FNAME                                  "_ps6000SetChannel@28"
#define PHBAL_REG_PS6000USB_EX_GET_TIMEBASE_FNAME                                 "_ps6000GetTimebase@28"
#define PHBAL_REG_PS6000USB_EX_GET_TIMEBASE2_FNAME                                "_ps6000GetTimebase2@28"
#define PHBAL_REG_PS6000USB_EX_SET_SIG_GEN_ARBITRARY_FNAME                        "_ps6000SetSigGenArbitrary@68"
#define PHBAL_REG_PS6000USB_EX_SET_SIG_GEN_BUILT_IN_FNAME                         "_ps6000SetSigGenBuiltIn@60"
#define PHBAL_REG_PS6000USB_EX_SIG_GEN_SOFTWARE_CONTROL_FNAME                     "_ps6000SigGenSoftwareControl@8"
#define PHBAL_REG_PS6000USB_EX_SET_SIMPLE_TRIGGER_FNAME                           "_ps6000SetSimpleTrigger@28"
#define PHBAL_REG_PS6000USB_EX_SET_ETS_FNAME                                      "_ps6000SetEts@20"
#define PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_PROPERTIES_FNAME               "_ps6000SetTriggerChannelProperties@20"
#define PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_CONDITIONS_FNAME               "_ps6000SetTriggerChannelConditions@12"
#define PHBAL_REG_PS6000USB_EX_SET_TRIGGER_CHANNEL_DIRECTIONS_FNAME               "_ps6000SetTriggerChannelDirections@28"
#define PHBAL_REG_PS6000USB_EX_SET_TRIGGER_DELAY_FNAME                            "_ps6000SetTriggerDelay@8"
#define PHBAL_REG_PS6000USB_EX_SET_PULSE_WIDTH_QUALIFIER_FNAME                    "_ps6000SetPulseWidthQualifier@28"
#define PHBAL_REG_PS6000USB_EX_IS_TRIGGER_OR_PULSE_WIDTH_QUALIFIER_ENABLED_FNAME  "_ps6000IsTriggerOrPulseWidthQualifierEnabled@12"
#define PHBAL_REG_PS6000USB_EX_GET_TRIGGER_TIME_OFFSET_FNAME                      "_ps6000GetTriggerTimeOffset@20"
#define PHBAL_REG_PS6000USB_EX_GET_TRIGGER_TIME_OFFSET64_FNAME                    "_ps6000GetTriggerTimeOffset64@16"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_TRIGGER_TIME_OFFSET_BULK_FNAME          "_ps6000GetValuesTriggerTimeOffsetBulk@24"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_TRIGGER_TIME_OFFSET_BULK64_FNAME        "_ps6000GetValuesTriggerTimeOffsetBulk64@20"
#define PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFERS_FNAME                             "_ps6000SetDataBuffers@24"
#define PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFER_FNAME                              "_ps6000SetDataBuffer@20"
#define PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFER_BULK_FNAME                         "_ps6000SetDataBufferBulk@24"
#define PHBAL_REG_PS6000USB_EX_SET_DATA_BUFFERS_BULK_FNAME                        "_ps6000SetDataBuffersBulk@28"
#define PHBAL_REG_PS6000USB_EX_SET_ETS_TIME_BUFFER_FNAME                          "_ps6000SetEtsTimeBuffer@12"
#define PHBAL_REG_PS6000USB_EX_SET_ETS_TIME_BUFFERS_FNAME                         "_ps6000SetEtsTimeBuffers@16"
#define PHBAL_REG_PS6000USB_EX_RUN_BLOCK_FNAME                                    "_ps6000RunBlock@36"
#define PHBAL_REG_PS6000USB_EX_IS_READY_FNAME                                     "_ps6000IsReady@8"
#define PHBAL_REG_PS6000USB_EX_RUN_STREAMING_FNAME                                "_ps6000RunStreaming@36"
#define PHBAL_REG_PS6000USB_EX_GET_STREAMING_LATEST_VALUES_FNAME                  "_ps6000GetStreamingLatestValues@12"
#define PHBAL_REG_PS6000USB_EX_NO_OF_STREAMING_VALUES_FNAME                       "_ps6000NoOfStreamingValues@8"
#define PHBAL_REG_PS6000USB_EX_GET_MAX_DOWN_SAMPLE_RATIO_FNAME                    "_ps6000GetMaxDownSampleRatio@20"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_FNAME                                   "_ps6000GetValues@28"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_BULK_FNAME                              "_ps6000GetValuesBulk@28"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_ASYNC_FNAME                             "_ps6000GetValuesAsync@32"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_OVERLAPPED_FNAME                        "_ps6000GetValuesOverlapped@28"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_OVERLAPPED_BULK_FNAME                   "_ps6000GetValuesOverlappedBulk@32"
#define PHBAL_REG_PS6000USB_EX_GET_VALUES_BULK_ASYNC_FNAME                        "_ps6000GetValuesBulkAsyc@32"
#define PHBAL_REG_PS6000USB_EX_GET_NO_OF_CAPTURES_FNAME                           "_ps6000GetNoOfCaptures@8"
#define PHBAL_REG_PS6000USB_EX_STOP_FNAME                                         "_ps6000Stop@4"
#define PHBAL_REG_PS6000USB_EX_SET_NO_OF_CAPTURES_FNAME                           "_ps6000SetNoOfCaptures@8"
#define PHBAL_REG_PS6000USB_EX_SET_WAVEFORM_LIMITER_FNAME                         "_ps6000SetWaveformLimiter@8"
#define PHBAL_REG_PS6000USB_EX_ENUMERATE_UNITS_FNAME                              "_ps6000EnumerateUnits@12"
#define PHBAL_REG_PS6000USB_EX_SET_EXTERNAL_CLOCK_FNAME                           "_ps6000SetExternalClock@12"
#define PHBAL_REG_PS6000USB_EX_GET_UNIT_INFO_FNAME                                "_ps6000GetUnitInfo@20"

#endif /* PHBALREG_PS6000USB_EX_H */
