/*
 * Copyright 2016 - 2018, 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Sam S Virtual Card Architecture(R) Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALVCA_SAM_NONX_H
#define PHALVCA_SAM_NONX_H

#include <ph_Status.h>

#define PHAL_VCA_SAMAV3_FCI_DATA_LEN                36U   /**< FCI data length. */
#define PHAL_VCA_SAMAV3_TRUNCATED_MAC_SIZE          8U    /**< Size of the truncated MAC. */

#define PHAL_VCA_SAMAV3_PC_RND_LEN                  8U    /**< Random data Length. */

#ifndef NXPBUILD__PHAL_VCA_INTERNAL
#define PHAL_VCA_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)                                                                                      \
            (PH_GET_COMPID(DataParams) == PHAL_VCA_SAMAV3_NONX_ID) ? ((phalVca_SamAV3_NonX_DataParams_t *) DataParams)->pPalMifareDataParams :  \
            NULL
#endif /* NXPBUILD__PHAL_VCA_INTERNAL */

#ifndef NXPBUILD__PHAL_VCA_INTERNAL
#define PHAL_VCA_RESOLVE_HAL_DATAPARAMS(DataParams)                                                                                             \
            (PH_GET_COMPID(DataParams) == PHAL_VCA_SAMAV3_NONX_ID) ? ((phalVca_SamAV3_NonX_DataParams_t *) DataParams)->pSamHal :               \
            NULL
#endif /* NXPBUILD__PHAL_VCA_INTERNAL */

#ifndef NXPBUILD__PHAL_VCA_INTERNAL
#define PHAL_VCA_RESOLVE_EXTENDED_LENGTH_APDU(DataParams)                                                                                       \
            ((PH_GET_COMPID(DataParams) == PHAL_VCA_SAMAV3_NONX_ID) ? ((phalVca_SamAV3_NonX_DataParams_t *) (DataParams))->bExtendedLenApdu :      \
            NULL)
#endif /* NXPBUILD__PHAL_VCA_INTERNAL */

#ifndef NXPBUILD__PHAL_VCA_INTERNAL
#define PHAL_VCA_RESOLVE_WRAPPED_MODE(DataParams)                                                                                               \
            (PH_GET_COMPID(DataParams) == PHAL_VCA_SAMAV3_NONX_ID) ? ((phalVca_SamAV3_NonX_DataParams_t *) DataParams)->bWrappedMode :          \
            NULL
#endif /* NXPBUILD__PHAL_VCA_INTERNAL */


phStatus_t phalVca_Sam_NonX_StartCardSelection (phalVca_SamAV2_DataParams_t * pDataParams);

phStatus_t phalVca_Sam_NonX_FinalizeCardSelection(phalVca_SamAV2_DataParams_t * pDataParams, uint16_t* pNumValidIids);

phStatus_t phalVca_Sam_NonX_SelectVc(phalVca_SamAV2_DataParams_t * pDataParams, uint16_t wValidIidIndex, uint16_t wKeyNo,
    uint16_t wKeyVer);

phStatus_t phalVca_Sam_NonX_DeselectVc(phalVca_SamAV2_DataParams_t * pDataParams);

phStatus_t phalVca_Sam_NonX_VcSupport(phalVca_SamAV2_DataParams_t * pDataParams, uint8_t * pIid, uint16_t wKeyEncNo,
    uint16_t wKeyEncVer, uint16_t wKeyMacNo, uint16_t wKeyMacVer);

phStatus_t phalVca_Sam_NonX_VcSupportLast(phalVca_SamAV2_DataParams_t * pDataParams, uint8_t * pIid, uint8_t bLenCap,
    uint8_t * pPcdCapabilities, uint16_t wKeyEncNo, uint16_t wKeyEncVer, uint16_t wKeyMacNo, uint16_t wKeyMacVer);

phStatus_t phalVca_Sam_NonX_GetIidInfo(phalVca_SamAV2_DataParams_t * pDataParams, uint16_t wValidIidIndex, uint16_t * pIidIndex,
    uint8_t * pVcUidSize, uint8_t * pVcUid, uint8_t * pInfo, uint8_t * pPdCapabilities);

#ifdef NXPBUILD__PHAL_VCA_SAMAV3_NONX
phStatus_t phalVca_Sam_NonX_IsoSelect(void * pDataParams, uint8_t bSelectionControl, uint8_t bOption,
    uint8_t bDFnameLen, uint8_t * pDFname, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t bEncKeyNo, uint8_t bEncKeyVer,
    uint8_t bMacKeyNo, uint8_t bMacKeyVer, uint8_t * pResponse, uint16_t * pRespLen);

phStatus_t phalVca_Sam_NonX_IsoExternalAuthenticate(void * pDataParams, uint8_t * pInData);
#endif /* NXPBUILD__PHAL_VCA_SAMAV3_NONX */




phStatus_t phalVca_Sam_NonX_ProximityCheck(phalVca_SamAV2_DataParams_t * pDataParams, uint8_t bGenerateRndC, uint8_t * pRndC,
    uint8_t bPps1, uint8_t bNumSteps, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pUsedRndC);

#ifdef NXPBUILD__PHAL_VCA_SAMAV3_NONX
phStatus_t phalVca_Sam_NonX_ProximityCheckNew(void * pDataParams, uint8_t bGenerateRndC,
    uint8_t * pPrndC, uint8_t bNumSteps, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen,
    uint8_t * pOption, uint8_t * pPubRespTime, uint8_t * pResponse, uint16_t * pRespLen, uint8_t * pCumRndRC);

phStatus_t phalVca_Sam_NonX_PrepareProximityCheckNew(void * pDataParams, uint8_t * pOption,
    uint8_t * pPubRespTime, uint8_t * pResponse, uint16_t * pRespLen);

phStatus_t phalVca_Sam_NonX_ExecuteProximityCheckNew(void * pDataParams, uint8_t bGenerateRndC,
    uint8_t * pPrndC, uint8_t * pPubRespTime, uint8_t bNumSteps, uint8_t * pCumRndRC);

phStatus_t phalVca_Sam_NonX_VerifyProximityCheckNew(void * pDataParams, uint8_t * pMac,
    uint8_t * pResponse, uint16_t * pRespLen);




phStatus_t phalVca_Sam_NonX_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalVca_Sam_NonX_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalVca_Sam_NonX_SendISOWrappedCmd(void * pDataParams, uint8_t * pCmdBuffer, uint8_t bLc,
    uint8_t ** pResponse, uint16_t * pRespLen);

phStatus_t phalVca_Sam_NonX_ComputeErrorResponse_Extended(void * pDataParams, uint16_t wStatus);

phStatus_t phalVca_Sam_NonX_ResolveValidIndex( phalVca_SamAV2_DataParams_t * pDataParams, uint16_t wIidIndex,
    uint16_t * pValidIndex);

phStatus_t phalVca_Sam_NonX_SelectVC(void* pDataParams, uint8_t bOption, uint8_t bEncKeyNo, uint8_t bEncKeyVer,
    uint8_t bMacKeyNo, uint8_t bMacKeyVer, uint8_t* pData, uint8_t bDataLen, uint8_t* pDivInput, uint8_t bDivInputLen,
    uint8_t** ppResponse, uint16_t* pRespLen);

void phalVca_Sam_NonX_SetAdditionalInfo(void* pDataParams, uint16_t wValue);

void phalVca_Sam_NonX_SetWrappedMode(void* pDataParams, uint16_t wValue);

void phalVca_Sam_NonX_SetExtendedAPDU(void* pDataParams, uint16_t wValue);

void phalVca_Sam_NonX_SetTimingMode(void* pDataParams, uint16_t wValue);

uint16_t phalVca_Sam_NonX_GetAdditionalInfo(void* pDataParams);

uint8_t phalVca_Sam_NonX_GetWrappedMode(void* pDataParams);

uint8_t phalVca_Sam_NonX_GetExtendedAPDU(void* pDataParams);

uint8_t phalVca_Sam_NonX_GetTimingMode(void* pDataParams);

phStatus_t phalVca_Sam_NonX_ProximityCheck_Part1(void* pDataParams, uint8_t  bOption,
    uint8_t bKeyNo, uint8_t  bKeyVer, uint8_t* pPPCData, uint8_t  bPPCDataLen, uint8_t* pPCData,
    uint8_t bPCDataLen, uint8_t* pDivInput, uint8_t bDivInputLen, uint8_t** ppMac,
    uint16_t* pMacLen);

phStatus_t phalVca_Sam_NonX_ProximityCheck_Part2(void* pDataParams, uint8_t* pData,
    uint8_t bDataLen, uint8_t* pPiccRetCode);

phStatus_t phalVca_Sam_NonX_KillAuthentication(void* pDataParams, uint8_t bOption);

phStatus_t phalVca_Sam_NonX_GetRandom(void* pDataParams, uint8_t bExpLen, uint8_t* pRnd);

#endif /* NXPBUILD__PHAL_VCA_SAMAV3_NONX */

#endif /* PHALVCA_SAM_NONX_H */
