/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Sam MIFARE(R) Ultralight Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_MFUL_SAM_NONX
#include <phalMful.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#include <phhalHw_SamAV2_Cmd.h>
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
#include <phhalHw_SamAV3_Cmd.h>
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#include "..\phalMful_Int.h"
#include "phalMful_Sam_X_Int.h"

phStatus_t phalMful_Sam_X_Int_UlcAuthenticate(void * pDataParams, uint8_t bOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pStatusCode)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_X
        case PHAL_MFUL_SAMAV2_X_ID:
            PH_UNUSED_VARIABLE(pStatusCode);

            wStatus = phhalHw_SamAV2_Cmd_ULCAuthenticatePICC(
                ((phalMful_SamAV2_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                (uint8_t) wKeyNo,
                (uint8_t) wKeyVer,
                pDivInput,
                bDivInputLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_X */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_X
        case PHAL_MFUL_SAMAV3_X_ID:
            wStatus = phhalHw_SamAV3_Cmd_ULC_AuthenticatePICC(
                ((phalMful_SamAV3_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption,
                (uint8_t) wKeyNo,
                (uint8_t) wKeyVer,
                pDivInput,
                bDivInputLen,
                pStatusCode);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_X */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_X_Int_MfRead(void * pDataParams, uint8_t * pBlocks, uint8_t bBlocksLen, uint8_t ** ppData,
    uint16_t * pDataLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_X
        case PHAL_MFUL_SAMAV2_X_ID:
            wStatus = phhalHw_SamAV2_Cmd_MfRead(
                ((phalMful_SamAV2_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                PHHAL_HW_SAMAV2_CMD_CHANGE_MFREAD_SINGLEBLOCK,
                pBlocks,
                bBlocksLen,
                ppData,
                pDataLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_X */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_X
        case PHAL_MFUL_SAMAV3_X_ID:
            wStatus = phhalHw_SamAV3_Cmd_MF_Read(
                ((phalMful_SamAV3_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                pBlocks,
                bBlocksLen,
                ppData,
                pDataLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_X */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_X_Int_MfWrite(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen,
    uint8_t ** ppResponse, uint16_t * pRspLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_X
        case PHAL_MFUL_SAMAV2_X_ID:
            PH_UNUSED_VARIABLE(ppResponse);
            PH_UNUSED_VARIABLE(pRspLen);

            wStatus = phhalHw_SamAV2_Cmd_MfWrite(
                ((phalMful_SamAV2_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption,
                pData,
                bDataLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_X */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_X
        case PHAL_MFUL_SAMAV3_X_ID:
            wStatus = phhalHw_SamAV3_Cmd_MF_Write(
                ((phalMful_SamAV3_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption,
                pData,
                bDataLen,
                ppResponse,
                pRspLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_X */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_X_Int_PwdAuthUL(void * pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t * pPassword, uint8_t * pPack, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pStatusCode)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_X
        case PHAL_MFUL_SAMAV2_X_ID:
            PH_UNUSED_VARIABLE(bKeyNo);
            PH_UNUSED_VARIABLE(bKeyVer);
            PH_UNUSED_VARIABLE(pDivInput);
            PH_UNUSED_VARIABLE(bDivInputLen);
            PH_UNUSED_VARIABLE(pStatusCode);

            wStatus = phalMful_Int_PwdAuth(
                pDataParams,
                pPassword,
                pPack);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_X */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_X
        case PHAL_MFUL_SAMAV3_X_ID:
            if(bOption == PHAL_MFUL_CMD_PWD_AUTH_DIV_OFF)
            {
                wStatus = phalMful_Int_PwdAuth(
                    pDataParams,
                    pPassword,
                    pPack);
            }
            else
            {
                wStatus = phhalHw_SamAV3_Cmd_UL_PwdAuthUL(
                    ((phalMful_SamAV3_X_DataParams_t *) pDataParams)->pHalSamDataParams,
                    bKeyNo,
                    bKeyVer,
                    pDivInput,
                    bDivInputLen,
                    pStatusCode);
            }
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_X */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

#endif /* NXPBUILD__PHAL_MFUL_SAM_NONX */
