/*
 * Copyright 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Sam X implementation of MIFARE (R) application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFPEVX_SAM_X_INT_H
#define PHALMFPEVX_SAM_X_INT_H

#include <ph_Status.h>
#include <phalMfpEVx.h>

/* Sam maximum single frame size. */
#define PHAL_MFPEVX_SAM_DATA_FRAME_LENGTH               224U        /* Maximum data that can be exchanged in case of secure messaging computation by SAM. */

#define PHAL_MFPEVX_SAM_X_SESSION_TMAC_ENC              0x01U   /**< Option to perform generate the TMAC session encryption keys. */
#define PHAL_MFPEVX_SAM_X_SESSION_TMAC_MAC              0x02U   /**< Option to perform generate the TMAC session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFPEVX_RESOLVE_DATAPARAMS(DataParams)  ((phalMfpEVx_SamAV3_X_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#define PHAL_MFPEVX_RESOLVE_HAL_DATAPARAMS(DataParams)                                                                                          \
            (PH_GET_COMPID(DataParams) == PHAL_MFPEVX_SAMAV3_X_ID) ? ((phalMfpEVx_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :     \
            NULL

phStatus_t phalMfpEVx_Sam_X_Int_CardExchange(void * pDataParams, uint16_t wOption, uint8_t bIsoLayer, uint8_t * pPayload,
    uint16_t wPayloadLen, uint8_t ** ppResponse, uint16_t * pRespLen, uint8_t * pPiccErrCode);

phStatus_t phalMfpEVx_Sam_X_Int_MFP_Authenticate(void * pDataParams, uint8_t bLayer4Comm, uint8_t bFirstAuth, uint8_t bKdf, uint16_t wBlockNr,
    uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCap2In, uint8_t bPcdCap2InLen,
    uint8_t * pPcdCap2Out, uint8_t * pPdCap2);

phStatus_t phalMfpEVx_Sam_X_Int_CombinedReadMFP(void * pDataParams, uint8_t bCmdCode, uint16_t wBlockNr,
    uint8_t bNumBlocks, uint8_t * pBlocks);

phStatus_t phalMfpEVx_Sam_X_Int_MFP_CombinedWrite(void * pDataParams, uint8_t bCmdCode, uint16_t wSrcBlockNr, uint16_t wDstBlockNr, uint8_t * pData,
    uint8_t bDataLen,uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_Int_WriteExtMfc(void * pDataParams, uint8_t bCmdCode, uint8_t bBlockNo, uint8_t * pValue, uint8_t wValueLen,
    uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_ConvertNak(phStatus_t wStatus);

phStatus_t phalMfpEVx_Sam_X_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
    uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfpEVx_Sam_X_Int_CollectTMI(void * pDataParams, uint8_t * pCmdBuf, uint16_t wCmdLen, uint8_t * pData, uint16_t wDataLen);

#endif /* PHALMFPEVX_SAMAV3_X_INT_H */
