/*
 * Copyright 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFDFEVX_SAM_NONX_INT_H
#define PHALMFDFEVX_SAM_NONX_INT_H

#include <phalMfdfEVx.h>
#include <phhalHw_SamAV3_Cmd.h>

/** MIFARE DESFire EVx frame lengths */
#define PHALMFDFEVX_SAM_DATA_FRAME_LENGTH                   224U    /* Maximum data that can be exchanged in case of secure messaging computation by SAM. */

#define PHALMFDFEVX_TEMPORARY_BUFFER_SIZE                   256U    /* Minimum internal buffer size for processing command / data. */

/** MIFARE DESFire EVx ISO 7816-4 wrapped response information */
#define PHALMFDFEVX_RESP_WRAPPED_MSB_BYTE                   0x9100U   /* MSB response information in case of Iso7816 wrapping of Native commands. */

/** MIFARE DESFire EVx Sam Non X command options. This flag will be used to compute the response. */
#define PHALMFDFEVX_SAM_NONX_CMD_OPTION_NONE                0U      /**< Command option as None. This flag is used to discard the processing of last command exchange. */
#define PHALMFDFEVX_SAM_NONX_CMD_OPTION_COMPLETE            1U      /**< Command option as complete. This flag is used to check the response other than AF. */
#define PHALMFDFEVX_SAM_NONX_CMD_OPTION_PENDING             2U      /**< Command option as complete. This flag is used to check for AF response. */

/** MIFARE DESFire EVx Sam Non X command options. This flag will be used to compute the MAc on command or not. */
#define PHALMFDFEVX_SAM_NONX_NO_MAC_ON_CMD                  0x00    /**< Mac on command is not available. */
#define PHALMFDFEVX_SAM_NONX_MAC_ON_CMD                     0x01    /**< Mac on command is available. */
#define PHALMFDFEVX_SAM_NONX_EXCHANGE_DATA_PICC             0x02    /**< Exchange the data to PICC. */
#define PHALMFDFEVX_SAM_NONX_EXCHANGE_PICC_STATUS           0x10    /**< Exchange the status. */
#define PHALMFDFEVX_SAM_NONX_RETURN_CHAINING_STATUS         0x20    /**< Return the chaining status to the user if available. */
#define PHALMFDFEVX_SAM_NONX_EXCHANGE_WITHOUT_SM            0x40    /**< Exchange the information to / from PICC with Secure messaging in command or response. */
#define PHALMFDFEVX_SAM_NONX_PICC_STATUS_WRAPPED            0x80    /**< The PICC status is wrapped. */

#define PHAL_MFDFEVX_IGNORE_PICC_STATUS_CHECK               0x0080  /**< This flags specifies the generic internal wrapping interface not to validate the PICC error codes. */
#define PHAL_MFDFEVX_SAM_NONX_SESSION_TMAC_ENC              0x01    /**< Option to perform generate the TMAC session encryption keys. */
#define PHAL_MFDFEVX_SAM_NONX_SESSION_TMAC_MAC              0x02    /**< Option to perform generate the TMAC session MAC keys. */
#define PHAL_MFDFEVX_SAM_NONX_SESSION_ENC                   0x01    /**< Option to perform generate the SDM session encryption keys. */
#define PHAL_MFDFEVX_SAM_NONX_SESSION_MAC                   0x02    /**< Option to perform generate the SDM session MAC keys. */

#define PHAL_MFDFEVX_RESP_PD_CHAL_SIZE                      16U     /**< MFDFEVX Authenticate First response buffer size. */

/* Resolves the Hal component to be used for communicating with Sam hardware in NonX mode. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_HAL_DATAPARAMS(DataParams)                                                                                                 \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_NonX_DataParams_t *) DataParams)->pHalSamDataParams :     \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve Temporary Buffer. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TEMPORARY_BUFFER(DataParams)                                                                                               \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_NonX_DataParams_t *) DataParams)->pTmpBuffer :            \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve Temporary Buffer Size. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TEMPORARY_BUFFER_SIZE(DataParams)                                                                                          \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_NonX_DataParams_t *) DataParams)->wTmpBufSize :           \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve TMI DataParams. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_TMI_DATAPARAMS(DataParams)                                                                                                 \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_NonX_DataParams_t *) DataParams)->pTMIDataParams :        \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Resolve PAL MIFARE DataParams. */
#ifndef NXPBUILD__PHAL_MFDFEVX_INTERNAL
#define PHAL_MFDFEVX_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)                                                                                          \
            (PH_GET_COMPID(DataParams) == PHAL_MFDFEVX_SAMAV3_NONX_ID) ? ((phalMfdfEVx_SamAV3_NonX_DataParams_t *) DataParams)->pPalMifareDataParams :  \
            NULL
#endif /* NXPBUILD__PHAL_MFDFEVX_INTERNAL */

/* Valid SAM's NVM and RAM KeyStore Keys numbers */
#define IS_VALID_SAM_KEYS(Key)              ((Key) > 0x7FU) && (((Key) < 0xE0U) || ((Key) > 0xE3U))

/* Valid SAM's RAM KeyStore Keys numbers */
#define IS_VALID_SAM_RAM_KEYS(Key)          ((Key) < 0xE0U) || ((Key) > 0xE3U)

/* APP level keys are invalid between 0x0D to 0x21. */
#define IS_INVALID_APP_KEY(keyNo) ((((keyNo) & 0x7f) > 0x0D)    && (((keyNo) & 0x7f) < 0x21))

/* VC keys are invalid after 0x23. */
#define IS_INVALID_VC_KEY(keyNo)    (((keyNo) & 0x7f) > 0x23)





void phalMfdfEVx_Sam_NonX_Int_SetCmdCode(void * pDataParams, uint8_t bCmdCode);

void phalMfdfEVx_Sam_NonX_Int_SetAuthMode(void * pDataParams, uint8_t bAuthMode);

uint8_t phalMfdfEVx_Sam_NonX_Int_GetAuthMode(void * pDataParams);

void phalMfdfEVx_Sam_NonX_Int_SetKeyNo(void * pDataParams, uint8_t bKeyNo);

uint8_t phalMfdfEVx_Sam_NonX_Int_GetKeyNo(void * pDataParams);

void phalMfdfEVx_Sam_NonX_Int_SetFabID(void * pDataParams, uint8_t bFabID);

uint8_t phalMfdfEVx_Sam_NonX_Int_GetFabID(void * pDataParams);

void phalMfdfEVx_Sam_NonX_Int_SetAdditionalInfo(void * pDataParams, uint16_t wValue);

uint16_t phalMfdfEVx_Sam_NonX_Int_GetAdditionalInfo(void * pDataParams);

void phalMfdfEVx_Sam_NonX_Int_SetUID(void * pDataParams, uint8_t *pUid, uint8_t bUidLen);

void phalMfdfEVx_Sam_NonX_Int_SetAID(void * pDataParams, uint8_t * pAID);

void phalMfdfEVx_Sam_NonX_Int_GetAID(void * pDataParams, uint8_t ** ppAID);

void phalMfdfEVx_Sam_NonX_Int_SetWrappedMode(void * pDataParams, uint8_t bWrappedMode);

uint8_t phalMfdfEVx_Sam_NonX_Int_GetWrappedMode(void * pDataParams);

void phalMfdfEVx_Sam_NonX_Int_SetExtendedLenApdu(void * pDataParams, uint8_t bExtendedLenApdu);

uint8_t phalMfdfEVx_Sam_NonX_Int_GetExtendedLenApdu(void * pDataParams);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ValidateResponse(void * pDataParams, uint16_t wStatus, uint16_t wPiccRetCode);

phStatus_t phalMfdfEVx_Sam_NonX_Int_CardExchange(void * pDataParams, uint16_t wBufferOption, uint8_t bCmdOption, uint16_t wTotDataLen,
    uint8_t bExchangeLE, uint8_t * pData, uint16_t wDataLen, uint8_t ** ppResponse, uint16_t * pRespLen, uint8_t * pPiccErrCode);





phStatus_t phalMfdfEVx_Sam_NonX_Int_GenerateSM(void * pDataParams, uint16_t wOption, uint8_t bIsWriteCmd, uint8_t bIsReadCmd,
    uint8_t bCommMode, uint8_t * pCmdBuff, uint16_t wCmdBufLen, uint8_t * pData, uint16_t wDataLen, uint8_t ** ppOutBuffer,
    uint16_t * pOutBufLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_VerifySM(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint32_t dwLength,
    uint8_t * pResponse, uint16_t wRespLen, uint8_t bPiccStat, uint8_t * pRespMac, uint16_t wRespMacLen,
    uint8_t ** ppOutBuffer, uint16_t * pOutBufLen);





phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePICC(void * pDataParams, uint8_t bAuthType, uint16_t wOption, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn,
    uint8_t bPcdCapsInLen, uint8_t * pPCDCap2, uint8_t * pPDCap2);

phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePDC(void * pDataParams, uint8_t bRfu, uint8_t bKeyNoCard, uint16_t wKeyNum,
    uint16_t wKeyVer, uint8_t bUpgradeInfo);





phStatus_t phalMfdfEVx_Sam_NonX_Int_ChangeKey(void * pDataParams, uint8_t bCmdType, uint16_t wOption, uint8_t bKeySetNo,
    uint8_t bKeyNoCard, uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer,
    uint8_t * pDivInput, uint8_t bDivInputLen);





phStatus_t phalMfdfEVx_Sam_NonX_Int_ReadData(void * pDataParams, uint16_t wOption, uint8_t bIsDataCmd, uint8_t bCmd_ComMode,
    uint8_t bResp_ComMode, uint32_t dwLength, uint8_t * pCmdBuff, uint16_t wCmdLen, uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_WriteData(void * pDataParams, uint16_t wOption, uint8_t bIsDataCmd, uint8_t bCmd_ComMode,
    uint8_t bResp_ComMode, uint8_t bResetAuth, uint8_t * pCmdBuff, uint16_t wCmdLen, uint8_t * pData, uint32_t dwDataLen,
    uint8_t ** ppResponse, uint16_t * pRespLen);





phStatus_t phalMfdfEVx_Sam_NonX_Int_CreateTransactionMacFile(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption,
    uint8_t * pAccessRights, uint8_t bTMKeyOption, uint8_t bKeyNo, uint8_t bKeyVer, uint8_t * pTMKey, uint8_t * pDivInput,
    uint8_t bDivInputLen);





phStatus_t phalMfdfEVx_Sam_NonX_Int_ResetAuthStatus(void * pDataParams);

phStatus_t phalMfdfEVx_Sam_NonX_Int_GetFrameLen(void * pDataParams, uint16_t * pFrameLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_GetKeyInfo(void * pDataParams, uint8_t bKeyNo, uint16_t * pKeyType, uint16_t * pSET,
    uint16_t * pExtSET);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ComputeTMACSessionVectors(void * pDataParams, uint8_t bOption, uint16_t wSrcKeyNo,
    uint16_t wSrcKeyVer, uint16_t wDstKeyNo, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ComputeSDMSessionVectors(void * pDataParams, uint8_t bOption, uint8_t bSdmOption,
    uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr);

phStatus_t phalMfdfEVx_Sam_NonX_Int_LoadSDMInitVector(void * pDataParams, uint8_t * pSDMReadCtr);





phStatus_t phalMfdfEVx_Sam_NonX_Int_KillAuthentication(void * pDataParams, uint8_t bOption);

phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePICC_Part1(void* pDataParams, uint8_t bOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bAuthMode, uint8_t* pDivInput, uint8_t bDivInputLen, uint8_t* pCardResponse, uint16_t wCardRespLen,
    uint8_t** pSamResponse, uint16_t* wSamRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePICC_Part2(void* pDataParams, uint8_t bPiccErrorCode, uint8_t * pCardResponse,
    uint8_t bCardRespLen, uint8_t * pPDcap2, uint8_t * pPCDcap2, uint8_t * pStatusCode);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ChangeKeyPICC(void * pDataParams, uint8_t bCryptoMethod, uint8_t bConfig, uint8_t bKeySetNo,
    uint16_t bDFKeyNo, uint16_t bCurrKeyNo, uint16_t bCurrKeyVer, uint16_t bNewKeyNo, uint16_t bNewKeyVer, uint8_t * pDivInput,
    uint8_t bDivInputLen, uint8_t ** ppSamResponse, uint16_t * pSamRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_CreateTMFilePICC(void * pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t bTMKeyOptions, uint8_t * pDivInput, uint8_t bDivInputLen,
    uint8_t ** ppSamResponse, uint16_t * pSamRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ApplySM(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t bOffset,
    uint8_t bCmdCtrIncr, uint8_t * pTxData, uint8_t bTxDataLen, uint8_t ** ppRxData, uint16_t * pRxDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_RemoveSM(void * pDataParams, uint16_t wOption, uint8_t bCommMode, uint8_t * pTxData,
    uint8_t bTxDataLen, uint8_t ** ppRxData, uint16_t * pRxDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_EncipherData(void * pDataParams, uint16_t wOption, uint8_t * pPlainData, uint8_t bPlainDataLen,
    uint8_t bOffset, uint8_t ** ppEncData, uint16_t * pEncDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_DecipherData(void * pDataParams, uint16_t wOption, uint8_t * pEncData, uint8_t bEncDataLen,
    uint8_t * pLength, uint8_t ** ppPlainData, uint16_t * pPlainDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_GenerateMAC(void * pDataParams, uint16_t wOption, uint8_t bNum, uint8_t * pTxData,
    uint8_t bTxDataLen, uint8_t ** ppRxData, uint16_t * pRxDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_VerifyMAC(void * pDataParams, uint16_t wOption, uint8_t bNum, uint8_t * pTxData,
    uint8_t bTxDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_IsoAuthenticatePICC_Part1(void* pDataParams, uint8_t bOption, uint16_t bKeyNo, uint16_t bKeyVer,
    uint8_t * pCardResponse, uint8_t bCardRespLen, uint8_t ** ppSamResponse, uint16_t * pSamRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_IsoAuthenticatePICC_Part2(void* pDataParams, uint8_t * pCardResponse, uint8_t bCardRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_CommitReaderID_Part1(void* pDataParams, uint8_t bState, uint16_t wBlockNr,
    uint8_t** ppResponse, uint16_t* pRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_CommitReaderID_Part2(void* pDataParams, uint8_t bPiccErrCode,
    uint8_t* pData, uint8_t bDataLen, uint8_t* pPiccReturnCode);

phStatus_t phalMfdfEVx_Sam_NonX_Int_GetKeyEntry(void* pDataParams, uint8_t bKeyNo, uint8_t bMode, uint8_t* pKeyEntry,
    uint8_t* pKeyEntryLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_GetRandom(void* pDataParams, uint8_t bExpLen, uint8_t* pRnd);

phStatus_t phalMfdfEVx_Sam_NonX_Int_DumpSecretKey(void* pDataParams, uint8_t bDumpMode, uint8_t bKeyNo, uint8_t bKeyVer,
    uint8_t* pDivInput, uint8_t bDivInputLen, uint8_t* pSecretKey, uint16_t* pSecretKeyLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_ActivateOfflineKey(void* pDataParams, uint8_t bOption, uint8_t bKeyNo, uint8_t bKeyV,
    uint8_t* pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_EncipherOfflineData(void* pDataParams, uint16_t wOption, uint8_t* pPlainData,
    uint8_t bPlainDataLen, uint8_t** ppEncData, uint16_t* pEncDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePDC_Part1(void* pDataParams, uint8_t bOption, uint8_t bKeyNo,
    uint8_t bKeyVer, uint8_t* pPDChal, uint8_t bPDChalLen, uint8_t* pUpgradeInfo, uint8_t bLen, uint8_t* pDivInput,
    uint8_t bDivInputLen, uint8_t** ppPCDChalResp, uint16_t* pPCDChalRespLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_AuthenticatePDC_Part2(void* pDataParams, uint8_t bPiccErrCode, uint8_t* pPDResp,
    uint8_t bPDRespLen, uint8_t* pPiccReturnCode);

phStatus_t phalMfdfEVx_Sam_NonX_Int_DecipherOfflineData(void* pDataParams, uint16_t wOption, uint8_t* pEncData,
    uint8_t bEncDataLen, uint8_t** ppPlainData, uint16_t* pPlainDataLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_DeriveKey(void* pDataParams, uint8_t bSrcKeyNo, uint8_t bSrcKeyVer,
    uint8_t bDstKeyNo, uint8_t* pDeriveIn, uint8_t bDeriveInLen);

phStatus_t phalMfdfEVx_Sam_NonX_Int_LoadInitVector(void* pDataParams, uint8_t bOption, uint8_t* pData, uint8_t bDataLen);
#endif /* PHALMFDFEVX_SAM_NONX_INT_H */
