/*
 * Copyright 2009 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Sam implementation of MIFARE (R) application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 19. May 2009
 *
 */

#ifndef PHALMFC_SAM_X_INT_H
#define PHALMFC_SAM_X_INT_H

#include <ph_Status.h>
#include <phalMfc.h>
#include <phhalHw_SamAV2_Cmd.h>
#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
#include <phhalHw_SamAV3_Cmd.h>
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

/* Resolves the PAL X component to be used for communicating with Sam hardware in X mode. */
#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHAL_MFC_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)																									\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ? ((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ? ((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			NULL
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHAL_MFC_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)																									\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ? ((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			NULL
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

/* Performs a Read command based on the Sam hardware being connected. */
#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHHAL_HW_SAM_CMD_MF_READ(DataParams, Blocks, BlockLen, Data, DataLen)																				\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfRead(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, PHHAL_HW_SAMAV2_CMD_CHANGE_MFREAD_SINGLEBLOCK,	\
					Blocks, BlockLen, Data, DataLen) :																										\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MF_Read(((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen, Data,							\
					DataLen) :																																\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHHAL_HW_SAM_CMD_MF_READ(DataParams, Blocks, BlockLen, Data, DataLen)																				\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfRead(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, PHHAL_HW_SAMAV2_CMD_CHANGE_MFREAD_SINGLEBLOCK,	\
					Blocks, BlockLen, Data, DataLen) :																										\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Write command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_WRITE(DataParams, Blocks, BlockLen, Response, RespLen)																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfWrite(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, PHHAL_HW_SAMAV2_CMD_CHANGE_MFWRITE_TYPE_DEFAULT, \
					Blocks, BlockLen) :																														\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MF_Write(((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, (PHHAL_HW_SAMAV3_CMD_MF_WRITE_CLASSIC |			\
					PHHAL_HW_SAMAV3_CMD_MF_WRITE_TMDATA_RETURNED),																							\
					Blocks, BlockLen, Response, RespLen) :																									\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Write command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_WRITE(DataParams, Blocks, BlockLen, Response, RespLen)																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfWrite(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, PHHAL_HW_SAMAV2_CMD_CHANGE_MFWRITE_TYPE_DEFAULT, \
					Blocks, BlockLen) :																														\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Increment and a Transfer command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_INCREMENT(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfIncrement(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MF_Increment(((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, 											\
					PHHAL_HW_SAMAV3_CMD_MF_INCREMENT_TMDATA_RETURNED, Blocks, BlockLen, Response, RespLen) :												\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Increment and a Transfer command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_INCREMENT(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfIncrement(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Decrement and a Transfer command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_DECREMENT(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfDecrement(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MF_Decrement(((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams,												\
					PHHAL_HW_SAMAV3_CMD_MF_DECREMENT_TMDATA_RETURNED, Blocks, BlockLen, Response, RespLen) :												\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
/* Performs a Decrement and a Transfer command based on the Sam hardware being connected. */
#define PHHAL_HW_SAM_CMD_MF_DECREMENT(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfDecrement(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

/* Performs a Restore and a Transfer command based on the Sam hardware being connected. */
#ifdef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHHAL_HW_SAM_CMD_MF_RESTORE(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfRestore(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MF_Restore(((phalMfc_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams,												\
					PHHAL_HW_SAMAV3_CMD_MF_RESTORE_TMDATA_RETURNED, Blocks, BlockLen, Response, RespLen) :													\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFC_SAMAV3_X
#define PHHAL_HW_SAM_CMD_MF_RESTORE(DataParams, Blocks, BlockLen, Response, RespLen)																		\
			(PH_GET_COMPID(DataParams) == PHAL_MFC_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfRestore(((phalMfc_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlockLen) :							\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFC)
#endif /* NXPBUILD__PHAL_MFC_SAMAV3_X */

#endif /* PHALMFC_SAM_X_INT_H */
