/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef PHALMFNTAG42XDNA_SAM_X_INT_H
#define PHALMFNTAG42XDNA_SAM_X_INT_H

#include <phalMfNtag42XDna.h>

#define PHAL_MFNTAG42XDNA_SAM_DATA_FRAME_LENGTH		224	/* Maximum data that can be exchanged in case of secure messaging computation by SAM. */
#define PHAL_MFNTAG42XDNA_RESET_AUTH_OFF			0	/* Do not reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFNTAG42XDNA_RESET_AUTH_ON				1	/* Reset the internal parameters and Kill the PICC authentication */
#define PHAL_MFNTAG42XDNA_MAX_WRITE_LEN				124	/* The default frame size is 224 bytes. So if the Write related commands need to transmitted to the PICC via SAM,
														 * the command including the data to be written and excluding PICC header comes to 124 bytes.
														 */

#define PHAL_MFNTAG42XDNA_SAM_X_SESSION_ENC			1	/**< Optionto perform generate the SDM session encryption keys. */
#define PHAL_MFNTAG42XDNA_SAM_X_SESSION_MAC			2	/**< Optionto perform generate the SDM session MAC keys. */

/* Resolves the component to be used. */
#define PHAL_MFNTAG42XDNA_RESOLVE_DATAPARAMS(DataParams)	((phalMfNtag42XDna_SamAV3_X_DataParams_t *) DataParams)

/* Resolves the Hal component to be used for communicating with Sam hardware in X mode. */
#define PHAL_MFNTAG42XDNA_RESOLVE_HAL_DATAPARAMS(DataParams)																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFNTAG42XDNA_SAMAV3_X_ID) ? ((phalMfNtag42XDna_SamAV3_X_DataParams_t *) DataParams)->pHalSamDataParams :	\
			NULL

phStatus_t phalMfNtag42XDna_Sam_X_Int_ValidateResponse(void * pDataParams, uint8_t bResetAuth, uint16_t wStatus, uint8_t * pPiccRetCode);

phStatus_t phalMfNtag42XDna_Sam_X_Int_Iso7816Wrap(uint8_t bLengthPresent, uint8_t bLengthLen, uint8_t bLePresent, uint32_t dwTotDataLen,
	uint8_t * pPlainData, uint16_t * pDataLen);

phStatus_t phalMfNtag42XDna_Sam_X_Int_ResetAuthentication(void * pDataParams);

phStatus_t phalMfNtag42XDna_Sam_X_Int_ComputeSDMSessionVectors(void * pDataParams, uint8_t bOption, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr);

phStatus_t phalMfNtag42XDna_Sam_X_Int_LoadSDMInitVector(void * pDataParams, uint8_t * pSDMReadCtr);

#endif /* PHALMFNTAG42XDNA_SAM_X_INT_H */
