﻿/*
 * Copyright 2017 - 2020, 2022 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of both Software and SamNonX implementation of ICode (R) application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  CHu: Generated 02. January 2017
 *
 */

#ifndef PHALICODE_INT_H
#define PHALICODE_INT_H

#include <ph_Status.h>

/* ICode product's command codes. */
#define PHAL_ICODE_CMD_READ_SINGLE_BLOCK                            0x20U   /**< ICode command code for ReadSingleBlock command. */
#define PHAL_ICODE_CMD_WRITE_SINGLE_BLOCK                           0x21U   /**< ICode command code for WriteSingleBlock command. */
#define PHAL_ICODE_CMD_LOCK_BLOCK                                   0x22U   /**< ICode command code for LockBlock command. */
#define PHAL_ICODE_CMD_READ_MULTIPLE_BLOCKS                         0x23U   /**< ICode command code for ReadMultipleBlock command. */
#define PHAL_ICODE_CMD_WRITE_AFI                                    0x27U   /**< ICode command code for WriteAFI command. */
#define PHAL_ICODE_CMD_LOCK_AFI                                     0x28U   /**< ICode command code for LockAFI command. */
#define PHAL_ICODE_CMD_WRITE_DSFID                                  0x29U   /**< ICode command code for WriteDSFID command. */
#define PHAL_ICODE_CMD_LOCK_DSFID                                   0x2AU   /**< ICode command code for LockDSFID command. */
#define PHAL_ICODE_CMD_GET_SYSTEM_INFORMATION                       0x2BU   /**< ICode command code for GetSystemInformation command. */
#define PHAL_ICODE_CMD_GET_MULTIPLE_BLOCK_SECURITY_STATUS           0x2CU   /**< ICode command code for GetMultipleBlockSecurityStatus command. */
#define PHAL_ICODE_CMD_FAST_READ_MULTIPLE_BLOCKS                    0x2DU   /**< ICODE command code for FastReadMultipleBlocks command. */
#define PHAL_ICODE_CMD_EXTENDED_READ_SINGLE_BLOCK                   0x30U   /**< ICode command code for ExtendedReadSingleBlock command. */
#define PHAL_ICODE_CMD_EXTENDED_WRITE_SINGLE_BLOCK                  0x31U   /**< ICode command code for ExtendedWriteSingleBlock command. */
#define PHAL_ICODE_CMD_EXTENDED_LOCK_BLOCK                          0x32U   /**< ICode command code for ExtendedLockSingleBlock command. */
#define PHAL_ICODE_CMD_EXTENDED_READ_MULTIPLE_BLOCKS                0x33U   /**< ICode command code for ExtendedReadMultipleBlock command. */
#define PHAL_ICODE_CMD_AUTHENTICATE                                 0x35U   /**< ICODE command code for Authenticate command. */
#define PHAL_ICODE_CMD_CHALLENGE                                    0x39U   /**< ICODE command code for Challenge command. */
#define PHAL_ICODE_CMD_READ_BUFFER                                  0x3AU   /**< ICODE command code for Read Buffer command. */
#define PHAL_ICODE_CMD_EXTENDED_GET_SYSTEM_INFORMATION              0x3BU   /**< ICODE command code for ExtendedGetSystemInformation command. */
#define PHAL_ICODE_CMD_EXTENDED_GET_MULTIPLE_BLOCK_SECURITY_STATUS  0x3CU   /**< ICODE command code for ExtendedGetMultipleBlockSecurityStatus command. */
#define PHAL_ICODE_CMD_EXTENDED_FAST_READ_MULTIPLE_BLOCKS           0x3DU   /**< ICODE command code for ExtendedFastReadMultipleBlocks command. */
#define PHAL_ICODE_CMD_SET_EAS                                      0xA2U   /**< ICode command code for SetEAS command. */
#define PHAL_ICODE_CMD_RESET_EAS                                    0xA3U   /**< ICode command code for ResetEAS command. */
#define PHAL_ICODE_CMD_LOCK_EAS                                     0xA4U   /**< ICode command code for LockEAS command. */
#define PHAL_ICODE_CMD_EAS_ALARM                                    0xA5U   /**< ICode command code for EASAlarm command. */
#define PHAL_ICODE_CMD_PASSWORD_PROTECT_EAS_AFI                     0xA6U   /**< ICode command code for PasswordProtectEAS command. */
#define PHAL_ICODE_CMD_WRITE_EAS_ID                                 0xA7U   /**< ICode command code for WriteEASID command. */
#define PHAL_ICODE_CMD_READ_EPC                                     0xA8U   /**< ICode command code for ReadEPC command. */
#define PHAL_ICODE_CMD_GET_NXP_SYSTEM_INFORMATION                   0xABU   /**< ICode command code for GetNXPSystemInformation command. */
#define PHAL_ICODE_CMD_GET_RANDOM_NUMBER                            0xB2U   /**< ICode command code for GetRandomNumber command. */
#define PHAL_ICODE_CMD_SET_PASSWORD                                 0xB3U   /**< ICode command code for SetPassword command. */
#define PHAL_ICODE_CMD_WRITE_PASSWORD                               0xB4U   /**< ICode command code for WritePassword command. */
#define PHAL_ICODE_CMD_LOCK_PASSWORD                                0xB5U   /**< ICode command code for LockPassword command. */
#define PHAL_ICODE_CMD_PROTECT_PAGE                                 0xB6U   /**< ICode command code for ProtectPage command. */
#define PHAL_ICODE_CMD_LOCK_PAGE_PROTECTION_CONDITION               0xB7U   /**< ICode command code for LockPageProtectionCondition command. */
#define PHAL_ICODE_CMD_GET_MULTIPLE_BLOCK_PROTECTION_STATUS         0xB8U   /**< ICode command code for GetMultipleBlockProtectionStatus command. */
#define PHAL_ICODE_CMD_DESTROY                                      0xB9U   /**< ICode command code for Destroy command. */
#define PHAL_ICODE_CMD_ENABLE_PRIVACY                               0xBAU   /**< ICode command code for EnablePrivacy command. */
#define PHAL_ICODE_CMD_64_BIT_PASSWORD_PROTECTION                   0xBBU   /**< ICode command code for 64-BitPasswordProtection command. */
#define PHAL_ICODE_CMD_READ_SIGNATURE                               0xBDU   /**< ICode command code for ReadSignature command. */
#define PHAL_ICODE_CMD_READ_CONFIG                                  0xC0U   /**< ICODE command code for Read Config command. */
#define PHAL_ICODE_CMD_WRITE_CONFIG                                 0xC1U   /**< ICODE command code for Write Config command. */
#define PHAL_ICODE_CMD_PICK_RANDOM_ID                               0xC2U   /**< ICODE command code for Pick Random Id command. */
#define PHAL_ICODE_CMD_READ_TT                                      0xC4U   /**< ICODE command code for ReadTT command. */
#define PHAL_ICODE_CMD_PARAMETER_REQUEST                            0xD0U   /**< ICODE command code for Parameter Request command. */
#define PHAL_ICODE_CMD_PARAMETER_SELECT                             0xD1U   /**< ICODE command code for Parameter Select command. */
#define PHAL_ICODE_CMD_READ_SRAM                                    0xD2U   /**< ICODE command code for Read SRAM command. */
#define PHAL_ICODE_CMD_WRITE_SRAM                                   0xD3U   /**< ICODE command code for Write SRAM command. */
#define PHAL_ICODE_CMD_I2CM_WRITE                                   0xD4U   /**< ICODE command code for I2CM Write command. */
#define PHAL_ICODE_CMD_I2CM_READ                                    0xD5U   /**< ICODE command code for I2CM Read command. */

#define PHAL_ICODE_RANDOM_NUMBER_MIN_SIZE                           10U     /**< Authenticate and Challenge minimum Random number size. */
#define PHAL_ICODE_RANDOM_NUMBER_MAX_SIZE                           62U     /**< Authenticate and Challenge maximum Random number size. */
#define PHAL_ICODE_RANDOM_NUMBER_SIZE_TAM                           0x0AU   /**< Challenge Size for TAM Authentication. This involves TAM1 and TAM2. */
#define PHAL_ICODE_RANDOM_NUMBER_SIZE_MAM                           0x0AU   /**< Challenge Size for TAM Authentication. This involves MAM1 and MAM2. */
#define PHAL_ICODE_MAX_BLOCKS                                       256U    /**< Maximum blocks supported by I15693 specification. */
#define PHAL_ICODE_MAX_BLOCKS_EXTENDED                              512U    /**< Maximum blocks supported by I15693 specification for Extended operations. */
#define PHAL_ICODE_MAX_BLOCKS_CM1_OPTION_FLAG_NOT_SET               60U     /**< Maximum block data that can be read using CM1 reader when Option flag is not set. */
#define PHAL_ICODE_MAX_BLOCKS_CM1_OPTION_FLAG_SET                   40U     /**< Maximum block data that can be read using CM1 reader when Option flag is set. */
#define PHAL_ICODE_MAX_I2C_DATA_SIZE                                256U    /**< Maximum data size that can be transmitted or received using I2C Transparent Channel commands. */

/* Authenticate constants for Tag and mutual authentication. */
#define PHAL_ICODE_CONST_TAM1                                       0x96C5U /**< Macro value for Tag authentication 1 constant value. */
#define PHAL_ICODE_CONST_MAM1                                       0xDA83U /**< Macro value for Mutual authentication 1 constant value. */
#define PHAL_ICODE_CONST_MAM2                                       0xDA80U /**< Macro value for Mutual authentication 2 constant value. */

#define PHAL_ICODE_AUTHPROC_TAM                                     0x00U   /**< Macro value for authentication option as Tag Authentication. */
#define PHAL_ICODE_AUTHPROC_MAM                                     0x02U   /**< Macro value for authentication option as Mutual Authentication. */
#define PHAL_ICODE_CSI_AES                                          0x00U   /**< Macro to represent the value of the CSI (AES Crypto Suite). */
#define PHAL_ICODE_TAM_CUSTOMDATA_CLEAR                             0x00U   /**< Macro to represent the custom data value for Tag authentication cleared. */
#define PHAL_ICODE_TAM_CUSTOMDATA_SET                               0x01U   /**< Macro to represent the custom data value for Tag authentication set. */
#define PHAL_ICODE_MAM1_STEP                                        0x00U   /**< Macro to represent the first step value for Mutual authentication. */
#define PHAL_ICODE_MAM2_STEP                                        0x04U   /**< Macro to represent the first second value for Mutual authentication. */



#ifndef NXPBUILD__PHAL_ICODE_INTERNAL
#define PHAL_ICODE_VALIDATE_AUTHTYPE(AuthType)              PH_UNUSED_VARIABLE(AuthType)
#define PHAL_ICODE_VALIDATE_CHALLENGETYPE(ChallengeType)    PH_UNUSED_VARIABLE(ChallengeType)
#endif /* NXPBUILD__PHAL_ICODE_INTERNAL */



phStatus_t phalICode_Int_SetOptionBit(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bUpdateTiming);

phStatus_t phalICode_Int_WriteAlikeHandling(void * pPalSli15693DataParams, phStatus_t wExchangeStatus);

phStatus_t phalICode_Int_ComputeErrorCode(void * pPalSli15693DataParams, phStatus_t wStatus);

phStatus_t phalICode_Int_GetFlags(void * pPalSli15693DataParams, uint16_t * pFlags);

phStatus_t phalICode_Int_SetChallengeType(void * pDataParams, uint8_t bChallengeType);

phStatus_t phalICode_Int_GetChallengeType(void * pDataParams, uint8_t * pChallengeType);

phStatus_t phalICode_Int_SetFast_DataRate(void * pPalSli15693DataParams, uint16_t *pDataRate);

phStatus_t phalICode_Int_ReadBlocks(void * pPalSli15693DataParams, uint8_t bCmdCode, uint8_t bEnableBuffering, uint8_t bUpdateTiming,
    uint8_t bOption, uint16_t wBlockNo, uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);

void phalICode_Int_Reverse(uint8_t * pData, uint16_t wLength);





phStatus_t phalICode_Int_ReadSingleBlock(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bBlockNo, uint8_t ** ppData,
    uint16_t * pDataLen);

phStatus_t phalICode_Int_WriteSingleBlock(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bBlockNo, uint8_t * pData,
    uint8_t bDataLen);

phStatus_t phalICode_Int_LockBlock(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bBlockNo);

phStatus_t phalICode_Int_ReadMultipleBlocks(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Int_WriteAFI(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bAfi);

phStatus_t phalICode_Int_LockAFI(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_WriteDSFID(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bDsfid);

phStatus_t phalICode_Int_LockDSFID(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_GetSystemInformation(void * pPalSli15693DataParams, uint8_t ** ppSystemInfo, uint16_t * pSystemInfoLen);

phStatus_t phalICode_Int_GetMultipleBlockSecurityStatus(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bBlockNo,
    uint8_t bNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Int_FastReadMultipleBlocks(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption,
    uint8_t bBlockNo, uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Int_ExtendedReadSingleBlock(void * pPalSli15693DataParams, uint8_t bOption, uint16_t wBlockNo, uint8_t ** ppData,
    uint16_t * pDataLen);

phStatus_t phalICode_Int_ExtendedWriteSingleBlock(void * pPalSli15693DataParams, uint8_t bOption, uint16_t wBlockNo, uint8_t * pData,
    uint8_t bDataLen);

phStatus_t phalICode_Int_ExtendedLockBlock(void * pPalSli15693DataParams, uint8_t bOption, uint16_t wBlockNo);

phStatus_t phalICode_Int_ExtendedReadMultipleBlocks(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption,
    uint16_t wBlockNo, uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);


#ifdef NXPBUILD__PH_CRYPTOSYM
phStatus_t phalICode_Int_Challenge(void * pPalSli15693DataParams, void * pCryptoRngDataParams, uint16_t wOption, uint8_t bChallengeType,
    uint16_t wTimeout, uint16_t wTimeout_Unit, uint8_t bKeyID_CertNum, uint8_t * pChallenge, uint16_t wChallengeLen, uint8_t * pRnd);

phStatus_t phalICode_Int_ReadBuffer(uint16_t wCompID, void * pPalSli15693DataParams, void * pCryptoDataParams, void * pKeyStoreDataParams,
    uint8_t * pRndNo, uint8_t bChallengeType, uint8_t bVerify, uint8_t bKeyNo, uint8_t bKeyVer, uint8_t ** ppResponse, uint16_t * pRespLen);
#endif /* NXPBUILD__PH_CRYPTOSYM */

phStatus_t phalICode_Int_ExtendedGetSystemInformation(void * pPalSli15693DataParams, uint8_t bInfoParams, uint8_t ** ppSystemInfo,
    uint16_t * pSystemInfoLen);

phStatus_t phalICode_Int_ExtendedGetMultipleBlockSecurityStatus(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint16_t wBlockNo,
    uint16_t wNoOfBlocks, uint8_t * pStatus, uint16_t * pStatusLen);

phStatus_t phalICode_Int_ExtendedFastReadMultipleBlocks(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption,
    uint16_t wBlockNo, uint16_t wNumBlocks, uint8_t * pData, uint16_t * pDataLen);





phStatus_t phalICode_Int_SetEAS(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_ResetEAS(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_LockEAS(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_EASAlarm(void * pPalSli15693DataParams, uint8_t bOption, uint8_t * pEasIdValue, uint8_t bEasIdMaskLen,
    uint8_t ** ppEas, uint16_t * pEasLen);

phStatus_t phalICode_Int_PasswordProtectEAS(void * pPalSli15693DataParams);

phStatus_t phalICode_Int_PasswordProtectAFI(void * pPalSli15693DataParams);

phStatus_t phalICode_Int_WriteEAS_ID(void * pPalSli15693DataParams, uint8_t bOption, uint8_t * pEasIdValue);

phStatus_t phalICode_Int_ReadEPC(void * pPalSli15693DataParams, uint8_t ** ppEpc, uint16_t * pEpcLen);

phStatus_t phalICode_Int_GetNXPSystemInformation(void * pPalSli15693DataParams, uint8_t ** ppSystemInfo, uint16_t * pSystemInfoLen);

phStatus_t phalICode_Int_GetRandomNumber(void * pPalSli15693DataParams, uint8_t ** ppRnd, uint16_t * pRndLen);

phStatus_t phalICode_Int_SetPassword(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bPwdIdentifier, uint8_t * pXorPwd);

phStatus_t phalICode_Int_WritePassword(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bPwdIdentifier, uint8_t * pPwd);

phStatus_t phalICode_Int_LockPassword(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bPwdIdentifier);

phStatus_t phalICode_Int_ProtectPage(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bPPAdd_PageNo, uint8_t bProtectionStatus);

phStatus_t phalICode_Int_LockPageProtectionCondition(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bPageNo);

phStatus_t phalICode_Int_GetMultipleBlockProtectionStatus(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bBlockNo,
    uint8_t bNoOfBlocks, uint8_t * pProtectionStates, uint16_t * pNumReceivedStates);

phStatus_t phalICode_Int_Destroy(void * pPalSli15693DataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Int_EnablePrivacy(void * pPalSli15693DataParams, uint8_t bOption, uint8_t * pXorPwd);

phStatus_t phalICode_Int_64BitPasswordProtection(void * pPalSli15693DataParams, uint8_t bOption);

phStatus_t phalICode_Int_ReadSignature(void * pPalSli15693DataParams, uint8_t ** ppSign, uint16_t * pSignLen);

phStatus_t phalICode_Int_ReadConfig(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bBlockAddr, uint8_t bNoOfBlocks,
    uint8_t ** ppData, uint16_t * pDataLen);

phStatus_t phalICode_Int_WriteConfig(void * pPalSli15693DataParams, uint8_t bOption, uint8_t bBlockAddr, uint8_t * pData);

phStatus_t phalICode_Int_PickRandomID(void * pPalSli15693DataParams);

phStatus_t phalICode_Int_ReadTT(void * pPalSli15693DataParams, uint8_t bOption, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phalICode_Int_ParameterRequest(void * pPalSli15693DataParams, uint8_t * pBitRate, uint8_t * pTiming);

phStatus_t phalICode_Int_ParameterSelect(void * pPalSli15693DataParams, uint8_t bBitRate, uint8_t bTiming);

phStatus_t phalICode_Int_ReadSRAM(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t * pDataLen);

phStatus_t phalICode_Int_WriteSRAM(void * pPalSli15693DataParams, uint8_t bEnableBuffering, uint8_t bOption, uint8_t bBlockNo,
    uint8_t bNumBlocks, uint8_t * pData, uint16_t wDataLen);

phStatus_t phalICode_Int_I2CMRead (void * pPalSli15693DataParams, uint8_t bI2CParam, uint16_t wDataLen, uint8_t * pData);

phStatus_t phalICode_Int_I2CMWrite (void * pPalSli15693DataParams, uint8_t bI2CParam, uint8_t * pData, uint16_t wDataLen);






phStatus_t phalICode_Int_GetTagType(void * pPalSli15693DataParams, uint16_t * pTagType);
#endif /* PHALICODE_INT_H */
