/*
 * Copyright 2010 - 2017, 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic Felica Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  RSn: Generated 26. January 2010
 *
 */

#include <phalFelica.h>
#include <phhalHw.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHAL_FELICA_SW
#include "Sw/phalFelica_Sw.h"
#endif /* NXPBUILD__PHAL_FELICA_SW */

#ifdef NXPBUILD__PHAL_FELICA

phStatus_t phalFelica_RequestResponse(
					void * pDataParams,
					uint8_t * pMode
				)
{
	phStatus_t PH_MEMLOC_REM status;

	PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalFelica_RequestResponse");
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pMode);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pMode);

	/* Check data parameters */
	if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_FELICA)
	{
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);

	    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
		PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
		PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
	}

	/* perform operation on active layer */
	switch (PH_GET_COMPID(pDataParams))
	{
#ifdef NXPBUILD__PHAL_FELICA_SW
	case PHAL_FELICA_SW_ID:
        status = phalFelica_Sw_RequestResponse((phalFelica_Sw_DataParams_t *)pDataParams, pMode);
		break;
#endif /* NXPBUILD__PHAL_FELICA_SW */

	default:
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);
		break;
	}

	PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if ((status & PH_ERR_MASK) == PH_ERR_SUCCESS)
	{
		PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pMode_log, pMode, 1);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

	return status;
}

phStatus_t phalFelica_RequestService(
                    void * pDataParams,
                    uint8_t  bTxNumServices,
                    uint8_t* pTxServiceList,
                    uint8_t* pRxNumServices,
                    uint8_t* pRxServiceList
                )
{
	phStatus_t PH_MEMLOC_REM status;

	PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalFelica_RequestService");
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxServiceList);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRxServiceList);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pTxServiceList_log, pTxServiceList, bTxNumServices);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pTxServiceList);
	PH_ASSERT_NULL (pRxNumServices);
	PH_ASSERT_NULL (pRxServiceList);

	/* Check data parameters */
	if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_FELICA)
	{
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);

	    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
		PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
		PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

		return status;
	}

	/* perform operation on active layer */
	switch (PH_GET_COMPID(pDataParams))
	{
#ifdef NXPBUILD__PHAL_FELICA_SW
	case PHAL_FELICA_SW_ID:
        status = phalFelica_Sw_RequestService((phalFelica_Sw_DataParams_t *)pDataParams, bTxNumServices, pTxServiceList, pRxNumServices, pRxServiceList);
		break;
#endif /* NXPBUILD__PHAL_FELICA_SW */

	default:
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);
		break;
	}

	PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pRxServiceList_log, pRxServiceList, *pRxNumServices);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

	return status;
}

phStatus_t phalFelica_Read(
                    void * pDataParams,
                    uint8_t  bNumServices,
                    uint8_t* pServiceList,
                    uint8_t  bTxNumBlocks,
                    uint8_t* pBlockList,
                    uint8_t  bBlockListLength,
                    uint8_t* pRxNumBlocks,
                    uint8_t* pBlockData
                )
{
	phStatus_t PH_MEMLOC_REM status;

	PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalFelica_Read");
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pServiceList);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pBlockList);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pBlockData);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pServiceList_log, pServiceList, bNumServices);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pBlockList_log, pBlockList, bBlockListLength);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pServiceList);
	PH_ASSERT_NULL (pBlockList);
	PH_ASSERT_NULL (pRxNumBlocks);
	PH_ASSERT_NULL (pBlockData);

	/* Check data parameters */
	if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_FELICA)
	{
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);

	    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
		PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
		PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

		return status;
	}

	/* perform operation on active layer */
	switch (PH_GET_COMPID(pDataParams))
	{
#ifdef NXPBUILD__PHAL_FELICA_SW
	case PHAL_FELICA_SW_ID:
        status = phalFelica_Sw_Read((phalFelica_Sw_DataParams_t *)pDataParams, bNumServices, pServiceList, bTxNumBlocks, pBlockList, bBlockListLength, pRxNumBlocks, pBlockData);
		break;
#endif /* NXPBUILD__PHAL_FELICA_SW */

	default:
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);
		break;
	}

	PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if ((status & PH_ERR_MASK) == PH_ERR_SUCCESS)
	{
		PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, pBlockData_log, pBlockData, *pRxNumBlocks);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

	return status;
}

phStatus_t phalFelica_Write(
                    void * pDataParams,
                    uint8_t  bNumServices,
                    uint8_t* pServiceList,
                    uint8_t  bNumBlocks,
                    uint8_t* pBlockList,
                    uint8_t  bBlockListLength,
                    uint8_t* pBlockData
                 )
{
	phStatus_t PH_MEMLOC_REM status;

	PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalFelica_Write");
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pServiceList);
	PH_LOG_HELPER_ALLOCATE_PARAMNAME(pBlockData);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pServiceList_log, pServiceList, bNumServices);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_INFO, pBlockData_log, pBlockData, bBlockListLength);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pServiceList);
	PH_ASSERT_NULL (pBlockList);
	PH_ASSERT_NULL (pBlockData);

	/* Check data parameters */
	if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_FELICA)
	{
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);

	    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
		PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
		PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

		return status;
	}

	/* perform operation on active layer */
	switch (PH_GET_COMPID(pDataParams))
	{
#ifdef NXPBUILD__PHAL_FELICA_SW
	case PHAL_FELICA_SW_ID:
        status = phalFelica_Sw_Write((phalFelica_Sw_DataParams_t *)pDataParams,  bNumServices, pServiceList, bNumBlocks, pBlockList, bBlockListLength, pBlockData);
		break;
#endif /* NXPBUILD__PHAL_FELICA_SW */

	default:
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);
		break;
	}

	PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

	return status;
}

phStatus_t phalFelica_GetConfig(
                                   void* pDataParams,
                                   uint16_t wConfig,
                                   uint16_t* pValue
                                   )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phalFelica_GetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wConfig_log, &wConfig);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
	PH_ASSERT_NULL (pDataParams);
	PH_ASSERT_NULL (pValue);

    /* Check data parameters */
    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_AL_FELICA)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_FELICA_SW
    case PHAL_FELICA_SW_ID:
        status = phalFelica_Sw_GetConfig((phalFelica_Sw_DataParams_t *)pDataParams, wConfig, pValue );
        break;
#endif /* NXPBUILD__PHAL_FELICA_SW */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_FELICA);
        break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if ((status & PH_ERR_MASK) == PH_ERR_SUCCESS)
    {
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pValue_log, pValue);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}


#endif /* NXPBUILD__PHAL_FELICA */
