/*
 * Copyright 2010 - 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software Felica Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  RSn: Generated 26. January 2010
 *
 */

#ifndef PHALFELICA_SW_H
#define PHALFELICA_SW_H

#include <ph_Status.h>

phStatus_t phalFelica_Sw_RequestResponse(
                    phalFelica_Sw_DataParams_t * pDataParams,   /**< [In] Pointer to this layers parameter structure. */
					uint8_t * pMode     	                    /**< [Out] number of received data bytes. */
										);

phStatus_t phalFelica_Sw_RequestService(
                    phalFelica_Sw_DataParams_t * pDataParams,   /**< [In] Pointer to this layers parameter structure. */
                    uint8_t  bTxNumServices,    /**< [IN] */
                    uint8_t* pTxServiceList,    /**< [IN] */
                    uint8_t* pRxNumServices,    /**< [OUT] */
                    uint8_t* pRxServiceList     /**< [OUT] */
                          );

phStatus_t phalFelica_Sw_Read(
                    phalFelica_Sw_DataParams_t * pDataParams,   /**< [In] Pointer to this layers parameter structure. */
                    uint8_t  bNumServices,      /**< [IN] */
                    uint8_t* pServiceList,      /**< [IN] */
                    uint8_t  bTxNumBlocks,      /**< [IN] */
                    uint8_t* pBlockList,        /**< [IN] */
                    uint8_t  bBlockListLength,  /**< [IN] */
                    uint8_t* pRxNumBlocks,      /**< [OUT] */
                    uint8_t* pBlockData         /**< [OUT] */
                );

phStatus_t phalFelica_Sw_Write(
                    phalFelica_Sw_DataParams_t * pDataParams,   /**< [In] Pointer to this layers parameter structure. */
                    uint8_t  bNumServices,      /**< [IN] */
                    uint8_t* pServiceList,      /**< [IN] */
                    uint8_t  bNumBlocks,        /**< [IN] */
                    uint8_t* pBlockList,        /**< [IN] */
                    uint8_t  bBlockListLength,  /**< [IN] */
                    uint8_t* pBlockData         /**< [IN] */
                 );

phStatus_t phalFelica_Sw_GetConfig(
                                      phalFelica_Sw_DataParams_t* pDataParams,
                                      uint16_t wConfig,
                                      uint16_t* pValue
                                      );


#endif /* PHALFELICA_SW_H */
