/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RC632 functions of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHKEYSTORE_RC632_H
#define PHKEYSTORE_RC632_H

#include <ph_Status.h>
#include <phhalHw.h>
#include <phKeyStore.h>

phStatus_t phKeyStore_Rc632_FormatKeyEntry(
    phKeyStore_Rc632_DataParams_t * pDataParams,
    uint16_t wKeyNo,
    uint16_t wNewKeyType
    );

phStatus_t phKeyStore_Rc632_SetKey(
                                   phKeyStore_Rc632_DataParams_t * pDataParams,
                                   uint16_t wKeyNo,
                                   uint16_t wKeyVersion,
                                   uint16_t wKeyType,
                                   uint8_t * pNewKey,
                                   uint16_t wNewKeyVersion
                                   );

phStatus_t phKeyStore_Rc632_SetKeyAtPos(
                                        phKeyStore_Rc632_DataParams_t * pDataParams,
                                        uint16_t wKeyNo,
                                        uint16_t wPos,
                                        uint16_t wKeyType,
                                        uint8_t * pNewKey,
                                        uint16_t wNewKeyVersion
                                        );

phStatus_t phKeyStore_Rc632_SetKUC(
                                   phKeyStore_Rc632_DataParams_t * pDataParams,
                                   uint16_t wKeyNo,
                                   uint16_t wRefNoKUC
                                   );

phStatus_t phKeyStore_Rc632_SetFullKeyEntry(
    phKeyStore_Rc632_DataParams_t * pDataParams,
    uint16_t wNoOfKeys,
    uint16_t wKeyNo,
    uint16_t wNewRefNoKUC,
    uint16_t wNewKeyType,
    uint8_t * pNewKeys,
    uint16_t * pNewKeyVersionList
    );

phStatus_t phKeyStore_Rc632_GetKeyEntry(
                                        phKeyStore_Rc632_DataParams_t * pDataParams,
                                        uint16_t wKeyNo,
                                        uint16_t wKeyVersionBufSize,
                                        uint16_t * wKeyVersion,
                                        uint16_t * wKeyVersionLength,
                                        uint16_t * pKeyType
                                        );

phStatus_t phKeyStore_Rc632_GetKey(
                                   phKeyStore_Rc632_DataParams_t * pDataParams,
                                   uint16_t wKeyNo,
                                   uint16_t wKeyVersion,
                                   uint8_t bKeyBufSize,
                                   uint8_t * pKey,
                                   uint16_t * pKeyType
                                   );


phStatus_t phKeyStore_Rc632_SetConfig(
                                      phKeyStore_Rc632_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t wValue
                                      );

phStatus_t phKeyStore_Rc632_SetConfigStr(
                                         phKeyStore_Rc632_DataParams_t * pDataParams,
                                         uint16_t wConfig,
                                         uint8_t *pBuffer,
                                         uint16_t wBufferLength
                                         );

phStatus_t phKeyStore_Rc632_GetConfig(
                                      phKeyStore_Rc632_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint16_t * pValue
                                      );

phStatus_t phKeyStore_Rc632_GetConfigStr(
                                         phKeyStore_Rc632_DataParams_t * pDataParams,
                                         uint16_t wConfig,
                                         uint8_t ** ppBuffer,
                                         uint16_t * pBufferLength
                                         );

phStatus_t phKeyStore_Rc632_ChangeKUC(
                                      phKeyStore_Rc632_DataParams_t * pDataParams,
                                      uint16_t wRefNoKUC,
                                      uint32_t dwLimit
                                      );

phStatus_t phKeyStore_Rc632_GetKUC(
                                   phKeyStore_Rc632_DataParams_t * pDataParams,
                                   uint16_t wRefNoKUC,
                                   uint32_t * pdwLimit,
                                   uint32_t * pdwCurVal
                                   );

#endif /* PHKEYSTORE_RC632_H */
