/******************************************************************************
*
*   (c) Copyright 2014 Freescale Semiconductor, Inc.
*   All Rights Reserved.
*
******************************************************************************/
/*!
*
* @file     GDFLIB_FilterMA.h
*
* @version  1.0.6.0
*
* @date     Mar-10-2014
*
* @brief    Header file for GDFLIB_FilterMA function
*
******************************************************************************/
#ifndef GDFLIB_FILTERMA_H
#define GDFLIB_FILTERMA_H

#ifdef __cplusplus
extern "C" {
#endif

/**
* @page misra_violations MISRA-C:2004 violations
*
* @section GDFLIB_FilterMA_h_REF_1
* Violates MISRA 2004 Required Rule 19.4, Disallowed definition for macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of disallowed macro
* definition.
*
* @section GDFLIB_FilterMA_h_REF_2
* Violates MISRA 2004 Advisory Rule 19.7, Function-like macro defined.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires the function-like macro
* definition.
*
* @section GDFLIB_FilterMA_h_REF_3
* Violates MISRA 2004 Required Rule 19.10, Unparenthesized macro parameter in definition of macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of unparenthesized
* macro parameters.
*
* @section GDFLIB_FilterMA_h_REF_4
* Violates MISRA 2004 Advisory Rule 19.13, #/##' operator used in macro.
* To allow the user utilize the benefits of using all three supported implementation of each
* function in user application, the macro dispatcher inevitably requires use of '#/##' operators.
*/
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_MacroDisp.h"
#include "mlib.h"

/****************************************************************************
* Defines and macros            (scope: module-local)
****************************************************************************/
  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
  * parameter in definition of macro.
  */
  #define GDFLIB_FilterMAInit(...)     macro_dispatcher(GDFLIB_FilterMAInit, __VA_ARGS__)(__VA_ARGS__)     /*!< This function clears the internal filter accumulator. */
  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
  * parameter in definition of macro.
  */
  #define GDFLIB_FilterMA(...)         macro_dispatcher(GDFLIB_FilterMA, __VA_ARGS__)(__VA_ARGS__)         /*!< This function implements a moving average recursive filter. */

  #if (SWLIBS_DEFAULT_IMPLEMENTATION == SWLIBS_DEFAULT_IMPLEMENTATION_F32)
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    */
    #define GDFLIB_FILTER_MA_T                        GDFLIB_FILTER_MA_T_F32                        /*!< Definition of GDFLIB_FILTER_MA_T as alias for GDFLIB_FILTER_MA_T_F32 datatype in case the 32-bit fractional implementation is selected. */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    */
    #define GDFLIB_FILTER_MA_DEFAULT                  GDFLIB_FILTER_MA_DEFAULT_F32                  /*!< Definition of GDFLIB_FILTER_MA_DEFAULT as alias for GDFLIB_FILTER_MA_DEFAULT_F32 default value in case the 32-bit fractional implementation is selected. */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
    * defined.
    * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGDFLIB00122 */
    #define GDFLIB_FilterMAInit_Dsptchr_1(pParam)     GDFLIB_FilterMAInit_Dsptchr_2(pParam,F32)     /*!< Function dispatcher for GDFLIB_FilterMAInit_Dsptchr_1, do not modify!!! */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
    * defined.
    * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGDFLIB00108 */
    #define GDFLIB_FilterMA_Dsptchr_2(In,pParam)      GDFLIB_FilterMA_Dsptchr_3(In,pParam,F32)      /*!< Function dispatcher for GDFLIB_FilterMA_Dsptchr_2, do not modify!!! */
  #endif
  #if (SWLIBS_DEFAULT_IMPLEMENTATION == SWLIBS_DEFAULT_IMPLEMENTATION_F16)
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    */
    #define GDFLIB_FILTER_MA_T                        GDFLIB_FILTER_MA_T_F16                        /*!< Definition of GDFLIB_FILTER_MA_T as alias for GDFLIB_FILTER_MA_T_F16 datatype in case the 16-bit fractional implementation is selected. */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    */
    #define GDFLIB_FILTER_MA_DEFAULT                  GDFLIB_FILTER_MA_DEFAULT_F16                  /*!< Definition of GDFLIB_FILTER_MA_DEFAULT as alias for GDFLIB_FILTER_MA_DEFAULT_F16 default value in case the 16-bit fractional implementation is selected. */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
    * defined.
    * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGDFLIB00122 */
    #define GDFLIB_FilterMAInit_Dsptchr_1(pParam)     GDFLIB_FilterMAInit_Dsptchr_2(pParam,F16)     /*!< Function dispatcher for GDFLIB_FilterMAInit_Dsptchr_1, do not modify!!! */
    /*
    * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition
    * for macro.
    * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
    * defined.
    * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
    * parameter in definition of macro.
    */
    /** @remarks Implements DGDFLIB00108 */
    #define GDFLIB_FilterMA_Dsptchr_2(In,pParam)      GDFLIB_FilterMA_Dsptchr_3(In,pParam,F16)      /*!< Function dispatcher for GDFLIB_FilterMA_Dsptchr_2, do not modify!!! */
  #endif

  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
  * parameter in definition of macro.
  */
  #define GDFLIB_FilterMAInit_Dsptchr_2(pParam,Impl)    GDFLIB_FilterMAInit_Dsptchr_(pParam,Impl)     /*!< Function dispatcher for GDFLIB_FilterMAInit_Dsptchr_2, do not modify!!! */
  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_4 MISRA 2004 Advisory Rule 19.13, #/##' operator used in
  * macro.
  */
  /** @remarks Implements DGDFLIB00129 */
  #define GDFLIB_FilterMAInit_Dsptchr_(pParam,Impl)     GDFLIB_FilterMAInit_##Impl(pParam)            /*!< Function dispatcher for GDFLIB_FilterMAInit_Dsptchr_, do not modify!!! */

  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
  * parameter in definition of macro.
  */
  #define GDFLIB_FilterMA_Dsptchr_3(In,pParam,Impl)     GDFLIB_FilterMA_Dsptchr_(In,pParam,Impl)      /*!< Function dispatcher for GDFLIB_FilterMA_Dsptchr_3, do not modify!!! */
  /*
  * @violates @ref GDFLIB_FilterMA_h_REF_1 MISRA 2004 Required Rule 19.4, Disallowed definition for
  * macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_2 MISRA 2004 Advisory Rule 19.7, Function-like macro
  * defined.
  * @violates @ref GDFLIB_FilterMA_h_REF_3 MISRA 2004 Required Rule 19.10, Unparenthesized macro
  * parameter in definition of macro.
  * @violates @ref GDFLIB_FilterMA_h_REF_4 MISRA 2004 Advisory Rule 19.13, #/##' operator used in
  * macro.
  */
  /** @remarks Implements DGDFLIB00116 */
  #define GDFLIB_FilterMA_Dsptchr_(In,pParam,Impl)      GDFLIB_FilterMA_##Impl(In,pParam)             /*!< Function dispatcher for GDFLIB_FilterMA_Dsptchr_, do not modify!!! */

/******************************************************************************
* Typedefs and structures       (scope: module-local)
******************************************************************************/




/******************************************************************************
* Implementation variant: 32-bit fractional
******************************************************************************/
#if (SWLIBS_SUPPORT_F32 == SWLIBS_STD_ON)
  #define GDFLIB_FILTER_MA_DEFAULT_F32   {0,0}  /*!< Default value for GDFLIB_FILTER_MA_T_F32. */

  /************************************************************************/
  /*!
  @struct GDFLIB_FILTER_MA_T_F32 "\GDFLIB_FilterMA.h"

  @brief  Structure containing filter buffer and coefficients.
  *//**********************************************************************/
  /** @remarks Implements DGDFLIB00127, DGDFLIB00114, DGDFLIB00110, DGDFLIB00113, DGDFLIB00124 */
  typedef struct{
    tFrac32   f32Acc;        /*!< Filter accumulator. */
    tU16      u16NSamples;   /*!< Number of samples for averaging, filter sample window [0,31].*/
  }GDFLIB_FILTER_MA_T_F32;

  /****************************************************************************
  * Exported function prototypes
  ****************************************************************************/
  extern void GDFLIB_FilterMAInit_F32(GDFLIB_FILTER_MA_T_F32 *pParam);
  extern tFrac32 GDFLIB_FilterMA_F32(tFrac32 f32In, GDFLIB_FILTER_MA_T_F32 *pParam);
#endif /* SWLIBS_SUPPORT_F32 == SWLIBS_STD_ON */




/******************************************************************************
* Implementation variant: 16-bit fractional
******************************************************************************/
#if (SWLIBS_SUPPORT_F16 == SWLIBS_STD_ON)
  #define GDFLIB_FILTER_MA_DEFAULT_F16   {0,0}  /*!< Default value for GDFLIB_FILTER_MA_T_F16. */

  /************************************************************************/
  /*!
  @struct GDFLIB_FILTER_MA_T_F16 "\GDFLIB_FilterMA.h"

  @brief  Structure containing filter buffer and coefficients.
  *//**********************************************************************/
  /** @remarks Implements DGDFLIB00127, DGDFLIB00114, DGDFLIB00111, DGDFLIB00113, DGDFLIB00125 */
  typedef struct{
    tFrac32   f32Acc;         /*!< Filter accumulator. */
    tU16      u16NSamples;    /*!< Number of samples for averaging, filter sample window [0,15].*/
  }GDFLIB_FILTER_MA_T_F16;

  /****************************************************************************
  * Exported function prototypes
  ****************************************************************************/
  extern void GDFLIB_FilterMAInit_F16(GDFLIB_FILTER_MA_T_F16 *pParam);
  extern tFrac16 GDFLIB_FilterMA_F16(tFrac16 f16In, GDFLIB_FILTER_MA_T_F16 *pParam);
#endif /* SWLIBS_SUPPORT_F16 == SWLIBS_STD_ON */




#ifdef __cplusplus
}
#endif

#endif /* GDFLIB_FILTERMA_H */
