/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*
*  File Name: USB_Desc.h
*                                                                          
*  Description: This file is to store USB descriptor       			    
*           
*                                                                          
*  Assembler:  Codewarrior for HC(S)08 V6.0
*                                            
*  Version: 1.0                                                         
*                                                                                
*                                                                          
*  Author: Patrick Yang                              
*                                                                                       
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.09  Patrick Yang  Initial version
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/





#include "derivative.h"


/********************************************************************
*********************************************************************
*       ICP Device Descriptor
*********************************************************************
********************************************************************/
const byte Device_Descriptor[18]= 
{
	0x12,		      //blength
	0x01,		      //bDescriptor
	0x00,0x02,	  //bcdUSB ver R=2.00 
	0x00,		      //bDeviceClass
	0x00,		      //bDeviceSubClass			
	0x00,		      //bDeviceProtocol			
	0x10,		      //bMaxPacketSize0
	0xA2,0x15,	  //idVendor - 0x15A2(freescale Vendor ID)
	0x37,0x00,	  //idProduct
	0x00,0x01,	  //bcdDevice - Version 1.00
	0x01,		      //iManufacturer - Index to string descriptor
	0x02,		      //iProduct - Index to string descriptor
	0x00,		      //iSerialNumber - Index to string descriptor
	0x01	       	//bNumConfigurations - # of config. at current speed,
};




/********************************************************************
*********************************************************************
*       ICP Configuration Descriptor
*********************************************************************
********************************************************************/
const byte Configuration_Descriptor[32]= 
{
	0x09,		      //blength
	0x02,		      //bDescriptor
	0x20,0x00,	  //wTotalLength - # of bytes including interface and endpoint descpt.
	0x01,		      //bNumInterfaces - at least 1 data interface
	0x01,		      //bConfigurationValue - 
	0x00,		      //iConfiguration - index to string descriptor	
	0x80,		      //bmAttributes - 0x?0	bit 7-bus powered
				        //						        bit 6-self powered
				        //						        bit 5-remote wakeup
				        //						        bit 4-0-reserved
	0x64,		      //bMaxPower - 200mA
	
// ======================================================
// 		Standard Interface Descriptor
// ======================================================

	0x09,		      //blength
	0x04,		      //bDescriptorType - Interface descriptor
	0x00,		      //bInterfaceNumber - Zero based value identifying the index of the config.
	0x00,		      //bAlternateSetting;
	0x02,		      //bNumEndpoints - 2 endpoints
	0x08,		      //bInterfaceClass - mass storage 
	0x06,		      //bInterfaceSubClass - SCSI Transparent command Set
	0x50,		      //bInterfaceProtocol - Bulk-Only transport
	0x00,		      //iInterface - Index to String descriptor
	
// ======================================================
// 		Standard Endpoint Descriptor
//    	Bulk IN Endpoint
// ======================================================
	0x07,		      //bLength;
	0x05,		      //bDescriptorType - Endpoint descriptor
	0x81,		      //bEndpointAddress - bit 3..0 endpoint number
				        // 					         bit 6..4 Reserved reset to zero
				        //					         bit 7	0-OUT, 1-IN									
	0x02,		      //bmAttributes _ Bulk endpoint
	0x40,0x00,	  //wMaxPacketSize - 64 byte packet size
	0x00,		      //bInterval - do not apply to BULK endpoint
	
// ======================================================
// 		Standard Endpoint Descriptor
//    	Bulk OUT Endpoint
// ======================================================
	0x07,		      //bLength;
	0x05,		      //bDescriptorType - Endpoint descriptor
	0x02,		      //bEndpointAddress - bit 3..0 endpoint number
				        // 					         bit 6..4 Reserved reset to zero
				        //					         bit 7	0-OUT, 1-IN									
	0x02,		      //bmAttributes _ Bulk endpoint
	0x40,0x00,	  //wMaxPacketSize - 64 byte packet size
	0x00,		      //bInterval - do not apply to BULK endpoint	
 
};



// ======================================================
//
// 		String Descriptor Zero
//
// ======================================================
const byte String_Descriptor0[4] = {
	0x04,		      //bLength;
	0x03,		      //bDescriptorType - STRING descriptor
	0x09,0x04,	  //wLANDID0 - English (American)
};

// ======================================================
//
// 		String Descriptor one
//
// ======================================================
const byte String_Descriptor1[] = {
	0x14,			    //bLength; 11 bytes
	0x03,		      //bDescriptorType - STRING descriptor
	'F',0x00,	    // "F"
	'r',0x00,	    // "r"
	'e',0x00,	    // "e"
	'e',0x00,	    // "e"
	's',0x00,	    // "s"
	'c',0x00,	    // "c"
	'a',0x00,	    // "a"
	'l',0x00,	    // "l"
	'e',0x00,	    // "e"
};	 


// ======================================================
//
// 		String Descriptor two
//
// ======================================================
const byte String_Descriptor2[] = {
	0x0A,			    //bLength;
	0x03,		      //bDescriptorType - STRING descriptor
	'J',0x00,	    // JM60
	'M',0x00,	
	'6',0x00,	
	'0',0x00,
};	 




const byte* String_Table[3] = {
		String_Descriptor0,					// String #0
		String_Descriptor1,					// String #1
		String_Descriptor2					// String #2
};		

