/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor China Ltd. 2008
*  ALL RIGHTS RESERVED
*
*  File Name: SCSI_Process.H
*                                                                          
*  Description: Header file for SCSI_Process.C
*                                                                                     
*  Assembler:  Codewarrior for HC(S)08 V6.0
*                                            
*  Version: 1.0                                                         
*                                                                                                                                                        
*  Author: Patrick Yang                              
*                                                                                       
*  Location: Shanghai, P.R.China                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.0   2008.01.02  Patrick Yang  Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#ifndef SCSI_Process_H
#define SCSI_Process_H



/***********************************************
**
**		Subroutines Definition
**
************************************************/

void Send_CSW(void);

void SCSI_Process(void);


/***********************************************
**
**		Definition
**
************************************************/

// ======================================================
//
// 		USB Command Block Wrapper CBW Command
//
// ======================================================

#define kCBWSignature0			0		  // dCBWSignature byte 0 position
#define kCBWSignature1			1		  // dCBWSignature byte 1 position
#define kCBWSignature2			2		  // dCBWSignature byte 2 position
#define kCBWSignature3			3		  // dCBWSignature byte 3 position
#define kCBWTag0				    4		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag1				    5		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag2				    6		  // dgUSBMSCBWTage byte 0 position
#define kCBWTag3				    7		  // dgUSBMSCBWTage byte 0 position
#define kCBWXferLength0			8		  // dCBWDataTransferLength byte 0 position
#define kCBWXferLength1			9		  // dCBWDataTransferLength byte 1 position
#define kCBWXferLength2			10		// dCBWDataTransferLength byte 2 position
#define kCBWXferLength3			11		// dCBWDataTransferLength byte 3 position
#define kCBWFlags				    12		// bmCBWFlags byte position
#define kCBWDirection			  0x80	// direction
#define kHost2Device			  0		  // 0-host to device, 1-device to host
#define kCBWLUN					    13		// bCBWLUN byte position
#define kCBWCBLength			  14		// bCBWCBLength byte position
#define kCBWSCSICommand			15		// CBWCB byte position

#define	kSCSI10LBAByte3			17		// LBA byte 3
#define kSCSI10LBAByte2			18		// LBA byte 2
#define kSCSI10LBAByte1			19		// LBA byte 1
#define kSCSI10LBAByte0			20		// LBA byte 0
#define kSCSI10XferLength1	22		// Transfer Length byte 1
#define kSCSI10XferLength0	23		// Transfer Length byte 0


#define	kCSWPass				    0		  // command completed successfully
#define	kCSWFailed				  1		  // command failed



/***********************************************
*
* Public memory declarations
*
************************************************/


#endif SCSI_Process_H