/******************************************************************************								
*    TIM.c                                                                    *								
*                                                                             *								
*       Created on: 05/06/2012                                                *								
*       Author: B34981                                                        *								
*                                                                             *								
*       The Timer module can work as Input Capture or Output Compare. This    *								
*    driver configures four TIM channels as output compares to generate an    *								
*    interrupt at different frequencies.                                      *								
******************************************************************************/								

#include "TIM.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/
extern UINT16 Led_Freq[4];

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    TIM_Init - Initialize the TIM module with four channels executing output compares at 
* 				different frequencies
* @param    none
* @return   none
*
************************************************************************************************/  
void TIM_Init()
{
		
	TIM0TIOS_IOS0 = 1;						// TIMCH0 as output compare
	TIM0TIE_C0I = 1;						// TIMCH0 interrupt enable
	TIM0TFLG1_C0F = 1;						// Clear interrupt flag	
	TIM0TC0 = Led_Freq[0]; 					// Interrupt period

	TIM0TIOS_IOS1 = 1;						// TIMCH1 as output compare
	TIM0TIE_C1I = 1;						// TIMCH1 interrupt enable
	TIM0TFLG1_C1F = 1;						// Clear interrupt flag	
	TIM0TC1 = Led_Freq[1]; 					// Interrupt period
	
	TIM0TIOS_IOS2 = 1;						// TIMCH2 as output compare
	TIM0TIE_C2I = 1;						// TIMCH2 interrupt enable
	TIM0TFLG1_C2F = 1;						// Clear interrupt flag	
	TIM0TC2 = Led_Freq[2]; 					// Interrupt period
	
	TIM0TIOS_IOS3 = 1;						// TIMCH3 as output compare
	TIM0TIE_C3I = 1;						// TIMCH3 interrupt enable
	TIM0TFLG1_C3F = 1;						// Clear interrupt flag	
	TIM0TC3 = Led_Freq[3]; 					// Interrupt period		
	
	TIM0TSCR2_PR = 7;						// Clock Prescaler FBUS/2^PR		
	TIM0TSCR1_PRNT = 1;						// Precision Timer enable
	TIM0PTPSR = 0x50;
	TIM0TSCR1_TEN = 1;						// TIM enable		
}


