/*
 * FTM.h
 *
 *  Created on: Sep 24, 2013
 *      Author: B46911
 */

#ifndef FTM_H_
#define FTM_H_
/*******************************************************************************
* Includes
********************************************************************************/
#include "derivative.h"

/*******************************************************************************
* Constants
********************************************************************************/


/*******************************************************************************
* Macros
********************************************************************************/

                
/*******************************************************************************
* Types
********************************************************************************/


/*******************************************************************************
* Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/


/*******************************************************************************
* Global Functions
********************************************************************************/
/***********************************************************************************************
*
* @brief    FTM_Init - Initialize the FTM counter and enable 4 interrupts (CH0 to CH3)
* @param    none
* @return   none
*
************************************************************************************************/
void FTM_Init(void);

/***********************************************************************************************
*
* @brief    FTM_SetCallback - Set the callback function to call on successful matches from any channel 
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void FTM_SetCallback(pt2FuncU8 ptr);

/***********************************************************************************************
*
* @brief    FTM_SetPeriod - Set the period of the periodic interrupt
* @param    ch - channel to configure, per - period to set
* @return   none
*
************************************************************************************************/
void FTM_SetPeriod(UINT8 ch, UINT16 per);

#endif /* FTM_H_ */
