/*
 * RTC.c
 *
 *  Created on: May 7, 2014
 *      Author: B46911
 */



#include "RTC.h"
/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/
pt2Func RTC_Callback;

/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    RTC_Init - Initialize RTC counter 
* @param    none
* @return   none
*
************************************************************************************************/
void RTC_Init()
{
	SIM_SCGC |=  SIM_SCGC_RTC_MASK;		/* Enable clock for RTC*/
	RTC_SC|=RTC_SC_RTCLKS(0b11);		/* Bus clock selected*/
	RTC_SC|=RTC_SC_RTCPS(0b111);		/* RTC prescaler of 1000, 20Mhz/1000=20 kHz, RTC counter increases every 50 us */
	RTC_SC|=RTC_SC_RTIE_MASK;			/* Enable RTC interrupts*/
	RTC_SC|=RTC_SC_RTCO_MASK;			/* Enable RTCO output*/
	SIM_PINSEL0|=SIM_PINSEL_RTCPS_MASK; /* RTCO in PTC5 */
	RTC_MOD=2000;  						/* Interrupts every 100 ms*/
}

/***********************************************************************************************
*
* @brief    RTC_SetCallback - Set the callback function to call on successful matches from any channel 
* @param    pointer to function
* @return   none
*
************************************************************************************************/  

void RTC_SetCallback(pt2Func ptr)
{
	RTC_Callback = ptr;	
}

/***********************************************************************************************
*
* @brief    RTC_IRQHandler - Interrupt for RTC 
* @param    none
* @return   none
*
************************************************************************************************/
void RTC_IRQHandler()
{
	RTC_SC|=RTC_SC_RTIF_MASK;  /* Clear interrupt flag*/
	RTC_Callback();

}
