/****************************************************************************
 *   $Id:: gpiotest.c 9373 2012-04-19 22:57:34Z nxp41306                    $
 *   Project: NXP LPC11xxLV GPIO example
 *
 *   Description:
 *     This file contains GPIO test modules, main entry, to test GPIO APIs.
 *
 ****************************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.

* Permission to use, copy, modify, and distribute this software and its 
* documentation is hereby granted, under NXP Semiconductors' 
* relevant copyright in the software, without fee, provided that it 
* is used in conjunction with NXP Semiconductors microcontrollers.  This 
* copyright, permission, and disclaimer notice must appear in all copies of 
* this code.
****************************************************************************/
#include "LPC11xxLV.h"			/* LPC11xxLV Peripheral Registers */
#include "gpio.h"

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{
  SystemCoreClockUpdate();

  GPIOInit();
	
  /* Enable Hysteresis to eliminate debouncing. */	
  LPC_IOCON->PIO1_4  |= (0x01<<5);

  /* use port1_4 as input event, interrupt test. */
  GPIOSetDir( PORT1, 4, 0 );
  /* port1_4, single edge trigger, active low. */
  GPIOSetInterrupt( PORT1, 4, 0, 0, 0 );
  GPIOIntEnable( PORT1, 4 );

  while( 1 );
}

/*********************************************************************************
**                            End Of File
*********************************************************************************/
