#include <hidef.h>		 	/* for EnableInterrupts macro */
#include "derivative.h"		/* include peripheral declarations */
#include "keyboard.h" 
#include "pwm.h" 
#include "adc.h"


unsigned long	adc0_cmdlist[2];		
unsigned int 	adc0_results[2]; 	


unsigned int	ADC4=0, PGAOUT_ADC=0;

#define CMD_SEL(x)		((unsigned long)((x)&0x03)<<30)
#define INTFLG_SEL(x)	((unsigned long)((x)&0x0F)<<24)
#define VRH_SEL(x)		((unsigned long)((x)&0x01)<<23)
#define VRL_SEL(x)		((unsigned long)((x)&0x01)<<22)
#define CH_SEL(x)		((unsigned long)((x)&0x3F)<<16)
#define SMP(x)			((unsigned long)((x)&0x1F)<<11)


unsigned char index = 0;

void ADC_init(void){
	
	  adc0_cmdlist[0] = CMD_SEL(0)+INTFLG_SEL(1)+VRH_SEL(1)+VRL_SEL(1)+CH_SEL(20);  
			  // CMD_SEL(0) 	-> Normal Conversion
			  // INTFLG_SEL(1)	-> Conversion Interrupt Flag Select [1]
			  // VRH_SEL(1)		-> VRH_1 input selected as high voltage reference.
			  // VRL_SEL(1)		-> VRL_1 input selected as low voltage reference. 
			  // CH_SEL()		-> ADC4 Channel Select
	  
	  adc0_cmdlist[1] = CMD_SEL(3)+INTFLG_SEL(2)+VRH_SEL(1)+VRL_SEL(1)+CH_SEL(15);   
			  // CMD_SEL(1) 	-> End Of List
			  // INTFLG_SEL(1)	-> Conversion Interrupt Flag Select [2]
			  // VRH_SEL(1)		-> VRH_1 input selected as high voltage reference.
			  // VRL_SEL()		-> VRL_1 input selected as low voltage reference.
			  // CH_SEL()		->PGA_OUT voltage Internal Channel Select
	  
	  
	  
	  // Clear ADC results list -----------------------------------------------------------
	  for (index = 0; index < 2; index++){
		  adc0_results[index] = 0;
	  }
	  
	  
	  // Configure ADC0 control -----------------------------------------------------------
	  ADC0CTL_0_ACC_CFG = 3;		// set dual-access mode */
	  ADC0CTL_0_MOD_CFG = 1;		// select "Trigger Mode" */
	  ADC0CTL_1 = 0x00;		    	// single CSL & RVL buffers, Normal access, No Auto-Restart after exit from STOP */
	  
	  ADC0STS = 0x00;	        	// select CSL 0 and RVL 0
	  ADC0TIM = 0x05;	        	// f_ATDCLK = 32Mhz/(2 x (ADC0TIM_PRS+1)) = 4Mhz 

	  
	  // Configure pointers to ADC0 CSL & RVL ----------------------------------------------
	  ADC0CBP = adc0_cmdlist;
	  ADC0RBP = adc0_results;
	  
	  // Configure 12-bit resolution and right data justification */
	  ADC0FMT = 0x84;
	  ADC0TIM = 0x01;		//f_ATDCLK = 32Mhz/(2x(1+1)= 8MHz


	  // Configure BATS Module (BATE) ---------------------------------------------------
	  BATE_BSUAE = 1;				// BATS VSUP ADC Connection Enable

	  // Start conversion -- ADC0 ---------------------------------------------------------
	  ADC0CTL_0_ADC_EN = 1;			// Enable the ADC 	
	  ADC0FLWCTL_RSTA = 1;			// Restart from top of active Sequence Command List.
	  while(0x07 != ADC0CONIF){} 	// wait until conversion is complete
	  ADC0CONIF = ADC0CONIF;		// clear flag
}


unsigned int ADC_read(void){
	ADC0FLWCTL_TRIG = 1; 			// trigger conversion
	while(0x07 != ADC0CONIF){} 		// wait until conversion is complete
		
	ADC4 =   adc0_results[0];		// Read results ADC Internal Channel VSUP
	PGAOUT_ADC = adc0_results[1];	// Read results ADC Internal Channel AN0_0
	
	ADC0CONIF = ADC0CONIF;			// clear flag
	return PGAOUT_ADC;	

}

