/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : Init_LED.c
**     Project     : DevKit-S12ZVC_IIC_Lab4
**     Processor   : MC9S12ZVCA192MKH
**     Component   : BitsIO
**     Version     : Component 02.108, Driver 03.00, CPU db: 3.00.000
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-07-15, 12:26, # CodeGen: 1
**     Abstract    :
**         This component "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
**         Note: This component is set to work in Output direction only.
**     Settings    :
**         Port name                   : P
**
**         Bit mask of the port        : 0x0070
**         Number of bits/pins         : 3
**         Single bit numbers          : 0 to 2
**         Values range                : 0 to 7
**
**         Initial direction           : Output (direction cannot be changed)
**         Initial output value        : 1 = 001H
**         Initial pull option         : off
**
**         Port data register          : PTP       [0x02F0]
**         Port control register       : DDRP      [0x02F2]
**
**             ----------------------------------------------------
**                   Bit     |   Pin   |   Name
**             ----------------------------------------------------
**                    0      |    41   |   PP4_KWP4_PWM1_1_ETRIG0
**                    1      |    60   |   PP5_KWP5_PWM1_3
**                    2      |    62   |   PP6_KWP6_PWM1_5
**             ----------------------------------------------------
**
**         Optimization for            : speed
**     Contents    :
**         GetDir - bool Init_LED_GetDir(void);
**         GetVal - byte Init_LED_GetVal(void);
**         PutVal - void Init_LED_PutVal(byte Val);
**         GetBit - bool Init_LED_GetBit(byte Bit);
**         PutBit - void Init_LED_PutBit(byte Bit, bool Val);
**         SetBit - void Init_LED_SetBit(byte Bit);
**         ClrBit - void Init_LED_ClrBit(byte Bit);
**         NegBit - void Init_LED_NegBit(byte Bit);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file Init_LED.c
** @version 03.00
** @brief
**         This component "BitsIO" implements a multi-bit input/output.
**         It uses selected pins of one 1-bit to 8-bit port.
**         Note: This component is set to work in Output direction only.
*/         
/*!
**  @addtogroup Init_LED_module Init_LED module documentation
**  @{
*/         

/* MODULE Init_LED. */

#include "Init_LED.h"
  /* Including shared modules, which are used in the whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"

#pragma DATA_SEG Init_LED_DATA         /* Select data segment "Init_LED_DATA" */
#pragma CODE_SEG Init_LED_CODE
#pragma CONST_SEG Init_LED_CONST       /* Constant section for this module */
/*
** ===================================================================
**     Method      :  Init_LED_GetMsk (component BitsIO)
**
**     Description :
**         The method returns a bit mask which corresponds to the 
**         required bit position.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static const byte Init_LED_Table[3U] = { /* Table of mask constants */
   0x10U, 0x20U, 0x40U
};

static byte Init_LED_GetMsk (byte PinIndex)
{
  return (byte)((PinIndex<3U) ? Init_LED_Table[PinIndex] : 0U); /* Check range and return appropriate bit mask */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetVal (component BitsIO)
**     Description :
**         This method returns an input value.
**           a) direction = Input  : reads the input value from the
**                                   pins and returns it
**           b) direction = Output : returns the last written value
**         Note: This component is set to work in Output direction only.
**     Parameters  : None
**     Returns     :
**         ---        - Input value (0 to 7)
** ===================================================================
*/
byte Init_LED_GetVal(void)
{
  return (byte)((getReg8(PTP) & 0x70U) >> 4U); /* Return port data */
}

/*
** ===================================================================
**     Method      :  Init_LED_PutVal (component BitsIO)
**     Description :
**         This method writes the new output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Val        - Output value (0 to 7)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_PutVal(byte Val)
{
  Val = (byte)((Val & 0x07U) << 4U);   /* Mask and shift output value */
  setReg8(PTP, (getReg8(PTP) & (uint8_t)(~(uint8_t)0x70U)) | Val); /* Put masked value on port */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetBit (component BitsIO)
**     Description :
**         This method returns the specified bit of the input value.
**           a) direction = Input  : reads the input value from pins
**                                   and returns the specified bit
**           b) direction = Output : returns the specified bit
**                                   of the last written value
**         Note: This component is set to work in Output direction only.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to read (0 to 2)
**     Returns     :
**         ---        - Value of the specified bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
** ===================================================================
*/
bool Init_LED_GetBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - bit mask to test */
  return (bool)(((getReg8(PTP) & Mask) == Mask)? 1U: 0U); /* Test if specified bit of port register is set */
}

/*
** ===================================================================
**     Method      :  Init_LED_PutBit (component BitsIO)
**     Description :
**         This method writes the new value to the specified bit
**         of the output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit (0 to 2)
**         Val        - New value of the bit (FALSE or TRUE)
**                      FALSE = "0" or "Low", TRUE = "1" or "High"
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_PutBit(byte Bit, bool Val)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - put bit mask */
  if (Val) {
    setReg8Bits(PTP, Mask);            /* [bit (Bit+4)]=0x01U */
  } else { /* !Val */
    clrReg8Bits(PTP, Mask);            /* [bit (Bit+4)]=0x00U */
  } /* !Val */
}

/*
** ===================================================================
**     Method      :  Init_LED_ClrBit (component BitsIO)
**     Description :
**         This method clears (sets to zero) the specified bit
**         of the output value.
**         [ It is the same as "PutBit(Bit,FALSE);" ]
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to clear (0 to 2)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_ClrBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  clrReg8Bits(PTP, Mask);              /* [bit (Bit+4)]=0x00U */
}

/*
** ===================================================================
**     Method      :  Init_LED_SetBit (component BitsIO)
**     Description :
**         This method sets (sets to one) the specified bit of the
**         output value.
**         [ It is the same as "PutBit(Bit,TRUE);" ]
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to set (0 to 2)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_SetBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  setReg8Bits(PTP, Mask);              /* [bit (Bit+4)]=0x01U */
}

/*
** ===================================================================
**     Method      :  Init_LED_NegBit (component BitsIO)
**     Description :
**         This method negates (inverts) the specified bit of the
**         output value.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Bit        - Number of the bit to invert (0 to 31)
**     Returns     : Nothing
** ===================================================================
*/
void Init_LED_NegBit(byte Bit)
{
  byte const Mask = Init_LED_GetMsk(Bit); /* Temporary variable - set bit mask */
  invertReg8Bits(PTP, Mask);           /* [bit (Bit+4)]=invert */
}

/*
** ===================================================================
**     Method      :  Init_LED_GetDir (component BitsIO)
**     Description :
**         This method returns direction of the component.
**     Parameters  : None
**     Returns     :
**         ---        - Direction of the component (always <true>, Output only)
**                      <false> = Input, <true> = Output
** ===================================================================
*/
/*
bool Init_LED_GetDir(void)

**  This method is implemented as a macro. See Init_LED.h file.  **
*/


/* END Init_LED. */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
