/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : IIC0.c
**     Project     : DevKit-S12ZVC_IIC_Lab4
**     Processor   : MC9S12ZVCA192MKH
**     Component   : Init_IIC
**     Version     : Component 01.054, Driver 01.09, CPU db: 3.00.000
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-07-15, 12:40, # CodeGen: 4
**     Abstract    :
**          This file implements the IIC (IIC0) module initialization 
**          according to the Peripheral Initialization settings, 
**          and defines interrupt service routines prototypes.
**          The Inter-IC Bus (IIC or I2C) is a two-wire, bidirectional serial
**          bus that provides a simple, efficient method of data exchange
**          between devices Being a two-wire device, the IIC Bus minimizes
**          the need for large numbers of connections between devices,
**          and eliminates the need for an address decoder.
**     Settings    :
**          Component name                                 : IIC0
**          Device                                         : IIC0
**          Multiplier Factor                              : 1
**          SCL Tap (Clocks)                               : 5
**          Tap to Tap (Clocks)                            : 16
**          SCL frequency                                  : 100 kHz
**          SDA Hold                                       : 1.0625 us
**          SCL hold (Start)                               : 4.875 us
**          SCL hold (Stop)                                : 5.0625 us
**          Trans/Receiv mode select                       : Receive
**          Transmit Acknowledge                           : yes
**          Slave Address                                  : 68
**          Address type                                   : 7-bit addressing
**          Genneral Call                                  : Disabled
**          Stop in WAIT mode                              : Disabled
**          SDA pin                                        : PJ0_SDA0_RXD0
**          SDA pin signal                                 : 
**          SCL pin                                        : PJ1_SCL0_TXD0
**          SCL pin signal                                 : 
**          Interrupt                                      : Viic
**          IIC interrupt                                  : Enabled
**          Interrupt priority                             : 4
**          ISR name                                       : ISR_IIC
**          Call Init in CPU init. code                    : yes
**          Bus Enable                                     : yes
**     Contents    :
**         Init - void IIC0_Init(void);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file IIC0.c
** @version 01.09
** @brief
**          This file implements the IIC (IIC0) module initialization 
**          according to the Peripheral Initialization settings, 
**          and defines interrupt service routines prototypes.
**          The Inter-IC Bus (IIC or I2C) is a two-wire, bidirectional serial
**          bus that provides a simple, efficient method of data exchange
**          between devices Being a two-wire device, the IIC Bus minimizes
**          the need for large numbers of connections between devices,
**          and eliminates the need for an address decoder.
*/         
/*!
**  @addtogroup IIC0_module IIC0 module documentation
**  @{
*/         

/* MODULE IIC0. */

#include "IIC0.h"

/*
** ###################################################################
**
**  The interrupt service routine(s) must be implemented
**  by user in one of the following user modules.
**
**  If the "Generate ISR" option is enabled, Processor Expert generates
**  ISR templates in the CPU event module.
**
**  User modules:
**      main.c
**      Events.c
**
** ###################################################################
#pragma CODE_SEG __NEAR_SEG NON_BANKED
ISR(ISR_IIC)
        {
        // NOTE: The routine should include the following actions to obtain
        //       correct functionality of the hardware.
        //
        //      The ISR is invoked by IBIF flag. The IBIF flag is cleared
        //      if a "1" is written to the IBIF flag in IIC0IBSR register.
        //      Example: IIC0IBSR_IBIF = 1;
        }
#pragma CODE_SEG DEFAULT
*/
/*
** ===================================================================
**     Method      :  IIC0_Init (component Init_IIC)
**     Description :
**         This method initializes registers of the IIC module
**         according to this Peripheral Initialization settings. Call
**         this method in user code to initialize the module. By
**         default, the method is called by PE automatically; see "Call
**         Init method" property of the component for more details.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void IIC0_Init(void)
{
  /* IIC0IBCR: IBIE=0 */
  clrReg8Bits(IIC0IBCR, 0x40U);        /* Disable interrupts before change */ 
  /* IIC0IBSR: IBIF=1 */
  setReg8Bits(IIC0IBSR, 0x02U);        /* Clear the interrupt flag */ 
  /* IIC0IBFD: IBC7=0,IBC6=0,IBC5=1,IBC4=0,IBC3=0,IBC2=0,IBC1=0,IBC0=0 */
  setReg8(IIC0IBFD, 0x20U);            /* Timing setting */ 
  /* IIC0IBCR2: GCEN=0,ADTYPE=0,??=0,??=0,??=0,ADR10=0,ADR9=0,ADR8=0 */
  setReg8(IIC0IBCR2, 0x00U);            
  /* IIC0IBAD: ADR7=1,ADR6=1,ADR5=0,ADR4=1,ADR3=0,ADR2=0,ADR1=0,??=0 */
  setReg8(IIC0IBAD, 0xD0U);            /* Slave address setting */ 
  /* IIC0IBCR: IBEN=1 */
  setReg8Bits(IIC0IBCR, 0x80U);        /* Enable the module */ 
  /* IIC0IBCR: IBEN=1,IBIE=1,MS_SL=0,TX_RX=0,TXAK=0,RSTA=0,??=0,IBSWAI=0 */
  setReg8(IIC0IBCR, 0xC0U);            /* Control register setting */ 
}

/* END IIC0. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
