/* ###################################################################
**     Filename    : main.c
**     Project     : DevKit-S12ZVC_SPI_Lab5
**     Processor   : MC9S12ZVCA192MKH
**     Version     : Driver 01.14
**     Compiler    : CodeWarrior HCS12Z C Compiler
**     Date/Time   : 2016-07-15, 12:53, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.14
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */

/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Init_SPI.h"
#include "Init_LED.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
//--------------------------------------------------------------------------------------------------
//                  Defines Section
//--------------------------------------------------------------------------------------------------

#define Master 1

#define LED_BLUE      PTP_PTP4 
#define LED_GREEN     PTP_PTP3 
#define LED_RED       PTP_PTP2 

#define TURN_ON     0
#define TURN_OFF    1

//--------------------------------------------------------------------------------------------------
//                 Function Prototypes Section
//--------------------------------------------------------------------------------------------------
void write_spi(uint16_t data);
void read_spi(void);
void delay(long int time);
//--------------------------------------------------------------------------------------------------
//                  Global Variables Section
//--------------------------------------------------------------------------------------------------
uint16_t gSPI;

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */
  LED_BLUE  = TURN_OFF;
  LED_GREEN = TURN_OFF;
  LED_RED   = TURN_OFF;
  
  #ifndef Master
    SPI1CR1_MSTR = 0;
  #endif 
  /* Write your code here */
  for(;;){
  
 #ifdef Master
    write_spi(0x01);
    delay(2500);
    write_spi(0x02);
    delay(2500);
 #else
    delay(30000);
    read_spi();
 
 #endif
   

  }
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/
/*******************************************************************************************************************************/
/* Name : read_spi                                                                                                             */
/* Description : This function read the message and controls the RGB LED                                                        */
/* In parameters : None                                                                                                        */
/* Out parameters : None                                                                                                       */
/* Return value : void                                                                                                         */
/*******************************************************************************************************************************/
void read_spi(void){

  while(!SPI1SR_SPIF);
    
  gSPI= SPI1DR;
  
  
  if(gSPI == 0x01){
  	  LED_BLUE  =  TURN_ON; /* Turn on   */
	    LED_GREEN =  TURN_OFF; /* Turn off  */ 
  }
  else if(gSPI == 0x02){
  	  LED_BLUE  =  TURN_OFF; /* Turn off   */
	    LED_GREEN =  TURN_ON; /* Turn on  */ 
  }
}
/*******************************************************************************************************************************/
/* Name : write_spi                                                                                                            */
/* Description : This function send the message                                                                                */
/* In parameters : data: Message to be send                                                                                                        */
/* Out parameters : None                                                                                                       */
/* Return value : void                                                                                                         */
/*******************************************************************************************************************************/
void write_spi(uint16_t data){

     while(!SPI1SR_SPTEF);
     SPI1DR = data;
  
}
/*******************************************************************************************************************************/
/* Name : Delay                                                                                                                 */
/* Description : Create a delay for specific time                                                                               */
/* In parameters : time: Time to wait                                                                                           */
/* Out parameters : None                                                                                                        */
/* Return value : void                                                                                                          */
/********************************************************************************************************************************/
void delay(long int time)		
{
  while(time>>0){--time;}
}
/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.09]
**     for the Freescale HCS12Z series of microcontrollers.
**
** ###################################################################
*/
