#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "GPIO.h"
#include "ADC.h"

unsigned int ADC_POT_VALUE=0;

void main(void) {
	
	GPIO_DIGIT_INPUT_EN(ADH,2,ON);
	GPIO_DIGIT_INPUT_EN(ADH,3,ON);
	GPIO_CONFIG(ADH,2,INPUT); 			// Configure PP4 as INPUT for SW2
	GPIO_CONFIG(ADH,3,INPUT);			// Configure PP7 as INPUT for SW3
	
	GPIO_CONFIG(P,4,OUTPUT);		// Configure PP4 as OUTPUT for RGB[GREEN-LED]
	GPIO_CONFIG(P,5,OUTPUT);		// Configure PP4 as OUTPUT for RGB[RED-LED]
	GPIO_CONFIG(P,6,OUTPUT);		// Configure PP4 as OUTPUT for RGB[BLUE-LED]
	
	GPIO_WRITE_VALUE(P,4,1);		// Turn-OFF RGB[GREEN-LED] 
	GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[RED-LED]
	GPIO_WRITE_VALUE(P,6,1);		// Turn-OFF RGB[BLUE-LED]
	
	ADC_init();


  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
    ADC_POT_VALUE = ADC_read(AN(1));
        
        if(ADC_POT_VALUE < 1024 && ADC_POT_VALUE >= 683){
        			GPIO_WRITE_VALUE(P,4,0);		// Turn-OFF RGB[GREEN-LED]
        			GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[RED-LED]
        			GPIO_WRITE_VALUE(P,6,1);		// Turn-OFF RGB[BLUE-LED]
        		}
        else if(ADC_POT_VALUE < 683 && ADC_POT_VALUE >= 341){
        			GPIO_WRITE_VALUE(P,4,1);		// Turn-OFF RGB[GREEN-LED]
        			GPIO_WRITE_VALUE(P,5,0);		// Turn-OFF RGB[RED-LED]
        			GPIO_WRITE_VALUE(P,6,1);		// Turn-OFF RGB[BLUE-LED]
        		}
        		
        else if(ADC_POT_VALUE < 341){
        			GPIO_WRITE_VALUE(P,4,1);		// Turn-OFF RGB[GREEN-LED]
        			GPIO_WRITE_VALUE(P,5,1);		// Turn-OFF RGB[RED-LED]
        			GPIO_WRITE_VALUE(P,6,0);		// Turn-OFF RGB[BLUE-LED]
        		}

  } /* loop forever */

}
