#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


static void PLL_Init(unsigned char pll_synr, unsigned char pll_refdv, unsigned char pll_postdiv);
static void ADC_Init(void);
unsigned int ADC_Read(void);
static void PWM_init(void);
static void PWM_RGB(int a);


#define LED_UP 0
#define LED_DOWN 1  
#define LED_MIN 1      


unsigned int ADCPOT=0, ADCPOT_value=0;
unsigned int direction = 0;
unsigned int LED = 1, DT_LED = 0, DT_LEDaux = 0;

/*******************************************************************************
Function Name : PLL_Init
Parameters    : unsigned char pll_synr
                unsigned char pll_refdv
                unsigned char pll_postdivNONE
Modifies      : NONE
Returns       : NONE
Notes         : Sets BUSCLK = 40MHz from OSCCLK = 4MHz
Issues        : NONE
*******************************************************************************/
static void PLL_Init(unsigned char pll_synr, unsigned char pll_refdv, unsigned char pll_postdiv){

  CPMUCLKS_PLLSEL = 1;        // Select clock source from PLLCLK
  CPMUREFDIV_REFFRQ = 2; 
  CPMUSYNR = pll_synr;        // Set the multiplier register [3]
  CPMUREFDIV = pll_refdv;     // Set the divider register [1]
  CPMUPOSTDIV = pll_postdiv;  // Set the post divider register [1]
  CPMUOSC_OSCE = 1;				    // External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)	
  while(!CPMUFLG_LOCK);       // Wait till the PLL VCO is within tolerance

  ECLKCTL_NECLK=0;            // Enable the BusClk output at ECLK pin to see busclk if necessary
}


/*******************************************************************************
Function Name : ADC_Init
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Initialization of the ADC. 
Issues        : NONE
*******************************************************************************/
void ADC_Init(void){
  	
	 /* Single 10-Bit Conversion */
      /* Initialize ADC           */
                   
      ATDCTL1 = 0x00;  /* 8-Bit resolution                                */              
      ATDCTL3 = 0x88;  /* Right Justified Data, Single conversion sequence */              
      ATDCTL4 = 0x01;  /* 6.25 MHz, Notice: 8MHz Max ATD Clock, Fatdlk = FBUS/(2*(PRS+1)) */ 
                       /* 6 ATD Clock cycles sample time  */                                         
      ATDCTL5 = 0x00;  /* Start Single Conversion on AN0 */  
  
}




/*******************************************************************************
Function Name : ADC_Read
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Initialization of the ADC. 
Issues        : NONE
*******************************************************************************/
unsigned int ADC_Read(void){

         ATDCTL5 = 0x00;    /* Start Single Conversion on AN10; simultaneously clears SCF */              
         while (!ATDSTAT0_SCF);  /* wait for conversion sequence to complete              */    
         ATDSTAT0_SCF = 1;            /* Clear Sequence Complete Flag for next conversion */             
         ADCPOT = ATDDR0;
         return ADCPOT;          

}



/*******************************************************************************
Function Name : PWM_Init
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Initialization of the PWM. 
Issues        : NONE
********************************************************************************/
static void PWM_init(void) {
 
  PWMCAE = 0x00; /* Set left alignment for channels 0 - 3 */
  PWMPOL = 0x00; /* Set polarity for channels 3/4/5        */
  
  /* PWM3 clk selection */
  PWMCLK_PCLK3     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB3 = 0;  
  /* PWM4 clk selection */
  PWMCLK_PCLK4     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB4 = 0;  
  /* PWM6 clk selection */
  PWMCLK_PCLK6     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB6 = 0;  

 PWMPRCLK = 0x77;           // Bus clock [A & B] / 32
  
  PWMPER3 = 0xFF; /* Set chan 0 period length to the maximum.        */
  PWMPER4 = 0xFF; /* Set chan 1 period length to the maximum.        */
  PWMPER6 = 0xFF; /* Set chan 2 period length to the maximum.        */

  PWMDTY3 = 0x00; /* Set chan 0 duty cycle to half the maximum, 50%. */
  PWMDTY4 = 0x00; /* Set chan 1 duty cycle to half the maximum, 50%. */
  PWMDTY6 = 0x00; /* Set chan 2 duty cycle to half the maximum, 50%. */

  PWME = 0x58;    /* Enable PWM channels 3/4/5 (PP0-PP3)             */
  
}


void PWM_RGB(int a) {
	
	DT_LEDaux = a;
	if(DT_LED < DT_LEDaux){DT_LED = DT_LEDaux;}

	if(LED==1 && direction == LED_UP){						// LED Red
		  if(PWMDTY4<DT_LED){PWMDTY4++;}
	else if(PWMDTY4==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED==1 && direction == LED_DOWN){
		  if(PWMDTY4>LED_MIN){PWMDTY4--;} else {direction = LED_UP; DT_LED = DT_LEDaux; LED++;}
	}
	
	
	
	else if(LED==2 && direction == LED_UP){					// LED Purple
		  if(PWMDTY4<DT_LED){PWMDTY4++;PWMDTY3++;}
	else if(PWMDTY4==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED == 2 && direction == LED_DOWN){
		  if(PWMDTY4>LED_MIN){PWMDTY4--; PWMDTY3--;} else {direction = LED_UP; DT_LED = DT_LEDaux; LED++;}
	}
	

	
	else if(LED==3 && direction == LED_UP){					// LED Blue
		  if(PWMDTY3<DT_LED){PWMDTY3++;}
	else if(PWMDTY3==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED==3 && direction == LED_DOWN){
		  if(PWMDTY3>LED_MIN){PWMDTY3--;} else {direction = LED_UP; DT_LED = DT_LEDaux; LED++;}
	}



	else if(LED==4 && direction == LED_UP){					// LED Ice blue
		  if(PWMDTY6<DT_LED){PWMDTY3++;PWMDTY6++;}
	else if(PWMDTY6==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED == 4 && direction == LED_DOWN){
		  if(PWMDTY6>LED_MIN){PWMDTY3--; PWMDTY6--;} else {direction = LED_UP; DT_LED = DT_LEDaux; LED++;}
	}
	
	
	
	else if(LED==5 && direction == LED_UP){					// LED Green
		  if(PWMDTY6<DT_LED){PWMDTY6++;}
	else if(PWMDTY6==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED==5 && direction == LED_DOWN){
		  if(PWMDTY6>LED_MIN){PWMDTY6--;} else {direction = LED_UP; DT_LED = DT_LEDaux; LED++;}
	}
	

	
	else if(LED==6 && direction == LED_UP){					// LED Yellow
		  if(PWMDTY6<DT_LED){PWMDTY6++;PWMDTY4++;}
	else if(PWMDTY6==DT_LED){direction = LED_DOWN;}
	} 
	else if(LED == 6 && direction == LED_DOWN){
		  if(PWMDTY6>LED_MIN){PWMDTY6--; PWMDTY4--;} 
		  else {direction = LED_UP; DT_LED = DT_LEDaux; LED=1;}
	}
	
	
}


void delay (long int time)		// 3 cycles
{while(time>>0){--time;}			// Loop takes 9.5 cycles
}									            // 4 cycles





void main(void) {

  
  PLL_Init(0x47, 0x01, 0x01); // 32MHz BUSCLK  from 8MHz OSCCLK
  ADC_Init();
  PWM_init();

	//EnableInterrupts;
	
            
      for(;;)
      {
         _FEED_COP(); /* feeds the dog */
         ADCPOT_value = ADC_Read();
         delay(3500);
         PWM_RGB(ADCPOT_value);

      } 
   
}
