;*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2006, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                                                                       *
;*               EEPROM Emulation Driver for HCS08 eNVM                  *
;*                                                                       *
;* FILE NAME     :  ssd_fls_clk.inc                                      *
;* DATE          :  03.16.2006                                           *
;* AUTHOR        :  Infosys Team, Mysore                                 *
;* EMAIL         :  r56611@freescale.com                                 *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   03.16.2006      Venkatesh_G    Initial Version
;*************************************************************************

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; This head file helps user to calculate clock divider at compile time.
; User should provide BUS_CLK before including this file.
; 
; The unit for clock rate value is in KHz. For example if the real clock 
; rate is 10 MHz, then the the clock rate value will be 10000.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Macros for calculating clock divider value
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MCU_LG32:  equ 1

;mininum and maximum bus clock rate to FLS
MIN_BUS_CLK:        equ     450             ;450 KHz 
MAX_BUS_CLK:        equ     102400          ;102.4 MHz 
BUS_CLK:            equ     18870           ;bus clock is in KHz unit
;User needs to define bus clock rate
    IFNDEF BUS_CLK
        FAIL "BUS_CLK (bus clock rate in KHz) undefined!"
    ENDIF

    IF (BUS_CLK > MAX_BUS_CLK) || (BUS_CLK < MIN_BUS_CLK)
        FAIL "BUS_CLK (bus clock rate in KHz) out of range!"
    ENDIF

FLASH_INPUT_CLK:    equ     BUS_CLK

    IF  FLASH_INPUT_CLK > 12800
        FLASH_CLOCK:          equ   (FLASH_INPUT_CLK / 8)
        FLASH_CLOCK_PRDIV8:   equ   $40
    ELSE
        FLASH_CLOCK:          equ   FLASH_INPUT_CLK
        FLASH_CLOCK_PRDIV8:   equ   0
    ENDIF

CLOCK_DIV:          equ     (FLASH_CLOCK / 200)
    
    IF (FLASH_CLOCK % 200)
        FLASH_CLOCK_DIV:      equ   CLOCK_DIV
    ELSE
        FLASH_CLOCK_DIV:      equ   (CLOCK_DIV - 1)
    ENDIF

;user code refer to this macro directly
;FLASH_CLOCK_DIVIDER:      equ   (FLASH_CLOCK_PRDIV8 | FLASH_CLOCK_DIV)
FLASH_CLOCK_DIVIDER:      equ   $44