/*************************************************************************
;* (c) Copyright Freescale Semiconductor, Inc 2007, All Rights Reserved  *
;*************************************************************************
;*************************************************************************
;*                                                                       *
;*               EEPROM Emulation Driver for HCS08 eNVM                  *
;*                                                                       *
;* FILE NAME       EED_Flash.h                                           *
;* DATE            01.04.2007                                            *
;* AUTHOR          Infosys Team, Mysore                                  *
;* EMAIL           r56611@freescale.com                                  *
;*************************************************************************
;******************************* CHANGES *********************************
;*   1.00   01.04.2007      Venkatesh_G/Arvind_Awasthi    Initial Version
;*   1.1    06.04.2008      Chen He		 				  Modified to handle boundary check
;*************************************************************************/

typedef  unsigned char  UINT8;
typedef  volatile unsigned char VUINT8;
typedef  unsigned int   UINT16;
typedef  unsigned long  UINT32 ;



/* bytes to be copied during a MAX COP period*/
#define BYTES_PER_COP 0x30

/* Flag to indicate whether a Flash HV function is present on stack.*/
#define EMU_HV_ONSTACK              0x5A
 #define HVSubSize   30
 #define HVSubSizeN  -30
/* Null callback definition*/

 #ifndef NULL_CALLBACK
#define  NULL_CALLBACK               0xFFFF
 #endif

/* record state*/
#define RECORD_STATUS_ERASED        0xFF
#define RECORD_STATUS_COMPLETED     0x00

/* cluster state*/
#define SECTOR_STATUS_ERASED        0xFF
#define SECTOR_STATUS_ACTIVE        0x00

// EEPROM Emulation Flash Driver Return Code
#define EE_OK                       0x0
#define EE_ERROR_ACCERR             0x10    // flash operation causes access error
#define EE_ERROR_PVIOL              0x20    // flash operation on protected area
#define EE_ERROR_NOT_BLANK          0x30    // Flash page is not erased
#define EE_ERROR_SECURITY_ENABLED   0x40    // flash is in secured state
#define EE_ERROR_VERIFY             0x50    // source and destination data mismatch
#define EE_ERROR_NOMEM              0x60    // no enough EEPROM memory
#define EE_ERROR_NOFND              0x70    // record not found in sector
#define EE_ERROR_CLOCK_SETTING      0x80    // clock divider setting error
#define EE_ERROR_SSTAT              0x90    // sector status error
#define EE_ERROR_IDRNG              0xA0    // recID exceeds the valid range


//Each Sector will be of 512 bytes if each sector has its Error
//Corrrection Code(ECC) and 768 Bytes if no ECC is there.Each Sector
//will have 1 Byte long Status and 2 Bytes long Erase Cycles and rest
//of the Sector will be used for holding Data Records.
//Each Data Record will have a Status of 1 Byte and user configurable
//ID size and Data size.

#define OFF   0x0
#define ON   0x1
#define ECC   OFF
//**********************************************************
//Macro to determine the size of the Sector.
//**********************************************************

    #if ECC==OFF
    #define 	EED_SECTOR_SIZE          0x200  //Select Sector Size=512 Bytes
    #else
	#define EED_SECTOR_SIZE          0x300  //Select Sector Size=768 Bytes
    #endif
//**********************************************************
//End of Macro
//**********************************************************
//Data Status Size has 1 byte fixed length.
#define DATA_STATUS_SIZE           0x1

//Data ID Size is user cofigurable.
#define DATA_ID_SIZE              0x1

//Data size is user configurable.
#define DATA_SIZE                 0x2

 #if (DATA_SIZE>0x7C)
 #error "Data size cannot exceed 124 bytes."
 #endif

// max ID reserved for EED internal use
 #if (DATA_ID_SIZE==1)
#define  RECORD_ID_MAX              0xFF
 #else
#define  RECORD_ID_MAX              0xFFFF
 #endif


//EEPROM size is user configurable.
#define EEPROM_SIZE               0x1FC

//Number of Data Records is calculated if we know the total Data Size.
 #if (EEPROM_SIZE % DATA_SIZE == 0)

#define DATA_RECORD_NUMBER      (EEPROM_SIZE/DATA_SIZE)

 #else

#define DATA_RECORD_NUMBER      ((EEPROM_SIZE/DATA_SIZE)+1)

  #endif
//Data Record Size can be calculated as sum of Status,ID and Size.
#define DATA_RECORD_SIZE          (DATA_STATUS_SIZE+DATA_ID_SIZE+DATA_SIZE)

#define RECORD_LENGTH             DATA_RECORD_SIZE

//****************************************************************************
//Macro to determine the total number of sectors alloted for EEPROM Emulation.
//****************************************************************************

//Sector Size actually used to store data.
#define EED_SECTOR_CAPACITY       ((EED_SECTOR_SIZE-3)/DATA_RECORD_SIZE)

//Number of sectors rired to store the specified EEPROM size
 #if (DATA_RECORD_NUMBER % EED_SECTOR_CAPACITY == 0)

#define  EED_SECTOR_NUMBER        (DATA_RECORD_NUMBER/EED_SECTOR_CAPACITY)

 #else

#define EED_SECTOR_NUMBER         ((DATA_RECORD_NUMBER/EED_SECTOR_CAPACITY) + 1)

 #endif

#define EED_READY_SECTORS         0x2
//Total number of sectors alloted will also include some 'alternative sectors'
#define EED_SECTORS_ALLOTED       (EED_SECTOR_NUMBER+EED_READY_SECTORS)

//**********************************************************
//End of Macro
//**********************************************************


//Start Address of Flash for EEPROM emulation.
#define EFLASH_START_ADDRESS       0x8200

//**********************************************************
//Macro to determine the End Address of the emulated EEPROM .
//**********************************************************

//End Address of Flash from EEPROM emulation.
#define EFLASH_END_ADDRESS          (EFLASH_START_ADDRESS + (EED_SECTORS_ALLOTED*EED_SECTOR_SIZE)-1)

//**********************************************************
//End of Macro
//**********************************************************

//**********************************************************
//Macro to determine the number of IDs to be stored in Cache table .
//**********************************************************

//End Address of Flash from EEPROM emulation.
#define EED_CACHETABLE_ENTRY        (0x8)

//**********************************************************
//Macro to denote the sector status
//**********************************************************
#define EE_SECTOR_ACTIVE           (UINT8)(0x00)
#define EE_SECTOR_ALTERNATIVE      (UINT8)(0x55)
#define EE_SECTOR_BLANK            (UINT8)(0xFF)
#define EE_SECTOR_UPDATE           (UINT8)(0xAA)


//**********************************************************
//Macro to denote the Flash Start Address and Flash End 
//Address
//**********************************************************
//NOTE:User has to define these addresses based on the size
//of FLASH being used in his HCS08 Micro
#define FLASH_START_ADDRESS		    (0xC000)
#define FLASH_END_ADDRESS	        (0xC3FF)
#define EE_BOUNDARY_CHECK	        0  //1 - if boundary check is required in FSL_Erase and FSL_Program
									   //0 - if boundary check is NOT required in FSL_Erase and FSL_Program

//**********************************************************
//End of Macro
//**********************************************************
 extern  UINT8 recID; 
 extern  UINT16 erasingCycles; 
 extern  UINT16 failedAddress;
 extern  UINT16 destination;
 extern  UINT16 cbAddr;
 extern  UINT16    emuStartAddr; 
 extern  UINT16 emuEndAddr;
 extern  UINT16 emuBlank;
 extern  UINT16   startAddr;
 extern  UINT16 endAddr;
 extern  UINT16 buffer; 
 extern  UINT16 cacheTable[EED_CACHETABLE_ENTRY] ;
 extern  UINT8 hvonstack;
 extern  UINT16 hvPosition;
 extern  UINT8 size;
 extern  UINT16 emuBuffer;
 extern  UINT16 hvCopyFr;
 extern  UINT16 hvCopyTo;
 extern  UINT8 emuCount;
 
 extern UINT8 FSL_InitEeprom(void);
 extern UINT8 FSL_ReadEeprom(void);
 extern UINT8 FSL_WriteEeprom(void);
 extern UINT8 FSL_ReportEepromStatus(void);
 extern UINT8 FSL_DeinitEeprom(void);
 
 extern UINT8 FSL_InitSector(UINT8);
 extern UINT8 FSL_SectorStatus(void);
 
