--------------------------------------------------------------------------------
-- Motorola PowerPC VGER (TM) Microprocessor Boundary Scan Description Language-
--------------------------------------------------------------------------------
-- Boundary Scan Description Language (IEEE 1149.1b)                          --
--                                                                            --
-- Device        : MPC7457   Revision 1                                       --
-- File Version  : A                                                          --
-- File Name     : MPC7457.R1A                                                --
-- File created  : Aug. 27, 2002                                              --
-- Package type  : CBGA                                                       --
-- Voltage Level : 2.5V                                                       --
-- 1149.1 Device Test : untested                                              --
-- System Level Test  : untested                                              --
--                                                                            --
--------------------------------------------------------------------------------
-- Revision History:                                                          --
-- 1A - Original version for MPC7457                                          --
--                                                                            --
-- NOTE: Active low ports are designated with a "_L" suffix.                  --
--                                                                            --
-- NOTE: The IEEE 1149.1 standard optional instructions CLAMP and HIGHZ are   --
--       supported.                                                           --
--                                                                            --
-- NOTE: For assistance with this file, contact your sales office.            --
--                                                                            --
--------------------------------------------------------------------------------
--                                                                            --
--============================================================================--
--                             IMPORTANT NOTICE                               --
--  This information is provided on an AS IS basis and without warranty.      --
--  IN NO EVENT SHALL MOTOROLA BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL      --
--  DAMAGES ARISING FROM USE OF THIS INFORMATION. THIS DISCLAIMER OF          --
--  WARRANTY EXTENDS TO THE USER OF THE INFORMATION, AND TO THEIR CUSTOMERS   --
--  OR USERS OF PRODUCTS  AND IS IN LIEU OF ALL WARRANTIES WHETHER EXPRESS,   --
--  IMPLIED, OR STATUTORY, INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY    --
--  OR FITNESS FOR PARTICULAR PURPOSE.                                        --
--                                                                            --
--  MOTOROLA does not represent or warrant that the information furnished     --
--  hereunder is free of infringement of any third party patents,             --
--  copyrights, trade secrets, or other intellectual property rights.         --
--  MOTOROLA does not represent or warrant that the information is free of    --
--  defect, or that it meets any particular standard, requirements or need    --
--  of the user of the infomation or their customers.                         --
--                                                                            --
--  MOTOROLA reserves the right to change the information in this file        --
--  without notice. The latest version of the file is available on the        --
--  Motorola Freeware Data Services Bulletin Board system at (512)891-FREE    --
--  (3733). Modem settings are 8-bit data, no parity, and one start and one   --
--  stop bit. The BSDL files are also available on the World Wide Web at:     --
--                                                                            --
--           http://www.mot.com/SPS/PowerPC/support/support.html              --
--                                                                            --
--============================================================================--


entity MPC7457 is
  generic (PHYSICAL_PIN_MAP : string := "BGA");

-- PORT DESCRIPTION TERMS
-- in         = input only
-- out        = three-state output (0, Z, 1)
-- buffer     = two-state output (0, 1)
-- inout      = bidirectional
-- linkage    = OTHER (vdd, vss, analog)
-- bit        = single pin
-- bit_vector = group of pins with suffix 0 to n

 port (	    BR_L:               out      bit;  
            BG_L:               in       bit;  
            TS_L:               inout    bit;  
            A:                  inout    bit_vector(0 to 35);          
            AP:                 inout    bit_vector(0 to 4);           
            TT:                 inout    bit_vector(0 to 4);           
            TSIZ:               out      bit_vector(0 to 2);           
            TBST_L:             inout    bit;                          
            CI_L:               out      bit;                          
            WT_L:               out      bit;                          
            GBL_L:              inout    bit;                          
            AACK_L:             in       bit;                          
            ARTRY_L:            inout    bit;                          
            SHD0_L:             inout    bit;                          
            SHD1_L:             inout    bit;                          
            DBG_L:              in       bit;                          
            DTI:                in       bit_vector(0 to 3);           
            DRDY_L:             out      bit;                          
            HIT_L:              out      bit;                          
            DX_L:               in       bit;                          
            D:                  inout    bit_vector(0 to 63);          
            DP:                 inout    bit_vector(0 to 7);           
            TA_L:               in       bit;                          
            TEA_L:              in       bit;                          
            WAIT_L:             in       bit;                          
            HPR_L:              out      bit;                          
            IARTRY0_L:          in       bit;                          
            IARTRY1_L:          in       bit;                          
            OSHD_L:             out      bit;                          
            L3_ADDR:            out      bit_vector(0 to 18);          
            L3_DATA:            inout    bit_vector(0 to 63);         
            L3_DATAP:           inout    bit_vector(0 to 7);          
            L3_CNTL:            out      bit_vector(0 to 1);           
            L3_CLK:             out      bit_vector(0 to 1);           
            L3_ECHO_CLK:        inout    bit_vector(0 to 3);           
            BMODE_L:            in       bit_vector(0 to 1);           
            CHKS_L:             in       bit;                          
            SRW_L:              in       bit_vector(0 to 1);           
            INT_L:              in       bit;                          
            SMI_B:              in       bit;                          
            MCP_L:              in       bit;                          
            SRESET_L:           in       bit;                          
            HRESET_L:           in       bit;                          
            TBEN:               in       bit;                          
            CKSTP_IN_L:         in       bit;                          
            CKSTP_OUT_L:        out      bit;                          
            PMON_OUT_L:         out      bit;                    	      
            PMON_IN_L:          in       bit;                          
            QREQ_L:             out      bit;                          
            QACK_L:             in       bit;                          
            SYSCLK:             in       bit;                          
            PLL_CFG:            in       bit_vector(0 to 3);           
            PLL_EXT:            in       bit;
            CLK_OUT:            out      bit;                          
            EXT_QUAL:           in       bit;                          
            TDI:                in       bit;                          
            TDO:                out      bit;                          
            TMS:                in       bit;                          
            TCK:                in       bit;                          
            TRST_L:             in       bit;                          
            LSSD_MODE_L:        in       bit;                          
            L1_TSTCLK:          in       bit;                          
            L2_TSTCLK:          in       bit;                          
            BVSEL:              in       bit;                              
            L3VSEL:             in       bit;                             
            GND:                linkage  bit_vector(0 to 93);              
            OVDD:               linkage  bit_vector(0 to 33);              
            GVDD:               linkage  bit_vector(0 to 37);              
            VDD:                linkage  bit_vector(0 to 20);              
            AVDD:               linkage  bit;              
            NC:                 linkage  bit_vector(0 to 13));    
  use STD_1149_1_1994.all;

  attribute COMPONENT_CONFORMANCE of MPC7457 : entity is "STD_1149_1_1993";

  attribute PIN_MAP of MPC7457 : entity is PHYSICAL_PIN_MAP;

  constant BGA:   PIN_MAP_STRING :=

-- CBGA PINOUT DIAGRAM
--
    "BR_L:        K1,   "&
    "BG_L:        R3,   "&
    "TS_L:        P5,   "&
    "A:           (E10, N4,  E8,  N5,  C8,  R2,  A7,  M2,  A6,  M1,"&
                  "A10, U2,  N2,  P8,  M8,  W4,  N6,  U6,  R5,  Y4,"&
                  "P1,  P4,  R6,  M7,  N7,  AA3, U4,  W2,  W1,  W3,"&
                  "V4,  AA1, D10, J4,  G10, D9),  "&
    "AP:          (L5,  L6,  J1,  H2,  G5),   "&
    "TT:          (F1,  F4,  K8,  A5,  E1),   "&
    "TSIZ:        (L1,  H3,  D1),   "&
    "TBST_L:      B7,   "&
    "CI_L:        R1,   "&
    "WT_L:        L2,   "&
    "GBL_L:       M4,   "&
    "AACK_L:      U1,   "&
    "ARTRY_L:     T2,   "&
    "SHD0_L:      L4,   "&
    "SHD1_L:      L8,   "&
    "DBG_L:       V1,   "&
    "DTI:         (P2,  T5,  U3,  P6),      "&
    "DRDY_L:      T6,  "&
    "HIT_L:       K2,  "&
    "DX_L:        A9,  "&
    "D:           (AB15, T14 , R14 , AB13, V14 , U14 , AB14, W16 , AA11, Y11 ,"&
                  "U12 , W13 , Y14 , U13 , T12 , W12 , AB12, R12 , AA13, AB11,"&
                  "Y12 , V11 , T11 , R11 , W10 , T10 , W11 , V10 , R10 , U10 ,"&
                  "AA10, U9  , V7  , T8  , AB4 , Y6  , AB7 , AA6 , Y8  , AA7 ,"&
                  "W8  , AB10, AA16, AB16, AB17, Y18 , AB18, Y16 , AA18, W14 ,"&
                  "R13 , W15 , AA14, V16 , W6  , AA12, V6  , AB9 , AB6 , R7  ,"&
                  "R9  , AA9 , AB8 , W9),   "&
    "DP:          (AA2 , AB3 , AB2 , AA8 , R8  , W5  , U8  , AB5),   "&
    "TA_L:        N8,   "&
    "TEA_L:       T1,   "&
    "WAIT_L:      F8,   "&
    "HPR_L:       F2,   "&
    "IARTRY0_L:   H6,   "&
    "IARTRY1_L:   H10,   "&
    "OSHD_L:      B6,   "&
    "L3_ADDR:     (L18 , K22 , L16 , K20 , K18 , J22 , J20 , H22 , J18 , K16 ,"&
                  "H20 , G22 , F22 , G20 , H18 , E22 , J16 , F20 , H11),   "&
    "L3_DATA:     (AA19, AB20, U16 , W18 , AA20, AB21, AA21, T16 , W20 , U18 ,"&
                  "Y22 , R16 , V20 , W22 , T18 , U20 , N18 , N20 , N16 , N22 ,"&
                  "M16 , M18 , M20 , M22 , R18 , T20 , U22 , T22 , R20 , P18 ,"&
                  "R22 , M15 , G18 , D22 , E20 , H16 , C22 , F18 , D20 , B22 ,"&
                  "G16 , A21 , G15 , E17 , A20 , C19 , C18 , A19 , A18 , G14 ,"&
                  "E15 , C16 , A17 , A16 , C15 , G13 , C14 , A14 , E13 , C13 ,"&
                  "G12 , A13 , E12 , C12),  "& 
    "L3_DATAP:    (AB19, AA22, P22 , P16 , C20 , E16 , A15 , A12 ), "&
    "L3_CNTL:     (L20 , L22), "&
    "L3_CLK:      (V22 , C17),  "&
    "L3_ECHO_CLK: (V18 , P20 , E18 , E14),          "&
    "BMODE_L:     (C6  , C4),  "&
    "CHKS_L:      B10,  "&
    "SRW_L:       (D8  , F9), "&
    "INT_L:       J6, "&
    "SMI_B:       G8, "&
    "MCP_L:       B8,  "&
    "SRESET_L:    G1, "&
    "HRESET_L:    A3,  "&
    "TBEN:        L3,  "&
    "CKSTP_IN_L:  F3,  "&
    "CKSTP_OUT_L: K6,   "&
    "PMON_OUT_L:  B4,   "&
    "PMON_IN_L:   E6,   "&
    "QREQ_L:      Y1,   "&
    "QACK_L:      K7,   "&
    "SYSCLK:      D6,   "&
    "PLL_CFG:     (A2  , F7  , C2  , D4),    "&
    "PLL_EXT:     H8,    "&
    "CLK_OUT:     N1,  "&
    "TDI:         E4,  "&
    "TDO:         H1,  "&
    "TMS:         K4,  "&
    "TCK:         J7,  "&
    "TRST_L:      C1,  "&
    "LSSD_MODE_L: F6,  "&
    "L1_TSTCLK:   H4,  "&
    "L2_TSTCLK:   J2,  "&
    "EXT_QUAL:    B9,  "&
    "BVSEL:       G6,  "&
    "L3VSEL:      A4,  "&
    "GND:        (A22 , B12 , B14 , B16 , B18 , B20 , C21 , D13 , D15 , D17 ,"&
                 "D19 , E21 , F10 , F12 , F14 , F16 , F19 , G17 , G21 , H13 ,"&
                 "H15 , H19 , J17 , J21 , K15 , K19 , L17 , L21 , M19 , N17 ,"&
                 "N21 , P15 , P19 , R17 , R21 , T15 , T19 , U17 , U21 , V19 ,"&
                 "W17 , W21 , Y20 , AB22, J10 , J12 , J14 , K9  , K11 , K13 ,"&
                 "L10 , L12 , L14 , M9  , M11 , M13 , N10 , N12 , N14 , P9  ,"&
                 "P11 , P13 , B1  , B5  , C3  , C9  , D7  , E2  , E5  , G4  ,"&
                 "G7  , H5  , J3  , K5  , M3  , M6  , P3  , T4  , T7  , T9  ,"&
                 "T13 , V2  , V5  , V8  , V12 , V15 , W7  , Y3  , Y9  , Y13 ,"&
                 "Y15 , AA5 , AA17, AB1), "&
    "OVDD:       (B3  , C5  , C7  , C10 , D2  , E3  , E9  , F5  , G3  , G9  ,"&
                 "H7  , J5  , K3  , L7  , M5  , N3  , P7  , R4  , T3  , U5  ,"&
                 "U7  , U11 , U15 , V3  , V9  , V13 , Y2  , Y5  , Y7  , Y10 ,"&
                 "Y17 , Y19 , AA4 , AA15), "&                                
    "GVDD:       (B13 , B15 , B17 , B19 , B21 , D12 , D14 , D16 , D18 , D21 ,"&
                 "E19 , F13 , F15 , F17 , F21 , G19 , H12 , H14 , H17 , H21 ,"&
                 "J19 , K17 , K21 , L19 , M17 , M21 , N19 , P17 , P21 , R15 ,"&
                 "R19 , T17 , T21 , U19 , V17 , V21 , W19 , Y21),  "&        
    "Vdd:        (J9  , J11 , J13 , J15 , K10 , K12 , K14 , L9  , L11 , L13 ,"&
                 "L15 , M10 , M12 , M14 , N9  , N11 , N13 , N15 , P10 , P12 ,"&
                 "P14), "&                                                    
    "AVDD:       B2,  "&
    "NC:         (D5  , E7  , A8  , D3  , H9  , J8  , G2  , A11 , B11 , C11 ,"&
                 "D11 , E11 , F11 , G11) ";
 
-- Other Pin Maps here when documented

  attribute TAP_SCAN_IN    of TDI   : signal is true;
  attribute TAP_SCAN_MODE  of TMS   : signal is true;
  attribute TAP_SCAN_OUT   of TDO   : signal is true;
  attribute TAP_SCAN_CLOCK of TCK   : signal is (30.0e6, BOTH);
  attribute TAP_SCAN_RESET of TRST_L : signal is true;

  attribute COMPLIANCE_PATTERNS of MPC7457: entity is
       "(LSSD_MODE_L,L1_TSTCLK,L2_TSTCLK) (10X)";

  attribute INSTRUCTION_LENGTH of MPC7457 : entity is 16;


  attribute INSTRUCTION_OPCODE of MPC7457 : entity is 
-- Public instructions:
       "EXTEST          (0000000000000000), "&     -- Hex 0000
       "SAMPLE          (0000000011110000), "&     -- Hex 00F0
       "BYPASS          (1111111111111111), "&     -- Hex FFFF
       "HIGHZ           (0000000011110010), "&     -- Hex 00F2
       "CLAMP           (0000000011110001), "&     -- Hex 00F1
       "IDCODE          (0000000011110011), "&     -- Hex 00F3

-- Private instructions:
        "PRIVATE000(0000000000010000), "&
        "PRIVATE001(0000000000010001), "&
        "PRIVATE002(0000000000010010), "&
        "PRIVATE003(0000000000010011), "&
        "PRIVATE004(0000000000010100), "&
        "PRIVATE005(0000000000010101), "&
        "PRIVATE006(0000000000010110), "&
        "PRIVATE007(0000000000010111), "&
        "PRIVATE008(0000000000011000), "&
        "PRIVATE009(0000000000001010), "&
        "PRIVATE010(0000100000001010), "&
        "PRIVATE011(0000100100001010), "&
        "PRIVATE012(0000101000001010), "&
        "PRIVATE013(0000101100001010), "&
        "PRIVATE014(0001000000001010), "&
        "PRIVATE015(0001000100001010), "&
        "PRIVATE016(0001001000001010), "&
        "PRIVATE017(0001001100001010), "&
        "PRIVATE018(0001010000001010), "&
        "PRIVATE019(0001010100001010), "&
        "PRIVATE020(0001011000001010), "&
        "PRIVATE021(0001100000001010), "&
        "PRIVATE022(0001100100001010), "&
        "PRIVATE023(0001101000001010), "&
        "PRIVATE024(0001101100001010), "&
        "PRIVATE025(0001110000001010), "&
        "PRIVATE026(0001110100001010), "&
        "PRIVATE027(0001111000001010)";
                  
                  
  attribute INSTRUCTION_CAPTURE of MPC7457 : entity is "xxxxxxxxxxxxxx01";
                                                
-- Use of some private opcodes can result in damage to the circuit,
-- board, or system.

  attribute INSTRUCTION_PRIVATE of MPC7457 : entity is
        "PRIVATE000, PRIVATE001, PRIVATE002, PRIVATE003, "& 
        "PRIVATE004, PRIVATE005, PRIVATE006, PRIVATE007, "& 
        "PRIVATE008, PRIVATE009, PRIVATE010, PRIVATE011, "& 
        "PRIVATE012, PRIVATE013, PRIVATE014, PRIVATE015, "& 
        "PRIVATE016, PRIVATE017, PRIVATE018, PRIVATE019, "& 
        "PRIVATE020, PRIVATE021, PRIVATE022, PRIVATE023, "& 
        "PRIVATE024, PRIVATE025, PRIVATE026, PRIVATE027"; 

  attribute IDCODE_REGISTER of MPC7457 : entity is
      "0000" &              -- Version
      "0000000000000010" &  -- Part number
      "00000001110" &       -- Manufacturer Identity
      "1";                  -- Manditory LSB


  attribute REGISTER_ACCESS of MPC7457 : entity is
        "BYPASS(BYPASS),"&
        "BOUNDARY (SAMPLE)";
  attribute BOUNDARY_LENGTH of MPC7457 : entity is 369;

 

  attribute BOUNDARY_REGISTER of MPC7457 : entity is

-- PORT DESCRIPTION TERMS
-- cell type: BC_6 bidirectional else BC_2
-- port: port name with index if port description says bit_vector
-- function
--     input        = input only
--     bidir        = bidirectional
--     control      = control cell
--     buffer       = output only
--     output3      = three state ouput
--     observe_only = observe only
-- safe = value in control cell to make input = 0 for bidir and controlr
-- ccell = controlling cell number for I/O direction
-- dsval = disabling (input) value
-- rslt  = result if disabled (input = Z)

-- tdo = first cell shifted out during ShiftDR
-- num   cell    port        function        safe       ccell   dsval   rslt
-- tdi
"0    (BC_2, WAIT_L,              input,          X),          "&
"1    (BC_1, OSHD_L,              output3,        0,           4,         0,     Z),     "&
"2    (BC_1, CLK_OUT,             output3,        0,           56,        0,     Z),     "&
"3    (BC_6, AP(4),               bidir,          0,           61,        0,     Z),     "&
"4    (BC_2, *,                   control,        0),          "&
"5    (BC_2, IARTRY1_L,           input,          X),          "&
"6    (BC_1, HPR_L,               output3,        0,           7,         0,     Z),     "&
"7    (BC_2, *,                   control,        0),          "&
"8    (BC_2, SRESET_L,            input,          X),          "&
"9    (BC_2, SMI_B,               input,          X),          "&
"10   (BC_2, CHKS_L,              input,          X),          "&
"11   (BC_2, IARTRY0_L,           input,          X),          "&
"12   (BC_2, CKSTP_IN_L,          input,          X),          "&
"13   (BC_2, *,                   control,        0),          "&
"14   (BC_1, HIT_L,               output3,        0,           51,        0,     Z),     "&
"15   (BC_2, *,                   control,        0),          "&
"16   (BC_1, CKSTP_OUT_L,         output3,        0,           13,        0,     Z),     "&
"17   (BC_2, *,                   control,        0),          "&
"18   (BC_1, BR_L,                output3,        0,           52,        0,     Z),     "&
"19   (BC_2, *,                   control,        0),          "&
"20   (BC_6, TT(4),               bidir,          0,           19,        0,     Z),     "&
"21   (BC_6, TT(2),               bidir,          0,           19,        0,     Z),     "&
"22   (BC_6, A(2),                bidir,          0,           40,        0,     Z),     "&
"23   (BC_6, A(33),               bidir,          0,           17,        0,     Z),     "&
"24   (BC_6, TT(0),               bidir,          0,           19,        0,     Z),     "&
"25   (BC_6, TT(3),               bidir,          0,           75,        0,     Z),     "&
"26   (BC_6, TT(1),               bidir,          0,           15,        0,     Z),     "&
"27   (BC_6, A(10),               bidir,          0,           45,        0,     Z),     "&
"28   (BC_6, A(32),               bidir,          0,           47,        0,     Z),     "&
"29   (BC_6, A(34),               bidir,          0,           47,        0,     Z),     "&
"30   (BC_2, QACK_L,              input,          X),          "&
"31   (BC_6, SHD1_L,              bidir,          0,           86,        0,     Z),     "&
"32   (BC_6, A(9),                bidir,          0,           46,        0,     Z),     "&
"33   (BC_6, A(7),                bidir,          0,           46,        0,     Z),     "&
"34   (BC_6, A(8),                bidir,          0,           40,        0,     Z),     "&
"35   (BC_6, AP(2),               bidir,          0,           85,        0,     Z),     "&
"36   (BC_6, A(12),               bidir,          0,           66,        0,     Z),     "&
"37   (BC_6, A(1),                bidir,          0,           66,        0,     Z),     "&
"38   (BC_6, A(6),                bidir,          0,           40,        0,     Z),     "&
"39   (BC_6, A(4),                bidir,          0,           45,        0,     Z),     "&
"40   (BC_2, *,                   control,        0),          "&
"41   (BC_6, A(23),               bidir,          0,           60,        0,     Z),     "&
"42   (BC_6, A(16),               bidir,          0,           60,        0,     Z),     "&
"43   (BC_6, A(0),                bidir,          0,           45,        0,     Z),     "&
"44   (BC_6, A(35),               bidir,          0,           47,        0,     Z),     "&
"45   (BC_2, *,                   control,        0),          "&
"46   (BC_2, *,                   control,        0),          "&
"47   (BC_2, *,                   control,        0),          "&
"48   (BC_6, SHD0_L,              bidir,          0,           94,        0,     Z),     "&
"49   (BC_6, A(3),                bidir,          0,           46,        0,     Z),     "&
"50   (BC_2, *,                   control,        0),          "&
"51   (BC_2, *,                   control,        0),          "&
"52   (BC_2, *,                   control,        0),          "&
"53   (BC_6, A(18),               bidir,          0,           60,        0,     Z),     "&
"54   (BC_6, A(14),               bidir,          0,           46,        0,     Z),     "&
"55   (BC_2, *,                   control,        0),          "&
"56   (BC_2, *,                   control,        0),          "&
"57   (BC_2, TA_L,                input,          X),          "&
"58   (BC_6, GBL_L,               bidir,          0,           79,        0,     Z),     "&
"59   (BC_6, A(20),               bidir,          0,           60,        0,     Z),     "&
"60   (BC_2, *,                   control,        0),          "&
"61   (BC_2, *,                   control,        0),          "&
"62   (BC_6, A(13),               bidir,          0,           65,        0,     Z),     "&
"63   (BC_6, A(11),               bidir,          0,           66,        0,     Z),     "&
"64   (BC_6, A(21),               bidir,          0,           60,        0,     Z),     "&
"65   (BC_2, *,                   control,        0),          "&
"66   (BC_2, *,                   control,        0),          "&
"67   (BC_6, A(19),               bidir,          0,           50,        0,     Z),     "&
"68   (BC_6, A(29),               bidir,          0,           50,        0,     Z),     "&
"69   (BC_6, A(5),                bidir,          0,           66,        0,     Z),     "&
"70   (BC_2, *,                   control,        0),          "&
"71   (BC_6, A(15),               bidir,          0,           70,        0,     Z),     "&
"72   (BC_6, A(25),               bidir,          0,           74,        0,     Z),     "&
"73   (BC_6, A(31),               bidir,          0,           70,        0,     Z),     "&
"74   (BC_2, *,                   control,        0),          "&
"75   (BC_2, *,                   control,        0),          "&
"76   (BC_6, A(17),               bidir,          0,           74,        0,     Z),     "&
"77   (BC_2, TBEN,                input,          X),          "&
"78   (BC_6, TS_L,                bidir,          0,           81,        0,     Z),     "&
"79   (BC_2, *,                   control,        0),          "&
"80   (BC_2, *,                   control,        0),          "&
"81   (BC_2, *,                   control,        0),          "&
"82   (BC_6, A(27),               bidir,          0,           50,        0,     Z),     "&
"83   (BC_6, AP(1),               bidir,          0,           85,        0,     Z),     "&
"84   (BC_6, A(28),               bidir,          0,           50,        0,     Z),     "&
"85   (BC_2, *,                   control,        0),          "&
"86   (BC_2, *,                   control,        0),          "&
"87   (BC_6, AP(0),               bidir,          0,           85,        0,     Z),     "&
"88   (BC_6, AP(3),               bidir,          0,           85,        0,     Z),     "&
"89   (BC_6, A(24),               bidir,          0,           55,        0,     Z),     "&
"90   (BC_2, *,                   control,        0),          "&
"91   (BC_2, INT_L,               input,          X),          "&
"92   (BC_1, WT_L,                output3,        0,           90,        0,     Z),     "&
"93   (BC_6, A(26),               bidir,          0,           55,        0,     Z),     "&
"94   (BC_2, *,                   control,        0),          "&
"95   (BC_2, BG_L,                input,          X),          "&
"96   (BC_1, CI_L,                output3,        0,           80,        0,     Z),     "&
"97   (BC_6, A(22),               bidir,          0,           55,        0,     Z),     "&
"98   (BC_6, A(30),               bidir,          0,           74,        0,     Z),     "&
"99   (BC_2, TEA_L,               input,          X),          "&
"100  (BC_2, DBG_L,               input,          X),          "&
"101  (BC_2, DTI(1),              input,          X),          "&
"102  (BC_2, DTI(0),              input,          X),          "&
"103  (BC_6, ARTRY_L,             bidir,          0,           106,       0,     Z),     "&
"104  (BC_2, *,                   control,        0),          "&
"105  (BC_2, *,                   control,        0),          "&
"106  (BC_2, *,                   control,        0),          "&
"107  (BC_2, DTI(2),              input,          X),          "&
"108  (BC_2, AACK_L,              input,          X),          "&
"109  (BC_1, TSIZ(0),             output3,        0,           113,       0,     Z),     "&
"110  (BC_2, DTI(3),              input,          X),          "&
"111  (BC_6, DP(2),               bidir,          0,           105,       0,     Z),     "&
"112  (BC_1, TSIZ(1),             output3,        0,           113,       0,     Z),     "&
"113  (BC_2, *,                   control,        0),          "&
"114  (BC_2, *,                   control,        0),          "&
"115  (BC_6, DP(4),               bidir,          0,           122,       0,     Z),     "&
"116  (BC_1, QREQ_L,              output3,        0,           114,       0,     Z),     "&
"117  (BC_1, TSIZ(2),             output3,        0,           113,       0,     Z),     "&
"118  (BC_2, *,                   control,        0),          "&
"119  (BC_6, D(59),               bidir,          0,           104,       0,     Z),     "&
"120  (BC_6, D(56),               bidir,          0,           104,       0,     Z),     "&
"121  (BC_6, DP(0),               bidir,          0,           105,       0,     Z),     "&
"122  (BC_2, *,                   control,        0),          "&
"123  (BC_6, DP(1),               bidir,          0,           118,       0,     Z),     "&
"124  (BC_6, DP(7),               bidir,          0,           122,       0,     Z),     "&
"125  (BC_1, DRDY_L,              output3,        0,           126,       0,     Z),     "&
"126  (BC_2, *,                   control,        0),          "&
"127  (BC_2, *,                   control,        0),          "&
"128  (BC_2, *,                   control,        0),          "&
"129  (BC_6, D(34),               bidir,          0,           104,       0,     Z),     "&
"130  (BC_6, D(60),               bidir,          0,           128,       0,     Z),     "&
"131  (BC_6, DP(5),               bidir,          0,           122,       0,     Z),     "&
"132  (BC_6, D(32),               bidir,          0,           128,       0,     Z),     "&
"133  (BC_6, D(37),               bidir,          0,           128,       0,     Z),     "&
"134  (BC_6, D(33),               bidir,          0,           104,       0,     Z),     "&
"135  (BC_2, *,                   control,        0),          "&
"136  (BC_2, *,                   control,        0),          "&
"137  (BC_6, D(58),               bidir,          0,           127,       0,     Z),     "&
"138  (BC_6, D(39),               bidir,          0,           127,       0,     Z),     "&
"139  (BC_6, D(54),               bidir,          0,           128,       0,     Z),     "&
"140  (BC_2, *,                   control,        0),          "&
"141  (BC_6, DP(6),               bidir,          0,           140,       0,     Z),     "&
"142  (BC_6, D(19),               bidir,          0,           167,       0,     Z),     "&
"143  (BC_6, D(35),               bidir,          0,           128,       0,     Z),     "&
"144  (BC_2, *,                   control,        0),          "&
"145  (BC_6, DP(3),               bidir,          0,           136,       0,     Z),     "&
"146  (BC_6, D(57),               bidir,          0,           135,       0,     Z),     "&
"147  (BC_6, D(36),               bidir,          0,           127,       0,     Z),     "&
"148  (BC_2, *,                   control,        0),          "&
"149  (BC_6, D(31),               bidir,          0,           148,       0,     Z),     "&
"150  (BC_6, D(62),               bidir,          0,           135,       0,     Z),     "&
"151  (BC_6, D(38),               bidir,          0,           135,       0,     Z),     "&
"152  (BC_2, *,                   control,        0),          "&
"153  (BC_6, D(22),               bidir,          0,           163,       0,     Z),     "&
"154  (BC_6, D(63),               bidir,          0,           144,       0,     Z),     "&
"155  (BC_6, D(61),               bidir,          0,           144,       0,     Z),     "&
"156  (BC_6, D(25),               bidir,          0,           152,       0,     Z),     "&
"157  (BC_6, D(30),               bidir,          0,           152,       0,     Z),     "&
"158  (BC_6, D(29),               bidir,          0,           152,       0,     Z),     "&
"159  (BC_2, *,                   control,        0),          "&
"160  (BC_6, D(24),               bidir,          0,           159,       0,     Z),     "&
"161  (BC_6, D(28),               bidir,          0,           152,       0,     Z),     "&
"162  (BC_6, D(27),               bidir,          0,           159,       0,     Z),     "&
"163  (BC_2, *,                   control,        0),          "&
"164  (BC_6, D(18),               bidir,          0,           181,       0,     Z),     "&
"165  (BC_6, D(26),               bidir,          0,           159,       0,     Z),     "&
"166  (BC_6, D(21),               bidir,          0,           163,       0,     Z),     "&
"167  (BC_2, *,                   control,        0),          "&
"168  (BC_6, D(8),                bidir,          0,           167,       0,     Z),     "&
"169  (BC_6, D(23),               bidir,          0,           163,       0,     Z),     "&
"170  (BC_6, D(9),                bidir,          0,           163,       0,     Z),     "&
"171  (BC_6, D(14),               bidir,          0,           167,       0,     Z),     "&
"172  (BC_6, D(40),               bidir,          0,           135,       0,     Z),     "&
"173  (BC_6, D(16),               bidir,          0,           167,       0,     Z),     "&
"174  (BC_2, *,                   control,        0),          "&
"175  (BC_6, D(17),               bidir,          0,           174,       0,     Z),     "&
"176  (BC_6, D(15),               bidir,          0,           174,       0,     Z),     "&
"177  (BC_6, D(20),               bidir,          0,           174,       0,     Z),     "&
"178  (BC_6, D(50),               bidir,          0,           185,       0,     Z),     "&
"179  (BC_6, D(10),               bidir,          0,           174,       0,     Z),     "&
"180  (BC_6, D(55),               bidir,          0,           185,       0,     Z),     "&
"181  (BC_2, *,                   control,        0),          "&
"182  (BC_6, D(2),                bidir,          0,           193,       0,     Z),     "&
"183  (BC_6, D(11),               bidir,          0,           181,       0,     Z),     "&
"184  (BC_6, D(13),               bidir,          0,           181,       0,     Z),     "&
"185  (BC_2, *,                   control,        0),          "&
"186  (BC_6, D(49),               bidir,          0,           185,       0,     Z),     "&
"187  (BC_6, D(41),               bidir,          0,           144,       0,     Z),     "&
"188  (BC_6, D(6),                bidir,          0,           189,       0,     Z),     "&
"189  (BC_2, *,                   control,        0),          "&
"190  (BC_6, D(1),                bidir,          0,           189,       0,     Z),     "&
"191  (BC_6, D(12),               bidir,          0,           189,       0,     Z),     "&
"192  (BC_6, D(4),                bidir,          0,           189,       0,     Z),     "&
"193  (BC_2, *,                   control,        0),          "&
"194  (BC_6, D(52),               bidir,          0,           198,       0,     Z),     "&
"195  (BC_6, D(3),                bidir,          0,           181,       0,     Z),     "&
"196  (BC_6, D(5),                bidir,          0,           193,       0,     Z),     "&
"197  (BC_2, *,                   control,        0),          "&
"198  (BC_2, *,                   control,        0),          "&
"199  (BC_6, D(42),               bidir,          0,           198,       0,     Z),     "&
"200  (BC_6, D(0),                bidir,          0,           193,       0,     Z),     "&
"201  (BC_6, D(51),               bidir,          0,           198,       0,     Z),     "&
"202  (BC_2, *,                   control,        0),          "&
"203  (BC_6, D(53),               bidir,          0,           202,       0,     Z),     "&
"204  (BC_6, D(47),               bidir,          0,           202,       0,     Z),     "&
"205  (BC_6, D(7),                bidir,          0,           193,       0,     Z),     "&
"206  (BC_6, D(48),               bidir,          0,           197,       0,     Z),     "&
"207  (BC_6, D(43),               bidir,          0,           197,       0,     Z),     "&
"208  (BC_6, D(45),               bidir,          0,           197,       0,     Z),     "&
"209  (BC_6, D(44),               bidir,          0,           197,       0,     Z),     "&
"210  (BC_6, D(46),               bidir,          0,           197,       0,     Z),     "&
"211  (BC_2, *,                   control,        0),          "&
"212  (BC_6, L3_DATA(7),          bidir,          0,           221,       0,     Z),     "&
"213  (BC_6, L3_DATA(2),          bidir,          0,           219,       0,     Z),     "&
"214  (BC_6, L3_DATA(5),          bidir,          0,           221,       0,     Z),     "&
"215  (BC_6, L3_DATA(9),          bidir,          0,           231,       0,     Z),     "&
"216  (BC_6, L3_DATA(0),          bidir,          0,           219,       0,     Z),     "&
"217  (BC_6, L3_DATA(4),          bidir,          0,           221,       0,     Z),     "&
"218  (BC_6, L3_DATAP(0),         bidir,          0,           211,       0,     Z),     "&
"219  (BC_2, *,                   control,        0),          "&
"220  (BC_6, L3_DATA(3),          bidir,          0,           219,       0,     Z),     "&
"221  (BC_2, *,                   control,        0),          "&
"222  (BC_2, *,                   control,        0),          "&
"223  (BC_6, L3_DATA(8),          bidir,          0,           231,       0,     Z),     "&
"224  (BC_6, L3_DATA(15),         bidir,          0,           233,       0,     Z),     "&
"225  (BC_6, L3_DATA(1),          bidir,          0,           219,       0,     Z),     "&
"226  (BC_6, L3_ECHO_CLK(0),      bidir,          0,           227,       0,     Z),     "&
"227  (BC_2, *,                   control,        0),          "&
"228  (BC_6, L3_DATAP(1),         bidir,          0,           222,       0,     Z),     "&
"229  (BC_6, L3_DATA(11),         bidir,          0,           231,       0,     Z),     "&
"230  (BC_6, L3_DATA(6),          bidir,          0,           221,       0,     Z),     "&
"231  (BC_2, *,                   control,        0),          "&
"232  (BC_6, L3_DATA(14),         bidir,          0,           233,       0,     Z),     "&
"233  (BC_2, *,                   control,        0),          "&
"234  (BC_1, L3_CLK(0),           output3,        0,           238,       0,     Z),     "&
"235  (BC_6, L3_DATA(10),         bidir,          0,           231,       0,     Z),     "&
"236  (BC_6, L3_DATA(12),         bidir,          0,           233,       0,     Z),     "&
"237  (BC_6, L3_DATA(13),         bidir,          0,           233,       0,     Z),     "&
"238  (BC_2, *,                   control,        0),          "&
"239  (BC_6, L3_DATA(29),         bidir,          0,           251,       0,     Z),     "&
"240  (BC_6, L3_DATA(27),         bidir,          0,           249,       0,     Z),     "&
"241  (BC_2, *,                   internal,       0),          "&
"242  (BC_2, *,                   control,        0),          "&
"243  (BC_6, L3_DATA(24),         bidir,          0,           249,       0,     Z),     "&
"244  (BC_6, L3_DATA(26),         bidir,          0,           249,       0,     Z),     "&
"245  (BC_6, L3_DATA(22),         bidir,          0,           259,       0,     Z),     "&
"246  (BC_6, L3_DATA(17),         bidir,          0,           272,       0,     Z),     "&
"247  (BC_6, L3_DATA(30),         bidir,          0,           251,       0,     Z),     "&
"248  (BC_6, L3_DATAP(2),         bidir,          0,           263,       0,     Z),     "&
"249  (BC_2, *,                   control,        0),          "&
"250  (BC_6, L3_DATA(19),         bidir,          0,           255,       0,     Z),     "&
"251  (BC_2, *,                   control,        0),          "&
"252  (BC_2, *,                   control,        0),          "&
"253  (BC_6, L3_DATA(18),         bidir,          0,           255,       0,     Z),     "&
"254  (BC_6, L3_DATA(31),         bidir,          0,           251,       0,     Z),     "&
"255  (BC_2, *,                   control,        0),          "&
"256  (BC_6, L3_DATAP(3),         bidir,          0,           242,       0,     Z),     "&
"257  (BC_6, L3_ECHO_CLK(1),      bidir,          0,           252,       0,     Z),     "&
"258  (BC_6, L3_DATA(21),         bidir,          0,           259,       0,     Z),     "&
"259  (BC_2, *,                   control,        0),          "&
"260  (BC_6, L3_DATA(23),         bidir,          0,           259,       0,     Z),     "&
"261  (BC_6, L3_DATA(20),         bidir,          0,           259,       0,     Z),     "&
"262  (BC_6, L3_DATA(28),         bidir,          0,           251,       0,     Z),     "&
"263  (BC_2, *,                   control,        0),          "&
"264  (BC_6, L3_DATA(25),         bidir,          0,           249,       0,     Z),     "&
"265  (BC_2, *,                   control,        0),          "&
"266  (BC_6, L3_DATA(16),         bidir,          0,           255,       0,     Z),     "&
"267  (BC_1, L3_CNTL(1),          output3,        0,           265,       0,     Z),     "&
"268  (BC_1, L3_ADDR(18),         output3,        0,           292,       0,     Z),     "&
"269  (BC_1, L3_ADDR(0),          output3,        0,           286,       0,     Z),     "&
"270  (BC_1, L3_ADDR(6),          output3,        0,           274,       0,     Z),     "&
"271  (BC_1, L3_CNTL(0),          output3,        0,           265,       0,     Z),     "&
"272  (BC_2, *,                   control,        0),          "&
"273  (BC_1, L3_ADDR(13),         output3,        0,           280,       0,     Z),     "&
"274  (BC_2, *,                   control,        0),          "&
"275  (BC_1, L3_ADDR(4),          output3,        0,           274,       0,     Z),     "&
"276  (BC_1, L3_ADDR(7),          output3,        0,           286,       0,     Z),     "&
"277  (BC_1, L3_ADDR(3),          output3,        0,           274,       0,     Z),     "&
"278  (BC_1, L3_ADDR(8),          output3,        0,           280,       0,     Z),     "&
"279  (BC_1, L3_ADDR(11),         output3,        0,           297,       0,     Z),     "&
"280  (BC_2, *,                   control,        0),          "&
"281  (BC_1, L3_ADDR(12),         output3,        0,           292,       0,     Z),     "&
"282  (BC_1, L3_ADDR(17),         output3,        0,           292,       0,     Z),     "&
"283  (BC_1, L3_ADDR(16),         output3,        0,           297,       0,     Z),     "&
"284  (BC_1, L3_ADDR(2),          output3,        0,           274,       0,     Z),     "&
"285  (BC_1, L3_ADDR(9),          output3,        0,           292,       0,     Z),     "&
"286  (BC_2, *,                   control,        0),          "&
"287  (BC_1, L3_ADDR(14),         output3,        0,           292,       0,     Z),     "&
"288  (BC_1, L3_ADDR(5),          output3,        0,           286,       0,     Z),     "&
"289  (BC_1, L3_ADDR(15),         output3,        0,           286,       0,     Z),     "&
"290  (BC_1, L3_ADDR(1),          output3,        0,           280,       0,     Z),     "&
"291  (BC_1, L3_ADDR(10),         output3,        0,           280,       0,     Z),     "&
"292  (BC_2, *,                   control,        0),          "&
"293  (BC_6, L3_DATA(45),         bidir,          0,           313,       0,     Z),     "&
"294  (BC_6, L3_DATA(44),         bidir,          0,           313,       0,     Z),     "&
"295  (BC_6, L3_DATA(34),         bidir,          0,           301,       0,     Z),     "&
"296  (BC_6, L3_ECHO_CLK(2),      bidir,          0,           305,       0,     Z),     "&
"297  (BC_2, *,                   control,        0),          "&
"298  (BC_6, L3_DATAP(4),         bidir,          0,           308,       0,     Z),     "&
"299  (BC_6, L3_DATA(32),         bidir,          0,           301,       0,     Z),     "&
"300  (BC_6, L3_DATA(43),         bidir,          0,           312,       0,     Z),     "&
"301  (BC_2, *,                   control,        0),          "&
"302  (BC_2, *,                   control,        0),          "&
"303  (BC_6, L3_DATA(35),         bidir,          0,           301,       0,     Z),     "&
"304  (BC_6, L3_DATA(33),         bidir,          0,           301,       0,     Z),     "&
"305  (BC_2, *,                   control,        0),          "&
"306  (BC_6, L3_DATA(41),         bidir,          0,           312,       0,     Z),     "&
"307  (BC_6, L3_DATA(39),         bidir,          0,           302,       0,     Z),     "&
"308  (BC_2, *,                   control,        0),          "&
"309  (BC_6, L3_DATA(42),         bidir,          0,           312,       0,     Z),     "&
"310  (BC_6, L3_DATA(46),         bidir,          0,           313,       0,     Z),     "&
"311  (BC_6, L3_DATA(37),         bidir,          0,           302,       0,     Z),     "&
"312  (BC_2, *,                   control,        0),          "&
"313  (BC_2, *,                   control,        0),          "&
"314  (BC_2, *,                   internal,       0),          "&
"315  (BC_6, L3_DATA(40),         bidir,          0,           312,       0,     Z),     "&
"316  (BC_2, *,                   control,        0),          "&
"317  (BC_6, L3_DATA(47),         bidir,          0,           313,       0,     Z),     "&
"318  (BC_6, L3_DATA(36),         bidir,          0,           302,       0,     Z),     "&
"319  (BC_6, L3_DATAP(5),         bidir,          0,           308,       0,     Z),     "&
"320  (BC_1, L3_CLK(1),           output3,        0,           316,       0,     Z),     "&
"321  (BC_6, L3_DATA(38),         bidir,          0,           302,       0,     Z),     "&
"322  (BC_6, L3_DATA(50),         bidir,          0,           326,       0,     Z),     "&
"323  (BC_6, L3_DATA(49),         bidir,          0,           326,       0,     Z),     "&
"324  (BC_6, L3_DATA(51),         bidir,          0,           326,       0,     Z),     "&
"325  (BC_6, L3_DATA(54),         bidir,          0,           330,       0,     Z),     "&
"326  (BC_2, *,                   control,        0),          "&
"327  (BC_6, L3_ECHO_CLK(3),      bidir,          0,           341,       0,     Z),     "&
"328  (BC_6, L3_DATA(52),         bidir,          0,           330,       0,     Z),     "&
"329  (BC_6, L3_DATA(53),         bidir,          0,           330,       0,     Z),     "&
"330  (BC_2, *,                   control,        0),          "&
"331  (BC_6, L3_DATA(59),         bidir,          0,           344,       0,     Z),     "&
"332  (BC_6, L3_DATA(55),         bidir,          0,           330,       0,     Z),     "&
"333  (BC_6, L3_DATAP(7),         bidir,          0,           350,       0,     Z),     "&
"334  (BC_2, *,                   control,        0),          "&
"335  (BC_6, L3_DATAP(6),         bidir,          0,           334,       0,     Z),     "&
"336  (BC_6, L3_DATA(56),         bidir,          0,           344,       0,     Z),     "&
"337  (BC_6, L3_DATA(57),         bidir,          0,           344,       0,     Z),     "&
"338  (BC_6, L3_DATA(62),         bidir,          0,           349,       0,     Z),     "&
"339  (BC_6, L3_DATA(61),         bidir,          0,           349,       0,     Z),     "&
"340  (BC_6, L3_DATA(48),         bidir,          0,           326,       0,     Z),     "&
"341  (BC_2, *,                   control,        0),          "&
"342  (BC_6, L3_DATA(58),         bidir,          0,           344,       0,     Z),     "&
"343  (BC_6, L3_DATA(60),         bidir,          0,           349,       0,     Z),     "&
"344  (BC_2, *,                   control,        0),          "&
"345  (BC_6, L3_DATA(63),         bidir,          0,           349,       0,     Z),     "&
"346  (BC_2, DX_L,                input,          X),          "&
"347  (BC_4, L3VSEL,              observe_only,   0),          "&
"348  (BC_6, TBST_L,              bidir,          0,           352,       0,     Z),     "&
"349  (BC_2, *,                   control,        0),          "&
"350  (BC_2, *,                   control,        0),          "&
"351  (BC_2, SRW_L(1),            input,          X),          "&
"352  (BC_2, *,                   control,        0),          "&
"353  (BC_2, *,                   control,        0),          "&
"354  (BC_2, SRW_L(0),            input,          X),          "&
"355  (BC_2, EXT_QUAL,            input,          X),          "&
"356  (BC_2, PMON_IN_L,           input,          X),          "&
"357  (BC_1, PMON_OUT_L,          output3,        0,           353,       0,     Z),     "&
"358  (BC_2, MCP_L,               input,          X),          "&
"359  (BC_2, PLL_CFG(1),          input,          X),          "&
"360  (BC_2, PLL_CFG(0),          input,          X),          "&
"361  (BC_2, HRESET_L,            input,          X),          "&
"362  (BC_2, PLL_EXT,             input,          X),          "&
"363  (BC_2, BMODE_L(0),          input,          X),          "&
"364  (BC_2, PLL_CFG(2),          input,          X),          "&
"365  (BC_4, BVSEL,               observe_only,   0),          "&
"366  (BC_2, PLL_CFG(3),          input,          X),          "&
"367  (BC_2, BMODE_L(1),          input,          X),          "&
"368  (BC_2, SYSCLK,              input,          X)          ";
end MPC7457;
