/** @file domain.c
  *
  * @brief This file contains WLAN driver specific defines etc.
  *
  * Copyright 2002-2020 NXP
  *
  * This software file (the "File") is distributed by NXP
  * under the terms of the GNU General Public License Version 2, June 1991
  * (the "License").  You may use, redistribute and/or modify the File in
  * accordance with the terms and conditions of the License, a copy of which
  * is available by writing to the Free Software Foundation, Inc.,
  * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA or on the
  * worldwide web at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
  *
  * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
  * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about
  * this warranty disclaimer.
  *
  */

#include "wltypes.h"
#include "domain.h"
#include "IEEE_types.h"
#include "hostcmd.h"
#include "macMgmtMlme.h"

#ifdef IEEE80211H
extern UINT8 bcn_reg_domain;
#endif /* IEEE80211H */

#ifdef SOC_W906X
#define MaxMultiDomainCapabilityEntryA 31	//20
#define MaxMultiDomainCapabilityEntryG 1
#endif

#define CTRY_DEBUG 0x1ff
#define CTRY_DEFAULT 0

struct countryCodeToEnumRd {
	u16 countryCode;
	u16 regDmnEnum;
	const char *isoName;
};

typedef struct _DOMAIN {
	UINT8 domainCode;
	UINT8 regulatory;
	UINT8 ChannelList[IEEE_80211_MAX_NUMBER_OF_CHANNELS];
} DOMAIN;
typedef struct _MultiDomainCapabilityEntry {
	UINT8 FirstChannelNo;
	UINT8 NoofChannel;
	UINT8 MaxTransmitPw;
} PACK_END MultiDomainCapabilityEntry;

typedef struct _DOMAIN_TXPOWER {
	UINT8 domainCode;
	UINT8 CountryString[3];
	UINT8 GChannelLen;
	MultiDomainCapabilityEntry DomainEntryG[MaxMultiDomainCapabilityEntryG];
	UINT8 AChannelLen;
	MultiDomainCapabilityEntry DomainEntryA[MaxMultiDomainCapabilityEntryA];
} PACK_END DOMAIN_TXPOWER;

op_class_info_t op_class_info[] = {
	{DOMAIN_CODE_FCC, 19, {
			       {81, 30, 2, {12, 13}}, {83, 30, 0, {0}}, {84, 30,
									 2, {12,
									     13}},
			       {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
								      0, {0}},
			       {118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24,
								      0, {0}},
			       {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123, 30,
									1,
									{144}},
			       {124, 23, 0, {0}}, {125, 23, 1, {169}}, {126, 23,
									0, {0}},
			       {127, 23, 0, {0}},
			       {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								      0, {0}}}},
	{DOMAIN_CODE_IC, 19, {
			      {81, 30, 2, {12, 13}}, {83, 30, 0, {0}}, {84, 30,
									2, {12,
									    13}},
			      {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17, 0,
								     {0}},
			      {118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24, 0,
								     {0}},
			      {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123, 30,
								       1,
								       {144}},
			      {124, 23, 0, {0}}, {125, 23, 1, {169}}, {126, 23,
								       0, {0}},
			      {127, 23, 0, {0}},
			      {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23, 0,
								     {0}}}},
	{DOMAIN_CODE_ETSI, 15, {
				{81, 20, 0, {0}}, {83, 20, 0, {0}}, {84, 20, 0,
								     {0}},
				{115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
								       0, {0}},
				{118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24,
								       0, {0}},
				{121, 30, 1, {144}}, {122, 30, 0, {0}}, {123,
									 30, 1,
									 {144}},
				{128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								       0,
								       {0}}}},
	{DOMAIN_CODE_SPAIN, 15, {
				 {81, 20, 0, {0}}, {83, 20, 0, {0}}, {84, 20, 0,
								      {0}},
				 {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
									0, {0}},
				 {118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24,
									0, {0}},
				 {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123,
									  30, 1,
									  {144}},
				 {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
									0,
									{0}}}},
	{DOMAIN_CODE_FRANCE, 14, {
				  {81, 20, 9, {1, 2, 3, 4, 5, 6, 7, 8, 9}}, {84,
									     20,
									     5,
									     {5,
									      6,
									      7,
									      8,
									      9}},
				  {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117,
									 17, 0,
									 {0}},
				  {118, 24, 0, {0}}, {119, 24, 0, {0}}, {120,
									 24, 0,
									 {0}},
				  {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123,
									   30,
									   1,
									   {144}},
				  {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130,
									 23, 0,
									 {0}}}},
	{DOMAIN_CODE_MKK, 16, {
			       {81, 23, 0, {0}}, {82, 23, 0, {0}}, {83, 23, 0,
								    {0}}, {84,
									   23,
									   0,
									   {0}},
			       {115, 23, 0, {0}}, {116, 23, 0, {0}}, {117, 23,
								      0, {0}},
			       {118, 23, 0, {0}}, {119, 23, 0, {0}}, {120, 23,
								      0, {0}},
			       {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123, 30,
									1,
									{144}},
			       {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								      0, {0}}}},
	{DOMAIN_CODE_DGT, 17, {
			       {81, 30, 0, {0}}, {83, 30, 0, {0}}, {84, 30, 0,
								    {0}},
			       {115, 23, 0, {0}}, {118, 23, 0, {0}}, {119, 23,
								      0, {0}},
			       {120, 23, 0, {0}},
			       {121, 23, 1, {144}}, {122, 23, 0, {0}}, {123, 23,
									1,
									{144}},
			       {124, 23, 0, {0}}, {125, 23, 2, {165, 169}},
			       {126, 23, 0, {0}}, {127, 23, 0, {0}},
			       {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								      0, {0}}}},
	{DOMAIN_CODE_AUS, 19, {
			       {81, 20, 0, {0}}, {83, 20, 0, {0}}, {84, 20, 0,
								    {0}},
			       {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
								      0, {0}},
			       {118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24,
								      0, {0}},
			       {121, 30, 1, {144}}, {122, 30, 0, {0}}, {123, 30,
									1,
									{144}},
			       {124, 23, 0, {0}}, {125, 23, 1, {169}}, {126, 23,
									0, {0}},
			       {127, 23, 0, {0}},
			       {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								      0, {0}}}},
	{DOMAIN_CODE_ASIA, 19, {
				{81, 20, 0, {0}}, {83, 20, 0, {0}}, {84, 20, 0,
								     {0}},
				{115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
								       0, {0}},
				{118, 24, 0, {0}}, {119, 24, 0, {0}}, {120, 24,
								       0, {0}},
				{121, 30, 1, {144}}, {122, 30, 0, {0}}, {123,
									 30, 1,
									 {144}},
				{124, 30, 0, {0}}, {125, 30, 1, {169}}, {126,
									 30, 0,
									 {0}},
				{127, 30, 0, {0}},
				{128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								       0,
								       {0}}}},

	{DOMAIN_CODE_ALL, 20, {
			       {81, 30, 0, {0}}, {82, 30, 0, {0}}, {83, 30, 0,
								    {0}}, {84,
									   30,
									   0,
									   {0}},
			       {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17,
								      0, {0}},
			       {118, 23, 0, {0}}, {119, 23, 0, {0}}, {120, 23,
								      0, {0}},
			       {121, 23, 1, {144}}, {122, 23, 0, {0}}, {123, 23,
									1,
									{144}},
			       {124, 23, 0, {0}}, {125, 23, 1, {169}}, {126, 23,
									0, {0}},
			       {127, 23, 0, {0}},
			       {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23,
								      0, {0}}}},
	{0, 14, {
		 {81, 30, 0, {0}}, {82, 30, 0, {0}}, {83, 30, 0, {0}}, {84, 30,
									0, {0}},
		 {115, 17, 0, {0}}, {116, 17, 0, {0}}, {117, 17, 0, {0}},
		 {124, 23, 0, {0}}, {125, 23, 1, {169}}, {126, 23, 0, {0}},
		 {127, 23, 0, {0}},
		 {128, 23, 0, {0}}, {129, 23, 0, {0}}, {130, 23, 0, {0}}}},
};

#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT
extern UINT8 mib_channelspacing;
#endif

DFS_CHANNEL_LIST dfsEnabledChannels[] = {
#ifdef BARBADOS_DOMAIN
	{DOMAIN_BARBADOS_B,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 144, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0}},
#endif
	{DOMAIN_CODE_FCC,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_IC,
	 {0, 52, 56, 60, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_ETSI,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_SPAIN,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_FRANCE,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_ITALY,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_MKK,
	 {0, 0, 0, 0, 0, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0, 132,
	  136, 140, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_DGT,
	 {0, 38, 42, 46, 0, 184, 188, 192, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_AUS,
	 {0, 38, 42, 46, 0, 184, 188, 192, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_ASIA,
	 {0, 52, 56, 60, 64, 0, 100, 104, 108, 112, 0, 116, 120, 124, 128, 0,
	  132, 136, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
	{DOMAIN_CODE_CHN,
	 {0, 52, 56, 60, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0}},
};

GRP_CHANNEL_LIST_160Mhz GrpChList160Mhz[3] =
	{ {{36, 40, 44, 48, 52, 56, 60, 64}},
	{{100, 104, 108, 112, 116, 120, 124, 128}},
{{149, 153, 157, 161, 165, 169, 173, 177}}
};
GRP_CHANNEL_LIST_80Mhz GrpChList80Mhz[7] =
	{ {{36, 40, 44, 48}}, {{52, 56, 60, 64}}, {{100, 104, 108, 112}},
	{{116, 120, 124, 128}},
{{132, 136, 140, 144}}, {{149, 153, 157, 161}}, {{165, 169, 173, 177}}
};
GRP_CHANNEL_LIST_40Mhz GrpChList40Mhz[16] =
	{ {{36, 40}}, {{44, 48}}, {{52, 56}}, {{60, 64}}, {{100, 104}},
	{{108, 112}}, {{116, 120}}, {{124, 128}},
{{132, 136}}, {{140, 144}}, {{149, 153}}, {{157, 161}}, {{165, 169}},
	{{173, 177}},
{{184, 188}}, {{192, 196}}
};				// Japan 4.9G

static DOMAIN_TXPOWER IEEERegionPower[] = {
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_FCC, {'U', 'S', ' '}, 3, {{1, 11, 30}},
	 72, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},								    /** USA **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** USA **/
#endif
#else
	{DOMAIN_CODE_FCC, {'U', 'S', ' '}, 3, {{1, 11, 30}},
	 27, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},										    /** USA **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** USA **/
#endif
#endif

#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_IC, {'C', 'A', ' '}, 3, {{1, 11, 30}},
	 72, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},								    /** CANADA **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** CANADA **/
#endif
#else /*!DFS_CHNL_SUPPORT */
	{DOMAIN_CODE_IC, {'C', 'A', ' '}, 3, {{1, 11, 30}},
	 27, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},										    /** CANADA **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** CANADA **/
#endif
#endif

#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_ETSI, {'E', 'U', ' '}, 3, {{1, 13, 20}},
	 57, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},									  /** EUROPE **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** EUROPE **/
#endif
#else /*!DFS_CHNL_SUPPORT */
	{DOMAIN_CODE_ETSI, {'E', 'U', ' '}, 3, {{1, 13, 20}},
	 12, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** EUROPE **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** EUROPE **/
#endif
#endif

	{DOMAIN_CODE_SPAIN, {'E', 'S', ' '}, 3, {{1, 13, 20}},
	 57, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** SPAIN **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** SPAIN **/
#endif

	{DOMAIN_CODE_FRANCE, {'F', 'R', ' '}, 3, {{10, 4, 20}},
	 57, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** FRANCE **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** FRANCE **/
#endif

	{DOMAIN_CODE_ITALY, {'I', 'T', ' '}, 3, {{1, 13, 20}},
	 57, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** FRANCE **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** FRANCE **/
#endif

	{DOMAIN_CODE_MKK, {'J', 'P', ' '}, 3, {{1, 14, 23}},
	 39, {{36, 1, 23}, {40, 1, 23}, {44, 1, 23}, {48, 1, 23},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {144, 1, 30}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},											     /** JAPAN W53 & W56**/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0},
			 /** JAPAN W53 & W56**/
#endif
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}
	 },
#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT
	{DOMAIN_CODE_MKK2, {'J', 'P', ' '}, 3, {{1, 14, 23}},
	 33, {{7, 1, 23}, {8, 1, 23}, {11, 1, 23}, {183, 1, 23}, {184, 1, 23},
	      {185, 1, 23},
	      {187, 1, 23}, {188, 1, 23}, {189, 1, 23}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},										    /** JAPAN with channel spacing 10**/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** JAPAN with channel spacing 10**/
#endif
#endif

	{DOMAIN_CODE_DGT, {'T', 'W', ' '}, 3, {{1, 11, 30}},
	 57, {{52, 1, 23}, {56, 1, 23}, {60, 1, 23}, {64, 1, 23},
	      {100, 1, 23}, {104, 1, 23}, {108, 1, 23}, {112, 1, 23}, {116, 1,
								       23},
	      {120, 1, 23}, {124, 1, 23}, {128, 1, 23}, {132, 1, 23}, {136, 1,
								       23},
	      {140, 1, 23},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** Taiwan **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** Taiwan **/
#endif

#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_AUS, {'A', 'U', ' '}, 3, {{1, 13, 30}},
	 72, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},								    /** Australia new code with 1-13, 32-48, 52-64, 100-140 and 149-165 **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** Australia new code with 1-13, 32-48, 52-64, 100-140 and 149-165 **/
#endif
#else
	{DOMAIN_CODE_AUS, {'A', 'U', ' '}, 3, {{1, 13, 20}},
	 12, {{149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
#ifdef SOC_W906X
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},											 /** Australia **/
#else
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** Australia **/
#endif
#endif
	{DOMAIN_CODE_ASIA, {'A', 'S', ' '}, 3, {{1, 13, 20}},
	 69, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 30}, {104, 1, 30}, {108, 1, 30}, {112, 1, 30}, {116, 1,
								       30},
	      {120, 1, 30}, {124, 1, 30}, {128, 1, 30}, {132, 1, 30}, {136, 1,
								       30},
	      {140, 1, 30},
#ifdef SOC_W906X
	      {149, 1, 30}, {153, 1, 30}, {157, 1, 30}, {161, 1, 30}, {165, 1, 30}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}},								      /** ASIA **/
#else
	      {149, 1, 30}, {153, 1, 30}, {157, 1, 30}, {161, 1, 30}, {165, 1,
								       30}, {0,
									     0,
									     0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** ASIA **/
#endif
#ifdef SOC_W906X
	{DOMAIN_CODE_ALL, {'A', 'L', 'L'}, 3, {{1, 14, 30}},
	 90, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {100, 1, 23}, {104, 1, 23}, {108, 1, 23}, {112, 1, 23}, {116, 1,
								       23},
	      {120, 1, 23}, {124, 1, 23}, {128, 1, 23}, {132, 1, 23}, {136, 1,
								       23},
	      {140, 1, 23},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {183, 1, 23}, {184, 1, 23}, {185, 1, 23}, {187, 1, 23}, {188, 1,
								       23},
	      {189, 1, 23},
	      {0, 0, 0}}},				   /** DEFAULT **/

	{0, {'X', 'X', ' '}, 3, {{1, 14, 30}},
	 27, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}}}								   /** DEFAULT **/
#else
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_CHN, {'C', 'N', ' '}, 3, {{1, 13, 30}},
	 39, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}
	      }},
	     /** CHINA **/
#else
	{DOMAIN_CODE_CHN, {'C', 'N', ' '}, 3, {{1, 13, 30}},
	 27, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }},
	     /** CHINA **/
#endif
	{DOMAIN_CODE_ALL, {'A', 'L', 'L'}, 3, {{1, 14, 30}},
	 138, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	       {52, 1, 24}, {56, 1, 24}, {60, 1, 24}, {64, 1, 24}, {68, 1, 24},
	       {72, 1, 24}, {76, 1, 24}, {80, 1, 24}, {84, 1, 24}, {88, 1, 24},
	       {92, 1, 24}, {96, 1, 24},
	       {100, 1, 23}, {104, 1, 23}, {108, 1, 23}, {112, 1, 23}, {116, 1,
									23},
	       {120, 1, 23}, {124, 1, 23}, {128, 1, 23}, {132, 1, 23}, {136, 1,
									23},
	       {140, 1, 23}, {144, 1, 23},
	       {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
									23},
	       {169, 1, 23}, {173, 1, 23}, {177, 1, 23}, {181, 1, 23},
	       {183, 7, 23}, {192, 1, 23}, {194, 1, 23}, {196, 1, 23}, {7, 3, 23}, {11, 1, 23}, {12, 1, 23}, {16, 1, 23},	// 4.9G Japan
	       {201, 26, 23},	// 4.9G Public Safety
	       {0, 0, 0}
	       }},
	     /** DEFAULT **/

	{0, {'X', 'X', ' '}, 3, {{1, 14, 30}},
	 27, {{36, 1, 17}, {40, 1, 17}, {44, 1, 17}, {48, 1, 17},
	      {149, 1, 23}, {153, 1, 23}, {157, 1, 23}, {161, 1, 23}, {165, 1,
								       23},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0},
	      {0, 0, 0},
	      {0, 0, 0}, {0, 0, 0}
	      }}
	    /** DEFAULT **/
#endif
};

static DOMAIN IEEERegionChannel[] = {
#ifdef BARBADOS_DOMAIN
	{DOMAIN_BARBADOS_B, DOMAIN_CODE_FCC,
	 {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,
	  36, 40, 44, 48, 52, 56, 60, 64, 100, 104,
	  108, 112, 116, 120, 124, 128, 132, 136, 140, 144,
	  149, 153, 157, 161, 165, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0}},
#endif

#endif //end of BARBADOS_DOMAIN

	/* US FCC */
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_FCC, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,	/*US FCC 2.4GHz */
					    36, 40, 44, 48,	/*US FCC 5GHz UNII-1 */
					    52, 56, 60, 64,	/*US FCC UNII-2 */
#ifdef FCC_15E_INTERIM_PLAN
					    100, 104, 108, 112, 116, 132, 136, 140,	/*US FCC UNII-2 EXT */
					    144, 149, 153, 157, 161, 165,	/*US FCC UNII-2 */
					    0, 0, 0, 0, 0, 0,	/*Filler for ch 120,124,128 */
#else
					    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*US FCC UNII-2 EXT */
					    144, 149, 153, 157, 161, 165, 0, 0, 0,	/*US FCC UNII-2 */
#endif
					    0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					    0, 0, 0, 0, 0, 0}},
#else
					    0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0}},
#endif
#else /*!DFS_CHNL_SUPPORT */
	{DOMAIN_CODE_FCC, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,	/*US FCC 2.4GHz */
					    36, 40, 44, 48,	/*US FCC 5GHz UNII-1 */
					    149, 153, 157, 161, 165,	/*US FCC UNII-2 */
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0}},
#endif
#endif

	/* Canada IC */
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_IC, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,	/*Canada IC 2.4GHZ */
					   36, 40, 44, 48,	/*Canada IC 5GHz UNII-1 */
					   52, 56, 60, 64,	/*Canada IC UNII-2 */
#ifdef FCC_15E_INTERIM_PLAN
					   100, 104, 108, 112, 116, 132, 136, 140,	/*Canada IC UNII-2 EXT */
#ifdef SOC_W906X
					   149, 153, 157, 161,	/*Canada IC UNII-2 */
#else
					   149, 153, 157, 161, 165,	/*Canada IC UNII-2 */
#endif
					   0, 0, 0,	/*Filler for ch 120,144,128 */
#else
					   100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*Canada IC UNII-2 EXT */
#ifdef SOC_W906X
					   149, 153, 157, 161,	/*Canada IC UNII-2 */
#else
					   149, 153, 157, 161, 165,	/*Canada IC UNII-2 */
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0,
#endif
#endif
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0}},
#else /*!DFS_CHNL_SUPPORT */
	{DOMAIN_CODE_IC, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,	/*Canada IC 2.4GHZ */
					   36, 40, 44, 48,	/*Canada IC 5GHz UNII-1 */
#ifdef SOC_W906X
					   149, 153, 157, 161,	/*Canada IC UNII-2 */
#else
					   149, 153, 157, 161, 165,	/*Canada IC UNII-2 */
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0,
#endif
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#endif

	/* EU ETSI */
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_ETSI, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*EU 2.4GHz */
					      36, 40, 44, 48,	/*EU 5GHz UNII-1 */
					      52, 56, 60, 64,	/*EU 5GHz UNII-2 */
#ifdef SOC_W906X
					      100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 0,	/*EU 5GHz UNII-2 EXT */
#else
					      100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 0,	/*EU 5GHz UNII-2 EXT */
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0,
#endif
					      0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else /*!DFS_CHNL_SUPPORT */
	{DOMAIN_CODE_ETSI, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*EU 2.4GHz */
					      36, 40, 44, 48,	/*EU 5GHz UNII-1 */
					      0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0}},
#endif
#endif

	/* SPAIN */
	{DOMAIN_CODE_SPAIN, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/* 2.4GHz */
					       36, 40, 44, 48,	/*5GHz UNII-1 */
					       52, 56, 60, 64,	/*5GHz UNII-2 */
					       100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
#ifdef SOC_W906X
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					       0, 0, 0, 0, 0, 0}},
#endif
	 /*FRANCE*/ {DOMAIN_CODE_FRANCE, DOMAIN_CODE_ETSI, {10, 11, 12, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/*2.4 GHz */
							    36, 40, 44, 48,	/*5GHz UNII-1 */
							    52, 56, 60, 64,	/*5GHz UNII-2 */
							    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
#ifdef SOC_W906X
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0}},
#else
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0,
							    0, 0, 0, 0, 0, 0, 0,
							    0, 0, 0,
							    0, 0, 0, 0, 0, 0}},
#endif
	 /*ITALY*/ {DOMAIN_CODE_ITALY, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/* 2.4GHz */
							  36, 40, 44, 48,	/*5GHz UNII-1 */
							  52, 56, 60, 64,	/*5GHz UNII-2 */
							  100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
#ifdef SOC_W906X
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0}},
#else
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0,
							  0, 0, 0, 0, 0, 0, 0,
							  0, 0, 0,
							  0, 0, 0, 0, 0, 0}},
#endif
	/* JAPAN MKK */
	{DOMAIN_CODE_MKK, DOMAIN_CODE_MKK, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,	/*2.4 GHz */
					    36, 40, 44, 48,	/*5GHz UNII-1 */
					    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
#ifdef SOC_W906X
					    144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0,
#else
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0,
#endif
					    0, 0, 0, 0}
	 },
#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT							/** currently not support on A7c chip **/
	{DOMAIN_CODE_MKK, DOMAIN_CODE_MKK,
	 {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	  7, 8, 11, 183,
	  184, 185, 187, 188, 189, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0}},
#else
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0}},
#endif
#endif

	/* DGT */
	{DOMAIN_CODE_DGT, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,	/*2.4 GHz */
					    52, 56, 60, 64,	/*5GHz UNII-2 */
					    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
					    149, 153, 157, 161,	/*5GHz UNII-2 */
#ifdef SOC_W906X
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0}},
#else
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0}},
#endif

	/* AU */
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_AUS, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4 GHz */
					    36, 40, 44, 48,	/*5GHz UNII-1 */
					    52, 56, 60, 64,	/*5GHz UNII-2 */
#ifdef SOC_W906X
#ifdef FCC_15E_INTERIM_PLAN
					    100, 104, 108, 112, 116, 132, 136, 140,	/*5GHz UNII-2 EXT */
					    149, 153, 157, 161,	/*5GHz UNII-2 */
					    0, 0, 0,
#else
					    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
					    149, 153, 157, 161,	/*5GHz UNII-2 */
#endif
#else
					    100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
					    149, 153, 157, 161, 165,	/*5GHz UNII-2 */
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0,
#endif
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0}},
#else /*!DOMAIN_CODE_AUS */
	{DOMAIN_CODE_AUS, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4 GHz */
#ifdef SOC_W906X
					    149, 153, 157, 161,	/*5GHz UNII-2 */
#else
					    36, 40, 44, 48,	/*5GHz UNII-1 */
					    149, 153, 157, 161, 165,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0,
#endif
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					    0, 0, 0, 0, 0, 0}},
#endif
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_ASIA, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4GHz */
					      36, 40, 44, 48,	/*5GHz UNII-1 */
					      52, 56, 60, 64,	/*5GHz UNII-2 */
					      100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,	/*5GHz UNII-2 EXT */
					      149, 153, 157, 161, 165,	/*5GHz UNII-2 */
					      0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0}},
#endif
#else /*!DOMAIN_CODE_ASIA */
	{DOMAIN_CODE_ASIA, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4GHz */
					      36, 40, 44, 48,	/*5GHz UNII-1 */
					      149, 153, 157, 161, 165,	/*5GHz UNII-2 */
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					      0, 0, 0, 0, 0, 0}},
#endif
#endif
#ifdef DFS_CHNL_SUPPORT
	{DOMAIN_CODE_CHN, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4 GHz */
					     36, 40, 44, 48,	/*5GHz UNII-1 */
					     52, 56, 60, 64,	/*5GHz UNII-2 */
					     149, 153, 157, 161, 165,	/*5GHz UNII-2 */
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					     0, 0, 0, 0, 0, 0, 0}},
#else
					     0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0}},
#endif
#else /*!DOMAIN_CODE_CHN */
	{DOMAIN_CODE_CHN, DOMAIN_CODE_ETSI, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 0,	/*2.4 GHz */
					     36, 40, 44, 48,	/*5GHz UNII-1 */
					     149, 153, 157, 161, 165,	/*5GHz UNII-2 */
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
					     0, 0, 0, 0, 0, 0}},
#endif
#endif
	/* ALL */
#ifdef SOC_W906X
	{DOMAIN_CODE_ALL, DOMAIN_CODE_FCC,
	 {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	  36, 40, 44, 48, 52, 56, 60, 64, 100, 104,
	  108, 112, 116, 120, 124, 128, 132, 136, 140, 144,
	  149, 153, 157, 161, 165, 169, 173, 177, 181, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	  0, 0, 0, 0, 0, 0, 0, 0, 0, 0}},
#else
	{DOMAIN_CODE_ALL, DOMAIN_CODE_FCC,
	 {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
	  36, 40, 44, 48, 52, 56, 60, 64,
	  68, 72, 76, 80, 84, 88, 92, 96,
	  100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140, 144,
	  149, 153, 157, 161, 165, 169, 173, 177, 181,
	  183, 184, 185, 186, 187, 188, 189, 192, 194, 196,	// Japan 4.9G
	  7, 8, 9, 11, 12, 16,	// Japan 4.9G
	  201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213,	// Public Safety 4.9G
	  214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226,	// Public Safety 4.9G
	  0, 0, 0, 0, 0, 0, 0,
	  }},
#endif

	/* Default set */
	{0, DOMAIN_CODE_FCC, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0, 0, 0,
			      36, 40, 44, 48,
			      149, 153, 157, 161, 165,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
#ifdef SOC_W906X
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}
#else
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			      0, 0, 0, 0, 0, 0}}
#endif
};

int
domainSetDomain(UINT8 domain)
{
#ifdef IEEE80211H
	bcn_reg_domain = domain;
#endif /* IEEE80211H */
	return 0;
}

UINT8
domainGetDomain(void)
{
#ifdef IEEE80211H
	return bcn_reg_domain;
#endif /* IEEE80211H */
}

static int
isInChannelList(UINT8 channel, UINT8 band, UINT8 * ChannelList)
{
	int i;

	if (band == FREQ_BAND_5GHZ) {
		for (i = 14; i < IEEE_80211_MAX_NUMBER_OF_CHANNELS; i++) {
			if (channel != 0 && channel == ChannelList[i])
				return 1;
		}
	} else {
		for (i = 0; i < 14; i++) {
			if (channel != 0 && channel == ChannelList[i])
				return 1;
		}
	}
	return 0;
}

int
domainChannelValid(UINT8 channel, UINT8 band)
{
	int i = 0;
	UINT8 domainCode = 0;

#ifdef IEEE80211H
	if (bcn_reg_domain)
		domainCode = bcn_reg_domain;
#else
	domainCode = GetDomainCode();
#endif /* IEEE80211H */
	while (IEEERegionChannel[i].domainCode) {
		if (domainCode == IEEERegionChannel[i].domainCode) {
#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT
			if (mib_channelspacing == 10) {	/** hack for Japan channel spacing of 10 **/
				i++;			/** use the next channel list instead **/
			}
#endif
			return isInChannelList(channel, band,
					       IEEERegionChannel[i].
					       ChannelList);
		}
		i++;
	}
	return isInChannelList(channel, band, IEEERegionChannel[i].ChannelList);
}

/*
** domainGetInfo
*
*  FILENAME: D:\jshen\802.11_MAC-DRIVER_SW\AP\Src\domain.c
*
*  PARAMETERS:
*
*  DESCRIPTION:
*
*  RETURNS:
*
*/
int
domainGetInfo(UINT8 * ChannelList /* NULL Terminate */ )
{
	int i = 0;
	UINT8 domainCode = 0;

#ifdef IEEE80211H
	if (bcn_reg_domain)
		domainCode = bcn_reg_domain;
#else
	domainCode = GetDomainCode();
#endif /* IEEE80211H */

	while (IEEERegionChannel[i].domainCode) {
		if (domainCode == IEEERegionChannel[i].domainCode) {
#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT
			if (mib_channelspacing == 10) {	/** hack for Japan channel spacing of 10 **/
				i++;			/** use the next channel list instead **/
			}
#endif
			memcpy(ChannelList, IEEERegionChannel[i].ChannelList,
			       IEEE_80211_MAX_NUMBER_OF_CHANNELS);
			return 1;
		}
		i++;
	}
	memcpy(ChannelList, IEEERegionChannel[i].ChannelList,
	       IEEE_80211_MAX_NUMBER_OF_CHANNELS);
	return 0;
}

/*
** domainGetPowerInfo
*
*
*  PARAMETERS:
*
*  DESCRIPTION:
*
*  RETURNS:
*
*/
int
domainGetPowerInfo(UINT8 * info)
{
	int i = 0;
	UINT8 domainCode = 0;
	void *pcountry_str = (void *)IEEERegionPower[0].CountryString;

#ifdef IEEE80211H
	if (bcn_reg_domain)
		domainCode = bcn_reg_domain;
#else
	domainCode = GetDomainCode();
#endif /* IEEE80211H */

	while (IEEERegionPower[i].domainCode) {
		if (domainCode == IEEERegionPower[i].domainCode) {
#ifdef JAPAN_CHANNEL_SPACING_10_SUPPORT
			if (mib_channelspacing == 10) {	/** hack for Japan channel spacing of 10 **/
				i++;			/** use the next channel list instead **/
			}
#endif
			pcountry_str = (void *)IEEERegionPower[i].CountryString;
			memcpy(info, pcountry_str,
			       sizeof(DOMAIN_TXPOWER) -
			       sizeof(IEEERegionPower[i].domainCode));
			return 1;
		}
		i++;
	}
	memcpy(info, pcountry_str,
	       sizeof(DOMAIN_TXPOWER) - sizeof(IEEERegionPower[i].domainCode));
	return 0;
}

unsigned char
domainGetRegulatory(UINT8 domainCode)
{
	int i = 0;

	while (IEEERegionChannel[i].domainCode) {
		if (domainCode == IEEERegionChannel[i].domainCode) {
			return IEEERegionChannel[i].regulatory;
		}
		i++;
	}
	return DOMAIN_CODE_FCC;
}

int
domainGetSizeOfdfsEnabledChannels(void)
{
	return (sizeof(dfsEnabledChannels));
}

int
domainGetSizeOfIEEERegionChannel(void)
{
	return (sizeof(IEEERegionChannel));
}

int
domainGetSizeOfGrpChList40Mhz(void)
{
	return (sizeof(GrpChList40Mhz));
}

int
domainGetSizeOfGrpChList80Mhz(void)
{
	return (sizeof(GrpChList80Mhz));
}

int
domainGetSizeOfGrpChList160Mhz(void)
{
	return (sizeof(GrpChList160Mhz));
}

BOOLEAN
channel_exists(UINT8 channel, UINT8 * list, UINT8 len)
{
	UINT8 i;

	for (i = 0; i < len; i++) {
		if (list[i] == channel)
			return TRUE;
	}
	return FALSE;
}

void
Get5GChannelList(UINT8 domainCode, UINT8 * IEEERegionChannel_5G)
{
	UINT8 domain = 0;
	UINT8 i, j, k;

	for (i = 0; i < domainGetSizeOfIEEERegionChannel() / sizeof(DOMAIN);
	     i++) {
		domain = IEEERegionChannel[i].domainCode;
		if (domain != domainCode) {
			continue;
		}
		k = 0;
		for (j = 0; j < IEEE_80211_MAX_NUMBER_OF_CHANNELS; j++) {
			if (IEEERegionChannel[i].ChannelList[j] >= 36) {
				IEEERegionChannel_5G[k] =
					IEEERegionChannel[i].ChannelList[j];
				k++;
			}
		}

	}

}

BOOLEAN
Is160MzChannel(UINT8 testchannel, UINT8 domainInd_IEEERegion)
{
	UINT8 i, j;
	UINT8 ExistCnt = 0;

	for (i = 0;
	     i <
	     domainGetSizeOfGrpChList160Mhz() / sizeof(GRP_CHANNEL_LIST_160Mhz);
	     i++) {
		if (channel_exists
		    (testchannel, GrpChList160Mhz[i].channelEntry, 8)) {
			break;
		}
	}
	if (i ==
	    domainGetSizeOfGrpChList160Mhz() /
	    sizeof(GRP_CHANNEL_LIST_160Mhz)) {
		return FALSE;
	}

	for (j = 0; j < 8; j++) {
		if (channel_exists
		    (GrpChList160Mhz[i].channelEntry[j],
		     IEEERegionChannel[domainInd_IEEERegion].ChannelList,
		     IEEE_80211_MAX_NUMBER_OF_CHANNELS)) {
			ExistCnt++;
		} else {
			break;
		}
	}
	if (ExistCnt != 8) {
		return FALSE;
	}
	return TRUE;

}

BOOLEAN
IsTestchannel80MzChannel(UINT8 testchannel, UINT8 domainInd_IEEERegion)
{
	UINT8 i, j;
	UINT8 ExistCnt = 0;

	for (i = 0;
	     i <
	     domainGetSizeOfGrpChList80Mhz() / sizeof(GRP_CHANNEL_LIST_80Mhz);
	     i++) {
		if (channel_exists
		    (testchannel, GrpChList80Mhz[i].channelEntry, 4)) {
			break;
		}
	}
	if (i ==
	    domainGetSizeOfGrpChList80Mhz() / sizeof(GRP_CHANNEL_LIST_80Mhz)) {
		return FALSE;
	}

	for (j = 0; j < 4; j++) {
		if (channel_exists
		    (GrpChList80Mhz[i].channelEntry[j],
		     IEEERegionChannel[domainInd_IEEERegion].ChannelList,
		     IEEE_80211_MAX_NUMBER_OF_CHANNELS)) {
			ExistCnt++;
		} else {
			break;
		}
	}
	if (ExistCnt != 4) {
		return FALSE;
	}
	return TRUE;

}

BOOLEAN
IsTestchannel40MzChannel(UINT8 testchannel, UINT8 domainInd_IEEERegion)
{
	UINT8 i, j;
	UINT8 ExistCnt = 0;

	for (i = 0;
	     i <
	     domainGetSizeOfGrpChList40Mhz() / sizeof(GRP_CHANNEL_LIST_40Mhz);
	     i++) {
		if (channel_exists
		    (testchannel, GrpChList40Mhz[i].channelEntry, 2)) {
			break;
		}
	}
	if (i ==
	    domainGetSizeOfGrpChList40Mhz() / sizeof(GRP_CHANNEL_LIST_40Mhz)) {
		return FALSE;
	}

	for (j = 0; j < 2; j++) {
		if (channel_exists
		    (GrpChList40Mhz[i].channelEntry[j],
		     IEEERegionChannel[domainInd_IEEERegion].ChannelList,
		     IEEE_80211_MAX_NUMBER_OF_CHANNELS)) {
			ExistCnt++;
		} else {
			break;
		}
	}
	if (ExistCnt != 2) {
		return FALSE;
	}
	return TRUE;

}

BOOLEAN
Is80MzChannelInFallBack(UINT8 * FallbackChannelList, UINT8 fallbackchannel,
			UINT8 fallbackCnt)
{
	UINT8 i, j;
	UINT8 ExistCnt = 0;

	for (i = 0;
	     i <
	     domainGetSizeOfGrpChList80Mhz() / sizeof(GRP_CHANNEL_LIST_80Mhz);
	     i++) {
		if (channel_exists
		    (fallbackchannel, GrpChList80Mhz[i].channelEntry, 4)) {
			break;
		}
	}
	if (i ==
	    domainGetSizeOfGrpChList80Mhz() / sizeof(GRP_CHANNEL_LIST_80Mhz)) {
		return FALSE;
	}
	for (j = 0; j < 4; j++) {
		if (channel_exists
		    (GrpChList80Mhz[i].channelEntry[j], FallbackChannelList,
		     fallbackCnt)) {
			ExistCnt++;
		}
	}
	if (ExistCnt != 4) {
		return FALSE;
	}
	return TRUE;

}

BOOLEAN
Is40MzChannel(UINT8 * FallbackChannelList, UINT8 fallbackchannel,
	      UINT8 fallbackCnt)
{
	UINT8 extChanOffset;

	extChanOffset = macMgmtMlme_Get40MHzExtChannelOffset(fallbackchannel);

	if (extChanOffset == EXT_CH_BELOW_CTRL_CH) {
		fallbackchannel -= 4;
	} else {
		fallbackchannel += 4;
	}

	if (channel_exists(fallbackchannel, FallbackChannelList, fallbackCnt)) {
		return TRUE;
	}
	return FALSE;

}

void
GetDfs160MhzGrpChan(UINT8 domainInd, UINT8 channel, UINT8 * GrpChan)
{
	UINT8 i, j;

	for (i = 0;
	     i <
	     domainGetSizeOfGrpChList160Mhz() / sizeof(GRP_CHANNEL_LIST_160Mhz);
	     i++) {
		if (channel_exists(channel, GrpChList160Mhz[i].channelEntry, 8)) {
			break;
		}
	}
	if (i ==
	    domainGetSizeOfGrpChList160Mhz() /
	    sizeof(GRP_CHANNEL_LIST_160Mhz)) {
		printk("error:cannot get 160Mhz group channel list \n");
		return;
	}

	for (j = 0; j < 8; j++) {
		GrpChan[j] = GrpChList160Mhz[i].channelEntry[j];
	}
	return;
}

int
GetDomainIndxIEEERegion(UINT8 domainCode)
{
	UINT8 i;

	i = 0;
	while (IEEERegionChannel[i].domainCode) {
		if (domainCode == IEEERegionChannel[i].domainCode) {
			break;
		}
		i++;
	}
	return i;
}

int
GetRegionChan(UINT8 domainInd_IEEERegion, UINT8 j)
{
	return (IEEERegionChannel[domainInd_IEEERegion].ChannelList[j]);
}

UINT8 *
GetRegionChanList(UINT8 domainInd_IEEERegion)
{
	return IEEERegionChannel[domainInd_IEEERegion].ChannelList;
}

int
GetRegionChanIndx(UINT8 domainInd_IEEERegion, UINT8 channel)
{
	SINT32 i;

	for (i = 0; i < IEEE_80211_MAX_NUMBER_OF_CHANNELS; i++) {
		if (IEEERegionChannel[domainInd_IEEERegion].ChannelList[i] ==
		    channel) {
			break;
		}
	}

	return i;
}

UINT8
FindFallbackChannel(UINT8 fallbackCnt, UINT8 * FallbackChannelList, UINT8 BW)
{
	UINT8 j, fallbackchannel = 0;
	UINT8 m = 0xff, randInd = 0;

	randInd = jiffies % fallbackCnt;

	for (j = 0; j < fallbackCnt; j++) {
		if ((j + randInd) < fallbackCnt) {
			fallbackchannel = FallbackChannelList[j + randInd];
			if (BW == CH_80_MHz_WIDTH) {
				if (Is80MzChannelInFallBack
				    (FallbackChannelList, fallbackchannel,
				     fallbackCnt)) {
					break;
				}

			}
			if (BW == CH_40_MHz_WIDTH) {
				if (Is40MzChannel
				    (FallbackChannelList, fallbackchannel,
				     fallbackCnt)) {
					break;
				}
			}

		}
	}
	if (j == fallbackCnt) {
		for (m = 0; m < randInd; m++) {
			fallbackchannel = FallbackChannelList[m];
			if (BW == CH_80_MHz_WIDTH) {
				if (Is80MzChannelInFallBack
				    (FallbackChannelList, fallbackchannel,
				     fallbackCnt)) {
					break;
				}
			}
			if (BW == CH_40_MHz_WIDTH) {
				if (Is40MzChannel
				    (FallbackChannelList, fallbackchannel,
				     fallbackCnt)) {
					break;
				}
			}

		}
	}

	if (m == randInd) {

		return 0;
	}
	return fallbackchannel;
}

void
getChnlList(UINT8 domainCode, UINT8 * IEEERegionChnls)
{
	UINT8 i = 0, j = 0, k = 0;

	for (i = 0; i < domainGetSizeOfIEEERegionChannel() / sizeof(DOMAIN);
	     i++) {
		if (IEEERegionChannel[i].domainCode == domainCode) {
			for (j = 0; j < IEEE_80211_MAX_NUMBER_OF_CHANNELS; j++) {
				IEEERegionChnls[k] =
					IEEERegionChannel[i].ChannelList[j];
				k++;
			}
		}
	}
}

#ifdef CONCURRENT_DFS_SUPPORT
int
GetNumOfChList160Mhz(void)
{
	return NELEMENTS(GrpChList160Mhz);
}

int
GetNumOfChList80Mhz(void)
{
	return NELEMENTS(GrpChList80Mhz);
}

int
GetNumOfChList40Mhz(void)
{
	return NELEMENTS(GrpChList40Mhz);
}
#endif /* CONCURRENT_DFS_SUPPORT */

void
getOpClass(op_class_info_t * pOpClass)
{
	u8 domainCode = 0;
	u8 len = 0;
	u8 i;

	if (!pOpClass)
		return;

	domainCode = domainGetDomain();
	len = sizeof(op_class_info) / sizeof(op_class_info_t);

	for (i = 0; i < len; i++) {
		if (op_class_info[i].domain_code == domainCode) {
			memcpy(pOpClass, &op_class_info[i],
			       sizeof(op_class_info_t));
			return;
		}
	}
}
