#include "pt60_tower.h"
#include "common.h"

/******************************************************************************
* Global functions
******************************************************************************/
void Button_Init(void);
void configure_LEDs_for_GPIO(void);
void configure_LEDs_for_PWM ();

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: Button_Init
*
* @brief initialize button switches.
*        
* @param  none 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void Button_Init(void)	
{	
	/* Initialize Keyboard 1 */
	KBI1_SC_KBIE = 0;	/* mask interrupt */ 
	//KBI1_ES = KBI1_ES_KBEDG4_MASK | KBI1_ES_KBEDG5_MASK;  /* rising edge */ 
	PORT_PTDPE = PORT_PTDPE_PTDPE4_MASK | PORT_PTDPE_PTDPE5_MASK  ;	/* enable pullup */
	KBI1_PE = KBI1_PE_KBIPE4_MASK | KBI1_PE_KBIPE5_MASK; /* enable KBI pin */
	KBI1_SC_KBACK = 1;		
	KBI1_SC_KBIE  = 1;
	
	LED_ELECTROD_PTG0_Init();
	LED_ELECTROD_PTG0_Off();
}

/************************************************************************
*       configure_LEDs_for_PWM - Set up TPM1 and TPM2                   *
*************************************************************************
; Since the LEDs are connected to the Timer/Pulse Width Modulator modules (TPMs),
; we can configure the TPMs to generate an edge-aligned PWM signal. 
*/
void configure_LEDs_for_PWM (void)
{
    /* Configure TPM1 to generate PWM signals */
	// always high level

	
    FTM1_SC = 0;                                 /* Stop the timer */ 

    /* Configure duty cycles of each channel
     
       NB: We choose a timer frequency = fbus / 16, so a period of 500 (MAX_PWM_VALUE)
       means that an LED will flash
       
            8 x 10E6 / (500 * 32) = 500 flashes/second 
            
       ...i.e. too fast to be detected by the human eye
    
    */
    FTM1_MOD = MAX_PWM_VALUE; 
    
    /* Configure TPMxCnSC for each channel as follows
        CHnF    = 0  Not used
        CHnIE   = 0  No interrupt
        MSnB:A  = 10 Edge-aligned PWM
        ELSnB:A = 01 Active-low pulse
    */   
    FTM1_C0SC = 0x24;       
    FTM1_C1SC = 0x24;                                               
    

    /* Repeat for TPM2 */
    FTM2_SC = 0;      
    FTM2_MOD = MAX_PWM_VALUE;
     
    FTM2_C0SC = 0x24;       
    FTM2_C1SC = 0x24;       
    FTM2_C2SC = 0x24;       
    FTM2_C3SC = 0x24;    
    FTM2_C4SC = 0x24;       
    FTM2_C5SC = 0x24; 
    
    FTM2_C0V = 100;  
    FTM2_C1V = 100;  
    FTM2_C2V = 100;  
    FTM2_C3V = 100;  
    FTM2_C4V = 100;  
    FTM2_C5V = 100;  
    FTM1_C0V = 100; 
    FTM1_C1V = 100;
    
	PTD0_Init();
	PTD0_Set();
    
    FTM1_SC  = 0x0D;                  /* Restart the timer: CLKS = 01 (Use BUSCLK), PS=101 (Divide-by-32) */
    FTM2_SC  = 0x0D;    
    

}

/************************************************************************
*       configure_LEDs_for_GPIO - Stop TPMs from driving LEDs           *
*************************************************************************
; Modifies the TPM channel configurations so that the TPMs no longer drive
; the LEDs. Control over the LEDs reverts to the GPIO method
*/
void configure_LEDs_for_GPIO(void)
{
	// disable the FTM
	FTM1_SC = 0x0;
	FTM2_SC = 0x0;
	
	// ELSnB:A = 00 : Pin reverts to GPIO 
    FTM2_C0SC = 0x00;       
    FTM2_C1SC = 0x00;       
    FTM2_C2SC = 0x00;       
    FTM2_C3SC = 0x00;
    FTM2_C4SC = 0x00;       
    FTM2_C5SC = 0x00;
    
    FTM1_C0SC = 0x00;       
    FTM1_C1SC = 0x00;
	
	// configure the pin as output
	LED1_Init();
	LED2_Init();
	LED3_Init();
	LED4_Init();
	LED5_Init();
	LED6_Init();
	LED7_Init();
	LED8_Init();	
	
	// always high level
	PTD0_Init();
	PTD0_Set();
}

/************************************************************************
*       leds_all_on - Turn all LEDs on                                  *
*************************************************************************/
void leds_all_on (void)
{
    configure_LEDs_for_GPIO ();
    PORT_PTCD &= ~0x3F;
    PORT_PTBD &= ~0x30;
}

/************************************************************************
*       leds_all_off - Turn all LEDs off                                *
*************************************************************************/
void leds_all_off (void)
{
    configure_LEDs_for_GPIO ();
    PTD0_Clear();
}

/************************************************************************
*       leds_cross - Turn on LEDs to form a "x" cross                   *
*************************************************************************
*/
void leds_cross(void)
{
    configure_LEDs_for_GPIO ();
    
    /* Set active LEDs */
    LED2_On();   //D6
    LED4_On();   //D8
    LED6_On();   //D10
    LED8_On();   //D12   
    
    LED1_Off();   //D6
    LED3_Off();   //D8
    LED5_Off();   //D10
    LED7_Off();   //D12      
}

/************************************************************************
*       leds_plus - Turn on LEDs to form a "+" plus sign                *
*************************************************************************
*/
void leds_plus(void)
{
    configure_LEDs_for_GPIO ();
    
    /* Set active spokes */
    LED1_On();   //D6
    LED3_On();   //D8
    LED5_On();   //D10
    LED7_On();   //D12   
    
    LED2_Off();   //D6
    LED4_Off();   //D8
    LED6_Off();   //D10
    LED8_Off();   //D12 
}
/*
 * end here
 */
