/*
 * TSI.C
 *
 *  Created on: Nov 22, 2011
 *      Author: B37811
 */

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "tsi.h"
/******************************************************************************
* Constants and macros
******************************************************************************/

/*****************************************************************************
* Local types
******************************************************************************/



/******************************************************************************
* Local variables
******************************************************************************/
byte LedElectrodOnFlag;                 /* indicate the TSI LED state */
ELECTRODE_WORK_INFO  m_ElecWorkInfo[ELECTRODE_NUM];
unsigned short m_uiScanValue[ELECTRODE_NUM];
unsigned char m_ucSignalChangeFlag;
unsigned char m_bScanCompleteFlag;
unsigned char m_ucChannelIndex;
unsigned char m_ucTSI_WorkState;
unsigned char m_ucMtim0IntCount;
/******************************************************************************
* Global functions
******************************************************************************/
void TSI_VaribleInit( void );
void TSI_Init( void );
void TSI_Scan( unsigned short *pResult );
void TSI_CheckState( void );
void TSI_Init( void );
void TSI_Processing( void );

//void KEY2_Processing( void );
//void KEY3_Processing( void );
//void KEY4_Processing( void );
//void TSI_Check( void );
//void TSI_EnterIntoStopMode( void );
//void MCU_EnterStopMode( void );
/******************************************************************************
* Local function prototypes
******************************************************************************/
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: TSI_VaribleInit
   *
   * @brief initialize TSI variables
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void TSI_VaribleInit( void )
{
//	unsigned char i;
//	m_ucChannelIndex = 0;
	m_ucTSI_WorkState = TSI_WORK_STATE_NULL;
	g_KeyCheckMode = KEY_CHECK_MODE_NORMAL;
//	for(i=0;i<ELECTRODE_NUM;i++)
//	{
		m_ElecWorkInfo[0].State = KEY_RELEASED;
		m_ElecWorkInfo[0].Channel = 12;          //enable channel 12
		m_ElecWorkInfo[0].Count = 0;
//	}

}

/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: TSI_Init
   *
   * @brief TSI module initialization
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void TSI_Init( void )
{
	unsigned char i,j;
	
	// TSI LED initial
	LED_ELECTROD_PTG0_Init();
	
	TSI_VaribleInit();
	//
	TSI_CS1_PS = TSI_CS1_PS_16;
	TSI_CS1_NSCN = TSI_CS1_NSCN_32;
	TSI_CS2 = TSI_CS2_REFCHRG_32uA | TSI_CS2_DVOLT_00 | TSI_CS2_EXTCHRG_32uA;
	
	// enable channel
	TSI_PEN1 = TSI_PEN1_VALUE;
	TSI_PEN0 = TSI_PEN0_VALUE;
	
	
	// enable stop mode
	//TSI_CS0_STPE = 1;

	// enable TSI
	TSI_CS0_TSIIEN = 0;   // polling first
//	TSI_CS0_STPE   = 1;   // TSI enabled in stop3 mode
	TSI_CS0_TSIEN  = 1;
	

	// Get baseline
	TSI_Scan(&m_uiScanValue[0]);
	for(i=0;i<ELECTRODE_NUM;i++)
    {
		m_ElecWorkInfo[i].BaseLine = m_uiScanValue[i];
	}
	for(j=0;j<10;j++)
	{
		TSI_Scan( &m_uiScanValue[0] );
		for(i=0;i<ELECTRODE_NUM;i++)
		{
				m_ElecWorkInfo[i].BaseLine = (m_uiScanValue[i]+m_ElecWorkInfo[i].BaseLine)>>1;
		}
	}
	TSI_CS0_TSIIEN = 1;  // enable TSI interrupt

}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: TSI_Scan
   *
   * @brief polling method to complete scanning all of electrode
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void TSI_Scan( unsigned short *pResult )
{
	unsigned char i;
	unsigned int uiScanValue;
	for(i=0;i<ELECTRODE_NUM;i++)
	{
		// specify the scanning channel	
		TSI_CS3_TSICH = m_ElecWorkInfo[i].Channel;
		// start scanning
		TSI_CS0 |= 0x01;
		// wait scan complete
		while(!TSI_CS0_EOSF);
		TSI_CS0_EOSF = 1;
		pResult[i] = TSI_CNT;	
	}
}

//void TSI_Start(void)
//{
//	unsigned char i;
//
//	for(i=0;i<ELECTRODE_NUM;i++)
//	{
//		// specify the scanning channel	
//		TSI_CS3_TSICH = m_ElecWorkInfo[i].Channel;
//		// start scanning
//		TSI_CS0 |= 0x01;
//	}	
//}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: TSI_Processing
   *
   * @brief process the scanning data to determine the key status
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void TSI_Processing( void )
{
	unsigned char i;
	unsigned short uiDelta;
	//start scan
#if( TSI_WORK_MODE == TSI_WORK_MODE_POLLING )
	TSI_Scan( &m_uiScanValue[0] ); 
	// calculate delta
	for(i=0;i<ELECTRODE_NUM;i++)
	{
		m_ElecWorkInfo[i].Delta = m_uiScanValue[i] - m_ElecWorkInfo[i].BaseLine;
	}
#elif ( TSI_WORK_MODE == TSI_WORK_MODE_INTERRUPT )
	m_uiScanValue[0] = TSI_CNT;  
	// calculate delta
	for(i=0;i<ELECTRODE_NUM;i++)
	{
		m_ElecWorkInfo[i].Delta = m_uiScanValue[i] - m_ElecWorkInfo[i].BaseLine;
	}
#endif	
	// determine key state
	for(i=0;i<ELECTRODE_NUM;i++)
	{
		if( m_ElecWorkInfo[i].Delta > 0 )
		{
			uiDelta = m_ElecWorkInfo[i].Delta;
		}
		else
		{
			uiDelta = 0;
		}
		if( uiDelta > KEY_ON_SENSITIVITY )
		{
			if( m_ElecWorkInfo[i].State == KEY_RELEASED )
			{
				if(m_ElecWorkInfo[i].Count > KEY_OVERTIME)
				{
					m_ElecWorkInfo[i].State = KEY_TOUCHED;
					m_ucSignalChangeFlag |= (0x01<<i);
					m_ElecWorkInfo[i].Count = 0;
					
					
				}
				else
				{
					m_ElecWorkInfo[i].Count ++;
				}
			}
			else if( m_ElecWorkInfo[i].State == KEY_TOUCHED )
			{
				//repeat touch
				
				//
			}
		}
		else if( uiDelta < KEY_OFF_SENSITIVITY )
		{
			
			if( m_ElecWorkInfo[i].State == KEY_TOUCHED )
			{
				
				if(m_ElecWorkInfo[i].Count > KEY_OVERTIME)
				{
					m_ElecWorkInfo[i].State = KEY_RELEASED;
					m_ucSignalChangeFlag |= (0x01<<i);
					m_ElecWorkInfo[i].Count = 0;
				}
				else
				{
					m_ElecWorkInfo[i].Count ++;
				}
			}
			else if( m_ElecWorkInfo[i].State == KEY_RELEASED )
			{
				// always released
				//
			}
		}
		else
		{
			// is noise or other
			//
		}
	}
	// check key state,processing
	TSI_CheckState();
}
/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: TSI_CheckState
   *
   * @brief check the change of the key status and implement the corresponding function
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void TSI_CheckState( void )
{
	unsigned char i;
	if( m_ucSignalChangeFlag != 0 )
	{
		
		// update data idle time 
//		m_ulIdleTimeCount = g_ulCurrentTimeCount;
		//key state occur change,handle corresponding key
		for(i=0;i<ELECTRODE_NUM;i++)
		{
			if( m_ucSignalChangeFlag&(0x01<<i) )
			{
				//key 0 release or touched
				if( m_ElecWorkInfo[i].State == KEY_TOUCHED)
				{
					//
					//KEY1_Processing();
					LED_ELECTROD_PTG0_Toggle();
					if(LedElectrodOnFlag == 0)
					{
						LedElectrodOnFlag = 1;
					}
					else
					{
						LedElectrodOnFlag = 0;
					}
					
				}
				//clear flag
				m_ucSignalChangeFlag &= (~(0x01<<i)); 
			}
		}
	}
	else
	{

	}
}


/*
 * end here
 */
