/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file mma8451.c
*
* @author B37811
*
* @version 0.0.1
*
* @date Sep 19, 2011
*
* @brief application entry point which performs application specific tasks. 
*
*******************************************************************************
*
* provide a demo for how to initialize the PT60, output messages via SCI, 
* flash operations, etc.
* NOTE:
*	printf call may occupy a lot of memory (around 1924 bytes), so please
*	consider your code size before using printf.
******************************************************************************/
#include "mma8451.h"
#include "pt60_tower.h"

void MMA8451_Standby(void);
void MMA8451_Active(void);
void MMA8451WriteRegister(byte address, byte reg,byte val);
byte u8MMA8451ReadRegister(byte address, byte reg);
void MMA8451WriteRegister_N(byte address, byte reg1,byte N,byte *array);
void MMA8451ReadRegister_N(byte address, byte reg1,byte N,byte *array);
void MMA8451_Read_3axis_data(void);

unsigned int  resultx, resulty, resultz;

/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MMA8451_Standby
   *
   * @brief description: configure the MMA8451 as standby mode
   *        
   * @parameter:  none
   *
   * @return: none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MMA8451_Standby(void)
{
    unsigned int n;
/*
** Read current value of System Control 1 Register.
** Put sensor into Standby Mode by clearing the Active bit
** Return with previous value of System Control 1 Register.
*/
    MMA8451WriteRegister(MMA8451_I2C_ADDRESS, CTRL_REG1, u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS,CTRL_REG1) & ~ACTIVE_MASK);
}


/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MMA8451_Active
   *
   * @brief description: configure the MMA8451 as Active mode
   *        
   * @parameter:  none
   *
   * @return: none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MMA8451_Active(void)
{
/*
** Set the Active bit in CTRL Reg 1
*/
    MMA8451WriteRegister(MMA8451_I2C_ADDRESS, CTRL_REG1, (u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, CTRL_REG1) | ACTIVE_MASK));
}

/*********************************************************\
* I2C Write Register
\*********************************************************/


void MMA8451WriteRegister(byte address, byte reg,byte val)
{
  I2C_C1_TX = 1;                                // Transmit Mode
  I2C_Start();                                  // Send Start
  I2C_CycleWrite(address);                      // Send I2C "Write" Address
  I2C_CycleWrite(reg);                          // Send Register
  I2C_CycleWrite(val);                          // Send Value
  I2C_Stop();                                   // Send Stop
}


/*********************************************************\
* I2C Read Register
\*********************************************************/
byte u8MMA8451ReadRegister(byte address, byte reg)
{
  byte b;
  I2C_C1_TX = 1;                                // Transmit Mode
  I2C_Start();                                  // Send Start
  I2C_CycleWrite(address);                      // Send I2C "Write" Address
  I2C_CycleWrite(reg);                          // Send Register
  I2C_RepeatStart();                            // Send Repeat Start
  I2C_CycleWrite(address+1);                    // Send I2C "Read" Address
  b = I2C_CycleRead(1);                         // *** Dummy read: reads "I2C_ReadAddress" value ***
  b = I2C_CycleRead(1);                         // Read Register Value
  I2C_Stop();                                   // Send Stop
  return b;
}


/*********************************************************\
* I2C Write Multiple Registers
\*********************************************************/
void MMA8451WriteRegister_N(byte address, byte reg1,byte N,byte *array)
{
  I2C_C1_TX = 1;                                // Transmit Mode
  I2C_Start();                                  // Send Start
  I2C_CycleWrite(address);                      // Send I2C "Write" Address
  I2C_CycleWrite(reg1);                         // Send Register
  while (N>0)                                   // Send N Values
  {
    I2C_CycleWrite(*array);
    array++;
    N--;
  }
  I2C_Stop();                                   // Send Stop
}


/*********************************************************\
* I2C Read Multiple Registers
\*********************************************************/
void MMA8451ReadRegister_N(byte address, byte reg1,byte N,byte *array)
{
  byte b;
  I2C_C1_TX = 1;                                // Transmit Mode
  I2C_Start();                                  // Send Start
  I2C_CycleWrite(address);                      // Send I2C "Write" Address
  I2C_CycleWrite(reg1);                         // Send Register
  I2C_RepeatStart();                            // Send Repeat Start
  I2C_CycleWrite(address+1);                    // Send I2C "Read" Address
  b = I2C_CycleRead(0);                         // *** Dummy read: reads "I2C_ReadAddress" value ***
  while (N>1)                                   // Read N-1 Register Values
  {
    b = I2C_CycleRead(0);
    *array = b;
    array++;
    N--;
  }
  b = I2C_CycleRead(1);
  *array = b;                                   // Read Last value
  I2C_Stop();                                   // Send Stop
}


/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MMA8451_Read_3axis_data
   *
   * @brief description: Read first three registers from the MMA8451
   *        
   * @parameter:  none
   *
   * @return: none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MMA8451_Read_3axis_data(void)
{
   // if((u8MMA8451ReadRegister(DATA_STATUS_REG) & 0x0f) != 0)  // polling
    {
        resultx   = u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x01)<<8;
        resultx  |= u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x02);
        resultx >>= 2;

        resulty   = u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x03)<<8;
        resulty  |= u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x04);
        resulty >>= 2;

        resultz   = u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x05)<<8;
        resultz  |= u8MMA8451ReadRegister(MMA8451_I2C_ADDRESS, 0x06);
        resultz >>= 2;
    }
}

/*
 * end here
 */
