/*
 * File:		stdlib.c
 * Purpose:		Functions normally found in a standard C lib.
 *
 * Notes:		This supports ASCII only!!!
 *
 */

#include "common.h" /* include peripheral declarations */
#include "stdlib.h"

/****************************************************************/
int8_t
isspace (int8_t ch)
{
	if ((ch == ' ') || (ch == '\t'))	/* \n ??? */
		return TRUE;
	else
		return FALSE;
}

/****************************************************************/
int8_t
isalnum (int8_t ch)
{
	/* ASCII only */
	if (((ch >= '0') && (ch <= '9')) ||
		((ch >= 'A') && (ch <= 'Z')) ||
		((ch >= 'a') && (ch <= 'z')))
		return TRUE;
	else
		return FALSE;
}

/****************************************************************/
int8_t
isdigit (int8_t ch)
{
	/* ASCII only */
	if ((ch >= '0') && (ch <= '9'))
		return TRUE;
	else
		return FALSE;
}

/****************************************************************/
int8_t
isupper (int8_t ch)
{
	/* ASCII only */
	if ((ch >= 'A') && (ch <= 'Z'))
		return TRUE;
	else
		return FALSE;
}

/****************************************************************/
int8_t
strcasecmp (const char *s1, const char *s2)
{
	char	c1, c2;
	int8_t		result = 0;

	while (result == 0)
	{
		c1 = *s1++;
		c2 = *s2++;
		if ((c1 >= 'a') && (c1 <= 'z'))
			c1 = (char)(c1 - ' ');
		if ((c2 >= 'a') && (c2 <= 'z'))
			c2 = (char)(c2 - ' ');
		if ((result = (c1 - c2)) != 0)
			break;
		if ((c1 == 0) || (c2 == 0))
			break;
	}
	return result;
}


/****************************************************************/
int8_t
strncasecmp (const char *s1, const char *s2, int8_t n)
{
	char	c1, c2;
	int8_t		k = 0;
	int8_t		result = 0;

	while ( k++ < n )
	{
		c1 = *s1++;
		c2 = *s2++;
		if ((c1 >= 'a') && (c1 <= 'z'))
			c1 = (char)(c1 - ' ');
		if ((c2 >= 'a') && (c2 <= 'z'))
			c2 = (char)(c2 - ' ');
		if ((result = (c1 - c2)) != 0)
			break;
		if ((c1 == 0) || (c2 == 0))
			break;
	}
	return result;
}

/****************************************************************/
int8_t
strlen (const char *str)
{
	char *s = (char *)str;
	int8_t len = 0;

	if (s == NULL)
		return 0;

	while (*s++ != '\0')
		++len;

	return len;
}

/****************************************************************/
char *
strcat (char *dest, const char *src)
{
	char *dp;
	char *sp = (char *)src;

	if ((dest != NULL) && (src != NULL))
	{
		dp = &dest[strlen(dest)];

		while (*sp != '\0')
		{
			*dp++ = *sp++;
		}
		*dp = '\0';
	}
	return dest;
}

/****************************************************************/
char *
strncat (char *dest, const char *src, int8_t n)
{
	char *dp;
	char *sp = (char *)src;

	if ((dest != NULL) && (src != NULL) && (n > 0))
	{
		dp = &dest[strlen(dest)];

		while ((*sp != '\0') && (n-- > 0))
		{
			*dp++ = *sp++;
		}
		*dp = '\0';
	}
	return dest;
}

/****************************************************************/
char *
strcpy (char *dest, const char *src)
{
	char *dp = (char *)dest;
	char *sp = (char *)src;

	if ((dest != NULL) && (src != NULL))
	{
		while (*sp != '\0')
		{
			*dp++ = *sp++;
		}
		*dp = '\0';
	}
	return dest;
}

/****************************************************************/
char *
strncpy (char *dest, const char *src, int8_t n)
{
	char *dp = (char *)dest;
	char *sp = (char *)src;

	if ((dest != NULL) && (src != NULL) && (n > 0))
	{
		while ((*sp != '\0') && (n-- > 0))
		{
			*dp++ = *sp++;
		}
		*dp = '\0';
	}
	return dest;
}

/****************************************************************/
int8_t
strcmp (const char *s1, const char *s2)
{
	/* No checks for NULL */
	char *s1p = (char *)s1;
	char *s2p = (char *)s2;

	while (*s2p != '\0')
	{
		if (*s1p != *s2p)
			break;

		++s1p;
		++s2p;
	}
	return (*s1p - *s2p);
}

/****************************************************************/
int8_t
strncmp (const char *s1, const char *s2, int8_t n)
{
	/* No checks for NULL */
	char *s1p = (char *)s1;
	char *s2p = (char *)s2;

	if (n <= 0)
		return 0;

	while (*s2p != '\0')
	{
		if (*s1p != *s2p)
			break;

		if (--n == 0)
			break;

		++s1p;
		++s2p;
	}
	return (*s1p - *s2p);
}

/****************************************************************/
void *
memcpy (void *dest, const void *src, uint8_t n)
{
	int8_t bytes;
	uint8_t *dpl = (uint8_t *)dest;
	uint8_t *spl = (uint8_t *)src;

	if ((dest != NULL) && (src != NULL) && (n > 0))
	{
		bytes = n;
	
		while (bytes--)
			*dpl++ = *spl++;
	}
	return dest;
}

/****************************************************************/
void *
memset (void *s, int8_t c, uint8_t n)
{
	/* Not optimized, but very portable */
	unsigned char *sp = (unsigned char *)s;

	if ((s != NULL) && (n > 0))
	{
		while (n--)
		{
			*sp++ = (unsigned char)c;
		}
	}
	return s;
}

/****************************************************************/
