
/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2011-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file wdog.h
*
* @author a13984
*
* @version 0.0.2
*
* @date Jul 17, 2011
*
* @brief provide commond watch dog utilities. 
*
* @history:
* 	Jul.20, 2011	modified the watch dog unlock sequence and disable sequence
*******************************************************************************
*
* provide APIs for accessing watch dog
******************************************************************************/

#ifndef __WDOG_H__
#define __WDOG_H__

/******************************************************************************
* Includes
******************************************************************************/

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros
******************************************************************************/
#define wdog_unlock()	asm(LDA	#0xC5); asm(STA	0x3032); asm(LDA #0x20);asm(STA 0x3033);\
		asm(LDA	#0xD9); asm(STA	0x3032); asm(LDA #0x28); asm(STA 0x3033)

/* WDOG clock sources option */
#define WDOG_CLK_BUS			0
#define WDOG_CLK_INTERNAL_32KHZ	2
#define WDOG_CLK_INTERNAL_1KHZ	1
#define WDOG_CLK_EXTERNAL		3

/* WDOG clock source selection */
#define WDOG_CLK  (WDOG_CLK_INTERNAL_1KHZ)
//#define WDOG_CLK  (WDOG_CLK_EXTERNAL)
/******************************************************************************
* Types
******************************************************************************/
typedef struct {	
	word interruptEnable: 1;
	word dbgEnable: 1;
	word waitEnable: 1;
	word stopEnable: 1;
	word windowModeEnable: 1;
	word clkSrc;
}TWatchdogConfig, *PTWatchdogConfig;
/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/
void wdog_disable(void);
/*void wdog_unlock(void);*/
void wdog_enable(PTWatchdogConfig pDogConfig);

/********************************************************************/
#endif /* __WDOG_H__ */

