#include "printf.h"
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include "fnet_cpu.h"

// LINFLEX D0
#define UARTSR *(volatile unsigned int*)0xFFE90014
#define UARTDR *(volatile unsigned int*)0xFFE90038

void vfn_put_char(char c)
{
  // Wait until space is available in the FIFO /
  while ((UARTSR & 0x2) == 0)
  {
    __asm__("nop");
  }

	UARTSR = 0x2;
	// Send the character /
	UARTDR = (unsigned char)c;
}

/*------------------------------------------------------------------------------
 * FUNC   : al_printf
 *                                    
 * DESC   : The traditional vprintf, control output from here.
 *
 *
 * PORTING: Standard C in stdio.h, and stdargs.h
 *
 * NOTE: To convert this to a string, use vsprintf, NOT sprintf.
 * ---------------------------------------------------------------------------*/
int al_printf(const char *fmt, va_list	args)
{
	char string[200];
	 int length;
    int i;
	char *ptr;

	vsprintf ( string, fmt, args);
	length = strlen(string);
	ptr = &string[0];
	for(i = 0; i <= length; i++)
	{
		fnet_cpu_serial_putchar(0,(unsigned char)*ptr++);
	}
	ptr = &string[0];
	string[0] = 0x0d;
	fnet_cpu_serial_putchar(0, (unsigned char)*ptr);
	
	return 1;
}

int th_printf( const char *fmt, ... )
 {
 int rv;
 va_list args;
 va_start( args, fmt );
 rv = al_printf( fmt, args );
 va_end( args );
 return rv;
 }
