/*****************************************************************************/
/* FILE NAME: mcu_init.c                       COPYRIGHT (c) Freescale 2012  */
/*                                                      All Rights Reserved  */
/* DESCRIPTION: Provides functions to Initilise MPC5744P MCU                 */
/*                                                                           */
/*****************************************************************************/

#include "project.h"

/************** Configure the MPU - Make RAM and Flash Cachable **************/
void MPU_Init(void)
{

    // Configure Flash region 
    //start address - beginning of small/medium flash blocks
    SMPU_0.RGD[0].WORD0.R = 0x00A00000;

    //end address - end of large flash blocks
    SMPU_0.RGD[0].WORD1.R = 0x02000000;

    //access control - all bus masters have rw access
    SMPU_0.RGD[0].WORD2.R = 0xFFFFFFFF;

    //not on Panther
    //SMPU_0.RGD0_WORD3.B.FMT = 0; 

    //region descriptor valid
    SMPU_0.RGD[0].WORD3.B.VLD = 1;

    // Configure RAM region 

    //start address - beginning of system RAM
    SMPU_0.RGD[1].WORD0.R = 0x40000000;

    //end address - end of local memory
    SMPU_0.RGD[1].WORD1.R = 0x50810000;

    //access control - all bus masters have rw access
    SMPU_0.RGD[1].WORD2.R = 0xFFFFFFFF;

    //SMPU_0.RGD1_WORD3.B.FMT = 0; //not on Panther

	// cache inhibit
    SMPU_0.RGD[1].WORD3.B.CI = 1;
	
    //region descriptor valid
    SMPU_0.RGD[1].WORD3.B.VLD = 1;

    // Enable the module 
    SMPU_0.CESR0.B.GVLD = 1; 

}


void MC_MODE_INIT(void)
{
    MC_ME.ME.R = 0x000005FF;                        /* Enable All Modes */

    /******************** Configure XOSC for DRUN **********************/
    /* Enable EXT OSC First */
    XOSC.CTL.B.OSCM = 0x1;                          /* Change OSC mode to LCP (Loop Controlled Pierce Mode) */
    XOSC.CTL.B.EOCV = 0x80;                         /* Set the End of Count Value for when to check stabilization. */
    MC_ME.DRUN_MC.B.XOSCON = 1;                     /* Enable External Oscillator */
    
    /* RE enter the DRUM mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;                      /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                      /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);                /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);        /* Check DRUN mode has been entered */
    while(!MC_ME.GS.B.S_XOSC);                      /* Wait for clock to stabilise */
    
    /* Peripheral ON in every run mode */
    MC_ME.RUN_PC[0].R = 0x000000FE; 

    /******************** PLL0, PLL1 **********************/
    
    /* Route XOSC to PLL1 */
    MC_CGM.AC4_SC.B.SELCTL = 1;
    
    /* Route IRCOSC to PLL0 (Workaround for issue. Don't use XOSC */
    MC_CGM.AC3_SC.B.SELCTL = 0;
    
    /*
        Configure PLL0 Dividers for 160 MHz
        fPLL0_VCO = (fPLL0_ref x PLL0DV[MFD] x 2 )/PLL0DV[PREDIV]
                  = 16MHz x 20 x 2 / 1 = 640 MHz    
                  
        fPLL0_PHI  = fPLL0_ref x PLL0DV[MFD] / (PLL0DV[PREDIV] x PLL0DV[RFDPHI]
                   = 16MHz x 20 / (1 x 2) = 160 MHz

        fPLL0_PHI1 = fPLL0_ref x PLL0DV[MFD] / (PLL0DV[PREDIV] x PLL0DV[RFDPHI1] x 2)
                   = 16MHz x 20 / (1 x 4 x 2) = 40 MHz                   
    */
    PLLDIG.PLL0DV.B.RFDPHI1 = 4; 
    PLLDIG.PLL0DV.B.RFDPHI = 2;
    PLLDIG.PLL0DV.B.PREDIV = 1;
    PLLDIG.PLL0DV.B.MFD = 20;
    
    /* Put PLL0 to Normal mode with PLL running */
    PLLDIG.PLL0CR.B.CLKCFG = 3;

    /*
        Configure PLL1 Dividers for 200 MHz
        fPLL1_VCO = fPLL1_REF x (PLL1DV[MFD] + PLL1FD[FRCDIV]/2^12)
                  = 40MHz x 20 + 0 = 800 MHz
                  
        fPLL1_PHI = fPLL1_REF * ( (PLL1DV[MFD] + PLL1FD[FRCDIV]/2^12) / (2 x PLL1DV[RFDPHI]) )
                  = 40MHz x (20 + 0) / (2 x 2) = 200 MHz
                  

    */    
    PLLDIG.PLL1DV.B.RFDPHI = 2;                     /* Note: div by 4 */
    PLLDIG.PLL1DV.B.MFD = 20; 
    
    /* Put PLL1 to Normal mode with PLL running */
    PLLDIG.PLL1CR.B.CLKCFG = 3;    

    /* Set PRAM controller WS to 1 since running SYS_CLK as PLL1 (200 MHz) */
    PRAMC.PRCR1.B.FT_DIS = 1;
    
    /* Set PLL1 as SYS_CLK in DRUN mode */
    MC_ME.DRUN_MC.R = 0x001300F4;
    
    /******************** Configure Clock Dividers **********************/  
   
    SIUL2.MSCR[22].R = 0x22800001;                  /* Configure CLK_OUT (B6) */
    //MC_CGM.AC6_SC.B.SELCTL = 0;                   /* source AC6 is internal RCOSC */
    //MC_CGM.AC6_SC.B.SELCTL = 2;                   /* source AC6 is PLL0 PHI */
    //MC_CGM.AC6_SC.B.SELCTL = 1;                   /* source AC6 is XOSC */
    MC_CGM.AC6_SC.B.SELCTL = 4;                     /* source AC6 is PLL1 PHI */    
    MC_CGM.AC6_DC0.R = 0x80090000;                  /* Aux clock select 6 divider 0 --> div by 10 (CLK_OUT) */    
    
    MC_CGM.AC0_SC.B.SELCTL = 2;                     /* source AC0 is PLL0 PHI */
    MC_CGM.AC0_DC0.R = 0x80000000;                  /* Aux clock select 0 divider 0 --> div by 1 (MOTC_CLK) */
    MC_CGM.AC0_DC1.R = 0x80070000;                  /* Aux clock select 0 divider 1 --> div by 8 (SWG_CLK) */
    MC_CGM.AC0_DC2.R = 0x80010000;                  /* Aux clock select 0 divider 2 --> div by 2 (ADC_CLK) */

    MC_CGM.AC1_DC0.R = 0x80010000;                  /* Aux clock select 1 divider 0 --> div by 2 (FRAY_PLL_CLK) */
    MC_CGM.AC1_DC1.R = 0x80030000;                  /* Aux clock select 1 divider 1 --> div by 4 (SENT_CLK) */

    MC_CGM.AC2_DC0.R = 0x80030000;                  /* Aux clock select 2 divider 0 --> div by 4 (CAN_PLL_CLK) */
#if 0
    MC_CGM.AC10_SC.B.SELCTL = 4;		    		/* Source for AC10 (ENET) is PLL1 */
    MC_CGM.AC10_DC0.R = 0x80030000;                 /* Aux clock select 10 divider 0 --> div by 4 (ENET_CLK) */	
    MC_CGM.AC11_SC.B.SELCTL = 4;					/* Source for AC11 (ENET_TIMER) is PLL0 */
    MC_CGM.AC11_DC0.R = 0x80030000;                 /* Aux clock select 10 divider 0 --> div by 4 (ENET_TIMER) */	
#else
    MC_CGM.AC10_SC.B.SELCTL = 5;		    		/* Source for AC10 (ENET) is RGMII */
    MC_CGM.AC10_DC0.R = 0x80000000;                 /* Aux clock select 10 divider 0 --> div by 1 (ENET_CLK) */	
    MC_CGM.AC11_SC.B.SELCTL = 5;					/* Source for AC11 (ENET_TIMER) is RGMII */
    MC_CGM.AC11_DC0.R = 0x80000000;                 /* Aux clock select 10 divider 0 --> div by 1 (ENET_TIMER) */	
#endif
	
    MC_CGM.SC_DC0.R = 0x80030000;                   /* Sys clock select divider 0 --> div by 4 (PBRIDGEx_CLK) */

    /******************** Start the core **********************/
    /* Main and checker cores running in RUN3:0, DRUN, SAFE, TEST modes */
    MC_ME.CCTL0.R = 0x00FE;

    /******************** Perform mode change **********************/
    /* Mode change re-enter the DRUN mode, to start cores, clock tree & PLL1 */
    MC_ME.MCTL.R = 0x30005AF0;                  /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                  /* Mode & Key inverted */
  
    while(MC_ME.GS.B.S_MTRANS == 1);            /* Wait for mode entry complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);    /* Check DRUN mode entered */

}






