/****************************************************************************//*!
*
*  DEMO for SBC5744
*
*	This DEMO SW is dedicated to evaluation and debug purposes of the SBC5744
*	DEMO SW uses MPC5744 Basic Drivers.
*
*  The key features of this package are the following:
*	- Event handling
*	- Interrupt handling
*	- ADC handling
*	- UART communication 
*	- Interrupt priority handling
*   - PC33907 (PwSbc) handling
*
*******************************************************************************

====================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
MicroSys		 			  29/01/2015 	   ALL		  created
MicroSys                      04/03/2015                  PwrSbc IRQ demo
---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/


#include "hal_def.h"
#include "PwSBC.h"
#include "sbc5744.h"
#include "adc.h"
#include "dspi.h"
#include "pit.h"
#include "interrupts.h"

int fnet_printf(const char *format, ... );
void PwSBC_Init(void);
void PwSBC_InitConfig1(void);
void SIUL_ClearPad(uint32_t pad);
int th_printf( const char *fmt, ... );
void PIT_Setup_Debug(int8_t Channel, uint32_t Clock_Freq, uint16_t ExpectedTimeBase);
void enableIrq(void);

#define	USE_IRQ
#define	SBC_WD_ENABLE
#define USE_SBC_IRQ

// prototype

#define	PIT0_CH2_VEC		228
#define	INT_PIT_PRIORITY	4
#define	ADC3_EOC_VEC		508
#define	SBC_IO4				SIUL_PC5
#define	SBC_IO5				SIUL_PC6
#define	SIUL2_EXT_IRQ3_VEC	246
#define	SIUL2_EXT_IRQ3_PRI	3

volatile uint32_t ui32_1ms_counter = 0;

/*******************************************************************************
Sleep
*******************************************************************************/
#ifdef USE_IRQ
void Sleep(int pMS)
{
  volatile uint32_t start_tick;

  start_tick = ui32_1ms_counter;
  do {
		;
  }while (ui32_1ms_counter < start_tick + pMS);
}
#else
#define MS_DELAY 20000
volatile void Sleep(int pMS)
{
  volatile int i,j;
  for(i = 0;i < pMS;i++) {
    for(j = 0;j < MS_DELAY;j++);
  }
}
#endif

/*******************************************************************************
system tick interrupt handler
*******************************************************************************/
void vfn_pit0_rti_irq(void)
{
/* Port for S32-Studio Issue */
/* Toggle LED 3 for debuggin issues. Deactivated in final because of web control */
#if 0
	static int tick = 0;
	static int toggle = 0;
	if(tick == 1000){
		if(toggle == 0){
			SIUL_DigitalOutput(SBC_DOUT3, 1);
			toggle = 1;
		}else{
			SIUL_DigitalOutput(SBC_DOUT3, 0);
			toggle = 0;
		}
		tick = 0;
	}
	tick++;
#endif

  // clear flag
  PIT_ClearFlag(2);
  
  // increment system tick
  ui32_1ms_counter++;
}

/***************************************************************************//*!
*   @brief The function PwSBC_IsrSIUL is an SIUL external interrupt service routine.
********************************************************************************/
void PwSBC_IsrSIUL_local()
{
	th_printf("PwSBC_IsrSIUL_local\n");
#if 1	
	PwSBC_GetMode();
	
	th_printf("IOinoutStat      = 0x%08x\n",PwSBC_GetIOinputState());		
	th_printf("PwSBCDiagVreg2   = 0x%08x\n",PwSBC_GetDiagVreg2());
	th_printf("PwSBCDiagVreg3   = 0x%08x\n",PwSBC_GetDiagVreg3());
	th_printf("PwSBCStatusVreg2 = 0x%08x\n",PwSBC_GetStatusVreg2());				
#endif
	SIUL_ClearExtIntFlag(SIUL_INT_EIRQ);	//clear interrupt EIF flag 		

}

/*******************************************************************************
init GPIO pins (DOUT0..3 / DIN0..3 / PWNA/PWNB / SBC_IO4/ SBC_IO5
*******************************************************************************/
void configure_port_pins(void)
{
	SIUL_DigitalOutput(SBC_PWENA, 0);
	SIUL_DigitalOutput(SBC_PWENB, 0);
	
	SIUL_DigitalOutput(SBC_DOUT0, 0);
	SIUL_DigitalOutput(SBC_DOUT1, 0);
	SIUL_DigitalOutput(SBC_DOUT2, 0);
	SIUL_DigitalOutput(SBC_DOUT3, 0);
	
	SIUL_DigitalInput(SBC_USER_SW4, SIUL_PULL_UP | SIUL_HYS);
	SIUL_DigitalInput(SBC_DIN0, SIUL_PULL_UP | SIUL_HYS);
	SIUL_DigitalInput(SBC_DIN1, SIUL_PULL_UP | SIUL_HYS);
	SIUL_DigitalInput(SBC_DIN2, SIUL_PULL_UP | SIUL_HYS);
	SIUL_DigitalInput(SBC_DIN3, SIUL_PULL_UP | SIUL_HYS);
	
	SIUL_DigitalInput(SBC_IO4, SIUL_PULL_UP | SIUL_HYS);
	SIUL_DigitalInput(SBC_IO5, SIUL_PULL_UP | SIUL_HYS);
}

/*******************************************************************************
init system tick, asc channels, PwrSbc
*******************************************************************************/
void io_test_init (void)
{
  //init PIT channel 2 to generate 1 ms system tick
#ifdef USE_IRQ 

  // PIT0_RTI_IRQ
  INTC_InstallINTCInterruptHandler(vfn_pit0_rti_irq, PIT0_CH2_VEC, INT_PIT_PRIORITY);
  // route to core 0
  INTC_0.PSR[PIT0_CH2_VEC].B.PRC_SELN = 8; 
  INTC_0.CPR[0].B.PRI = 0;  

  PIT_Init();

/* Port for S32-Studio Issue */
/* created extra function to avoid multiplying floating point */
  PIT_Setup_Debug(2, 40000000, 1000);

  PIT_EnableChannel(2);
  PIT_EnableInt(2);

#endif
  
  // enable digital I/O power  
  SIUL_ClearPad(SBC_PWENA);
  SIUL_ClearPad(SBC_PWENB);
  

  //init ADC channels for analog input
  /* init ADC_0 channels 0/1 (AIN1/AIN5) with default configuration */
  ADC_Init(0, CH0Smask | CH1Smask, 0, DEFAULT_ADC);
  /* init ADC_1 channels 11/13 (AIN0/AIN4) with default configuration */
  ADC_Init(1, CH11Smask | CH13Smask, 0, DEFAULT_ADC);
  /* init ADC_2 channels 0/4 (AIN3/AIN7) with default configuration */
  ADC_Init(2, CH0Smask | CH4Smask, 0, DEFAULT_ADC);
  /* init ADC_3 channels 4/6/7 (AIN2/AIN6) with default configuration */
  ADC_Init(3, CH6Smask | CH7Smask | CH4Smask, 0, DEFAULT_ADC);

  // init SPI interface
  DSPI_Init(DSPI_NB,MASTER,MCU_SYS_CLK,DSPI_BR,0);

  // install interrupt handler for ADC_3 channel 4 (PwrSbc )  
#ifdef USE_IRQ  
  INTC_InstallINTCInterruptHandler(PwSBC_IsrADC,(ADC3_EOC_VEC),INT_ADC_PRIORITY);
  ADC_SetInt(3, EOC_FLAG, CH4Smask);
#endif  

  // init PwrSbc chip
  PwSBC_GetMode();		//Get precedant Mode of the chip
  PwSBC_GetMode();		//Get actual Mode of the chip
  PwSBC_InitConfig1();
  PwSBC_Init();
  PwSBC_SetCANmode(CAN_NORMAL);
  
  // install PwrSbc Interrupt handler
#ifdef	USE_SBC_IRQ
	SIUL_DigitalInput(SBC_IO5, SIUL_PULL_UP | SIUL_HYS);
	SIUL2.IMCR[197].B.SSS = 1;
//	INTC_InstallINTCInterruptHandler(PwSBC_IsrSIUL,SIUL2_EXT_IRQ3_VEC, INT_SIUL_PRIORITY);
	INTC_InstallINTCInterruptHandler(PwSBC_IsrSIUL_local,SIUL2_EXT_IRQ3_VEC, INT_SIUL_PRIORITY);
	SIUL_EnableExtIntFallingEdge(SIUL_EIRQ24);
	SIUL_EnableExtInt(SIUL_EIRQ24);
#endif
  
  // setup interrupt handler to retrigger PwrSbc watchdog 
#ifdef SBC_WD_ENABLE
  INTC_InstallINTCInterruptHandler(PwSBC_IsrPIT_WD,PIT_WD_VEC,INT_WD_PRIORITY);
  PIT_Setup(PIT_WD_CH, MCU_SYS_CLK, PIT_WD_PERIOD);
  PIT_EnableInt(PIT_WD_CH);
  PIT_EnableChannel(PIT_WD_CH);			
#endif
  // enable PwrSbc OUT3/4
  PwSBC_EnableOUT4();
  PwSBC_EnableOUT5();
}

/*******************************************************************************
read analog inputs and PwrSbc ADC mux channel 
*******************************************************************************/
void io_test (void)
{
	fnet_printf("\n");
	ADC_StartNormalConversion(1,CH11Smask);	
	fnet_printf("AIN0 Value = 0x%04x\n",ADC_GetChannelValue(1, 11));
	ADC_StartNormalConversion(0,CH0Smask);
	fnet_printf("AIN1 Value = 0x%04x\n",ADC_GetChannelValue(0, 0));
	ADC_StartNormalConversion(3,CH6Smask);
	fnet_printf("AIN2 Value = 0x%04x\n",ADC_GetChannelValue(3, 6));
	ADC_StartNormalConversion(2,CH4Smask);
	fnet_printf("AIN3 Value = 0x%04x\n",ADC_GetChannelValue(2, 4));
	ADC_StartNormalConversion(1,CH13Smask);
	fnet_printf("AIN4 Value = 0x%04x\n",ADC_GetChannelValue(1, 13));
	ADC_StartNormalConversion(0,CH1Smask);
	fnet_printf("AIN5 Value = 0x%04x\n",ADC_GetChannelValue(0, 1));
	ADC_StartNormalConversion(3,CH7Smask);	
	fnet_printf("AIN6 Value = 0x%04x\n",ADC_GetChannelValue(3, 7));	
	ADC_StartNormalConversion(2,CH0Smask);
	fnet_printf("AIN7 Value = 0x%04x\n",ADC_GetChannelValue(2, 0));
	
#if 0
	// toggle digital output and read digital input
//	Sleep(500);
	SIUL_ClearPad(SBC_DOUT0);
	SIUL_ClearPad(SBC_DOUT1);
	SIUL_ClearPad(SBC_DOUT2);
	SIUL_ClearPad(SBC_DOUT3);
//	Sleep(500);
	SIUL_SetPad(SBC_DOUT0);
	SIUL_SetPad(SBC_DOUT1);
	SIUL_SetPad(SBC_DOUT2);
	SIUL_SetPad(SBC_DOUT3);  
//	Sleep(500);
	/* DIN0 */
	fnet_printf("DIN0  = %d\n",SIUL_GetPadState(SBC_DIN0));
	/* DIN1 */
	fnet_printf("DIN1  = %d\n",SIUL_GetPadState(SBC_DIN1));
	/* DIN2 */
	fnet_printf("DIN2  = %d\n",SIUL_GetPadState(SBC_DIN2));
	/* DIN3 */
	fnet_printf("DIN3  = %d\n",SIUL_GetPadState(SBC_DIN3));
//	Sleep(500);
	PwSBC_SetOUT4();
//	PwSBC_SetOUT5();
	Sleep(10);
	fnet_printf("SBC_IO4 = %d\n",SIUL_GetPadState(SBC_IO4));
	fnet_printf("SBC_IO5 = %d\n",SIUL_GetPadState(SBC_IO5));
	PwSBC_ClearOUT4();
//	PwSBC_ClearOUT5();
	Sleep(10);
	fnet_printf("SBC_IO4 = %d\n",SIUL_GetPadState(SBC_IO4));
	fnet_printf("SBC_IO5 = %d\n",SIUL_GetPadState(SBC_IO5));
#endif


	// test PwrSbc INT
//	PwSBC_RequestINT();

	fnet_printf("\n");	

	PwSBC_SetOUT4();
	Sleep(100);	
	PwSBC_ClearOUT4();
	
	// read PwrSbc ADC mux

	fnet_printf("\n");	

    PwSBC_SwitchAMUXchannel(AMUX_TEMP);	
    ADC_StartNormalConversion(ADC_NB, ADC_MASK);

	PwSBC_SwitchAMUXchannel(AMUX_TEMP);
	ADC_StartNormalConversion(ADC_NB, ADC_MASK);

	th_printf("pSBC Temp      = %6.2f\n",PwSBC_GetTemperature());
	PwSBC_SwitchAMUXchannel(AMUX_VREF);
	th_printf("pSBC VREF      = %3.1f\n", PwSBC_GetVoltage());
	PwSBC_SwitchAMUXchannel(AMUX_VSNS_WIDE); 
	th_printf("pSBC VNS_WIDE  = %3.1f\n", PwSBC_GetVoltageWide());
	PwSBC_SwitchAMUXchannel(AMUX_IO0_WIDE); 
	th_printf("pSBC IO0_WIDE  = %3.1f\n", PwSBC_GetVoltageWide());
	PwSBC_SwitchAMUXchannel(AMUX_IO1_WIDE); 
	th_printf("pSBC IO1_WIDE  = %3.1f\n", PwSBC_GetVoltageWide());
	PwSBC_SwitchAMUXchannel(AMUX_VSNS_TIGHT); 
	th_printf("pSBC VNS_TIGHT = %3.1f\n", PwSBC_GetVoltageTight());
	PwSBC_SwitchAMUXchannel(AMUX_IO0_TIGHT); 
	th_printf("pSBC IO0_TIGHT = %3.1f\n", PwSBC_GetVoltageTight());
	PwSBC_SwitchAMUXchannel(AMUX_IO1_TIGHT); 
	th_printf("pSBC IO1_TIGHT = %3.1f\n", PwSBC_GetVoltageTight());
  
}
