/**************************************************************************
*
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************//*!
*
* @file fnet_stack.c
*
* @date May-16-2011
*
* @version 0.1.8.0
*
* @brief FNET init/release functions.
*
***************************************************************************/

#include "fnet.h"
#include "fnet_socket_prv.h"



/************************************************************************
* NAME: fnet_init
*
* DESCRIPTION: 
*************************************************************************/
int fnet_init( struct fnet_init_params *init_params )
{
    int result = FNET_ERR;

    if(init_params /* && (fnet_os_mutex_init() == FNET_OK)*/)
    {
        //fnet_os_mutex_lock();

        if(fnet_enabled == 0) /* Is enabled already?.*/
        {
            if((result = fnet_heap_init(init_params->netheap_ptr, init_params->netheap_size)) == FNET_OK )
              if((result = fnet_stack_init()) == FNET_OK)
                fnet_enabled = 1; /* Mark the stack is enabled. */
        }

        //fnet_os_mutex_unlock();
    }

    return result;
}

/************************************************************************
* NAME: fnet_init_static
*
* DESCRIPTION: 
*************************************************************************/
int fnet_init_static()
{
    static unsigned char heap[FNET_CFG_HEAP_SIZE];
    struct fnet_init_params init_params;

    init_params.netheap_ptr = heap;

    init_params.netheap_size = FNET_CFG_HEAP_SIZE;

    return fnet_init(&init_params);
}

/************************************************************************
* NAME: fnet_release
*
* DESCRIPTION: 
*************************************************************************/
void fnet_release()
{
    //fnet_os_mutex_lock();

    if(fnet_enabled)
    {
        fnet_stack_release();
        fnet_enabled = 0;
    }

    //fnet_os_mutex_unlock();

    //fnet_os_mutex_release();
}
