/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_poll.c
*
* @author Andrey Butok
*
* @date Sep-2-2011
*
* @version 0.1.9.0
*
* @brief FNET Services polling mechanism implementation.
*
***************************************************************************/

#include "fnet_config.h"
#include "fnet.h"

#include "fnet_poll.h"
#include "fnet_error.h"


/************************************************************************
*     Definitions
*************************************************************************/

/* Polling list element type definition */

typedef struct
{
    fnet_poll_service_t service;
    void *service_param;
} fnet_poll_list_entry_t;

/* Polling interface structure */
static struct
{
    fnet_poll_list_entry_t list[FNET_CFG_POLL_MAX]; /* Polling list.*/
    fnet_poll_desc_t last;                      /* Index of the last valid entry plus 1, in the polling list.*/
} fnet_poll_if;

/************************************************************************
* NAME: fnet_poll
*
* DESCRIPTION: This function calls all registered service routines in 
*              the polling list.
*************************************************************************/
void fnet_poll( void )
{
    fnet_poll_desc_t i;

    for (i = 0; i < fnet_poll_if.last; i++)
    {
        if(fnet_poll_if.list[i].service)
            fnet_poll_if.list[i].service(fnet_poll_if.list[i].service_param);
    }
}

/************************************************************************
* NAME: fnet_poll_release
*
* DESCRIPTION: This function calls all registered service routines in 
*              the polling list.
*************************************************************************/
void fnet_poll_release( void )
{
    fnet_memset(&fnet_poll_if, 0, sizeof(fnet_poll_if));
}

/************************************************************************
* NAME: fnet_poll_register
*
* DESCRIPTION: This function adds service routine into the polling list.
*************************************************************************/
fnet_poll_desc_t fnet_poll_register( fnet_poll_service_t service, void *service_param )
{
    fnet_poll_desc_t i = 0;
    fnet_poll_desc_t result = (fnet_poll_desc_t)FNET_ERR;

    if(service)
    {
        while(fnet_poll_if.list[i].service && i < FNET_CFG_POLL_MAX)
        {
            i++;
        };

        if(i != FNET_CFG_POLL_MAX)
        {
            fnet_poll_if.list[i].service = service;
            fnet_poll_if.list[i].service_param = service_param;
            result = i;

            if(result >= fnet_poll_if.last)
                fnet_poll_if.last = result + 1;
        }
    }

    return result;
}

/************************************************************************
* NAME: fnet_poll_unregister
*
* DESCRIPTION: This function removes service routine from the polling list.
*************************************************************************/
int fnet_poll_unregister( fnet_poll_desc_t descriptor )
{
    int result;

    if(descriptor < FNET_CFG_POLL_MAX)
    {
        fnet_poll_if.list[descriptor].service = 0;
        result = FNET_OK;
    }
    else
        result = FNET_ERR;

    return result;
}

