/*
 * MPC5744P_s32.h
 *
 *  Created on: 08.11.2017
 *      Author: Michael Schneider
 */

#ifndef VERSION_COMPATIBILITY_MPC5744P_S32_H_
#define VERSION_COMPATIBILITY_MPC5744P_S32_H_

#include "s32_ide_generated/typedefs.h"

/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :19;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_CPR0_union_tag {    /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t PRI:5;
  } B;
} INTC_CPR0_tag;

typedef union INTC_IACKR0_union_tag {  /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t  :2;
  } B;
} INTC_IACKR0_tag;

typedef union INTC_EOIR0_union_tag {   /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR0_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :3;
    vuint16_t SWTN:1;
    vuint16_t  :3;
    vuint16_t PRIN:5;
  } B;
} INTC_PSR_tag;

typedef union INTC_MMRC0_union_tag {   /* INTC Monitor Mode Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t MM:2;
  } B;
} INTC_MMRC0_tag;

typedef union INTC_HIPRIC0_union_tag { /* INTC HIPRI Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t IRQ:10;
  } B;
} INTC_HIPRIC0_tag;

typedef union INTC_LATC0_union_tag {   /* INTC LAT Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LAT:24;
  } B;
} INTC_LATC0_tag;

typedef union INTC_TIMERC0_union_tag { /* INTC Timer Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t TIMER:24;
  } B;
} INTC_TIMERC0_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  uint8_t INTC_reserved0[12];
  INTC_CPR0_tag CPR0;                  /* INTC Current Priority Register for Processor 0 */
  uint8_t INTC_reserved1[12];
  INTC_IACKR0_tag IACKR0;              /* INTC Interrupt Acknowledge Register for Processor 0 */
  uint8_t INTC_reserved2[12];
  INTC_EOIR0_tag EOIR0;                /* INTC End Of Interrupt Register for Processor 0 */
  uint8_t INTC_reserved3[12];
  INTC_SSCIR_tag SSCIR[16];            /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved4[16];
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
  uint8_t INTC_reserved5[1952];
  INTC_MMRC0_tag MMRC0;                /* INTC Monitor Mode Register 0 */
  INTC_HIPRIC0_tag HIPRIC0[3];         /* INTC HIPRI Register */
  uint8_t INTC_reserved6[4];
  INTC_LATC0_tag LATC0[3];             /* INTC LAT Register */
  uint8_t INTC_reserved7[4];
  INTC_TIMERC0_tag TIMERC0[3];         /* INTC Timer Register */
};

#endif /* VERSION_COMPATIBILITY_MPC5744P_S32_H_ */
