/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
* (c) Copyright 2015 MicroSys GmbH
*
********************************************************************************
*
* $File Name:       pit.h$
* @file             pit.h
*
* $Date:            Jan-30-2015$
* @date             Jan-30-2015
*
* $Version:         1.0$
* @version          1.0
*
* Description       PIT driver header file
* @brief            PIT driver header file
*
* --------------------------------------------------------------------
* $Name:  $
*******************************************************************************/
/****************************************************************************//*!
*
*  @mainpage PIT driver for MPC5744
*
*  @section Intro Introduction
*
*	This package contains PIT driver for MPC5744 allowing to 
*	initialize and configure PIT module.
*
*  The key features of this package are the following:
*  - Initialize PIT for the desired time period
*  - Launch and stop PIT for specified channel
*  For more information about the functions and configuration items see these documents: 
*
*******************************************************************************
*
* @attention 
*            
*******************************************************************************/
/*==================================================================================================
*   Project              : SBC5744
*   Platform             : MPC5744
*   Dependencies         : MPC5744 - Basic SW drivers.
*   All Rights Reserved.
==================================================================================================*/

/*==================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
B35993		 				  01/03/2012 	   ALL		  Driver created
MicroSys                      30/01/2015       ALL        Modifications for MPC5744

---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/

#ifndef _H_PIT
#define _H_PIT

/*==================================================================================================
*   NON - configurable parameters
*	User should not modify configuration in this section.
==================================================================================================*/

//offset definitions
#define PITCH0_OFF			0x100
#define PITCH1_OFF			0x110
#define PITCH2_OFF			0x120
#define PITCH3_OFF			0x130

/*==================================================================================================
*   Function prototypes
==================================================================================================*/

void PIT_Init(void);
void PIT_Setup(int8_t Channel, uint32_t Clock_Freq, double ExpectedTimeBase);
void PIT_EnableInt(int8_t Channel);
void PIT_EnableChannel(int8_t Channel);
void PIT_Disable(int8_t Channel);
int8_t PIT_GetFlag(int8_t Channel);
void PIT_ClearFlag(int8_t Channel);

void PIT_DisableChannel(int8_t Channel);
uint32_t PIT_IsChannelEnabled(int8_t Channel);


#endif
