/* ========================================================================== */
/*   MPC5746M DEMO                                                            */
/*   (c) 2012                                                                 */
/*                                                                            */
/*   Karl-F. Leiss                                                            */
/* ========================================================================== */
/*==================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
Karl-F. Leiss                       2012       ALL        created
MicroSys                      12/02/2015       ALL        add psrPriority

---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/

#ifndef _INTCINTERRUPTS_H_
#define _INTCINTERRUPTS_H_

#include "MPC5744P.h"        
/*----------------------------------------------------------------------------*/
/* Types                                                                      */
/*----------------------------------------------------------------------------*/

/** All interrupt handlers should be of this type */
typedef void(*INTCInterruptFn)(void);

/*----------------------------------------------------------------------------*/
/* Function declarations                                                      */
/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

void INTC_InstallINTCInterruptHandler(INTCInterruptFn handlerFn, unsigned short vectorNum, unsigned char psrPriority);


#ifdef __cplusplus
}
#endif

#endif

