/*****************************************************************************
*
* @file fnet_user_config.template.h
*
* @brief Template of FNET User configuration file.
*               It should be used to change any default configuration parameter.
*
***************************************************************************/
/*! @cond */
#ifndef _FNET_USER_CONFIG_H_
#define _FNET_USER_CONFIG_H_

#define FNET_CFG_MPC_UART (1)

/*****************************************************************************
* Enable proper compiler support.
******************************************************************************/
#define FNET_CFG_COMP_GHS	        (0)
#define FNET_CFG_COMP_CW            (0)
#define FNET_CFG_COMP_IAR           (0)
#define FNET_CFG_COMP_DIAB          (0)
#define FNET_CFG_COMP_GCC			(1)

/*****************************************************************************
* Processor type.
* Selected processor definition should be only one and must be defined as 1. 
* All others may be defined but must have 0 value.
******************************************************************************/
#define FNET_CFG_CPU_MPC5744P	    (1)

/*****************************************************************************
* Processor.
* For multiprocessor systems, which core should be used.
* MPC564xBC has 0 (z4 core up to 120MHz) or 1 (z0 core up to 60MHz)
******************************************************************************/
#define FNET_CFG_CPU_INDEX			(0)

/*****************************************************************************
* IP address for the Ethernet interface. 
* At runtime it can be changed by the fnet_netif_set_address() or 
* by the DHCP client service.
******************************************************************************/
#define FNET_CFG_ETH_IP_ADDR        (FNET_GEN_ADDR(192, 168, 0, 100))

/*****************************************************************************
* IP Subnet mask for the Ethernet interface. 
* At runtime it can be changed by the fnet_netif_set_netmask() or 
* by the DHCP client service.
******************************************************************************/
#define FNET_CFG_ETH_IP_MASK        (FNET_GEN_ADDR(255, 255, 255, 0))

/*****************************************************************************
* Gateway IP address for the Ethernet interface.
* At runtime it can be changed by the fnet_netif_set_gateway() or 
* by the DHCP client service.
******************************************************************************/
#define FNET_CFG_ETH_IP_GW          (FNET_GEN_ADDR(192, 168, 0, 20))

/*****************************************************************************
* DNS server IP address for the Ethernet interface.
* At runtime it can be changed by the fnet_netif_set_dns() or 
* by the DHCP client service. 
* It is used only if FNET_CFG_DNS is set to 1.
******************************************************************************/
#define FNET_CFG_ETH_IP_DNS         (FNET_GEN_ADDR(192, 168, 0, 20)) 

/*****************************************************************************
* Size of the internal static heap buffer. 
* This definition is used only if the fnet_init_static() was 
* used for the FNET initialization.
******************************************************************************/
#define FNET_CFG_HEAP_SIZE          (30 * 1024)

/*****************************************************************************
* TCP protocol support.
* You can disable it to save a substantial amount of code if 
* your application only needs UDP. By default it is enabled.
******************************************************************************/
#define FNET_CFG_TCP                (1)

/*****************************************************************************
* UDP protocol support.
* You can disable it to save a some amount of code if your 
* application only needs TCP. By default it is enabled.
******************************************************************************/
#define FNET_CFG_UDP                (1)

/*****************************************************************************
* UDP checksum.
* If enabled, the UDP checksum will be generated for transmitted 
* datagrams and be verified on received UDP datagrams.
* You can disable it to speedup UDP applications. 
* By default it is enabled.
******************************************************************************/
#define FNET_CFG_UDP_CHECKSUM       (1)

/*****************************************************************************
* IP fragmentation.
* If the IP fragmentation is enabled, the IP will attempt to reassemble IP 
* packet fragments and will able to generate fragmented IP packets.
* If disabled, the IP will  silently discard fragmented IP packets..
******************************************************************************/
#define FNET_CFG_IP_FRAGMENTATION   (1)

/*****************************************************************************
* MTU.
* Defines the Maximum Transmission Unit for the Ethernet interface.
* The largest value is 1500. Recommended range is 600 - 1500
******************************************************************************/
#define FNET_CFG_ETH_MTU            (1500)

/*****************************************************************************
* DHCP Client service support.
******************************************************************************/
#define FNET_CFG_DHCP               (1)

/*****************************************************************************
* HTTP Server service support.
******************************************************************************/
#define FNET_CFG_HTTP                       (1)
#define FNET_CFG_HTTP_AUTHENTICATION_BASIC  (0) /* Enable HTTP authentication.*/
#define FNET_CFG_HTTP_POST                  (1) /* Enable HTTP POST-method support.*/

/*****************************************************************************
* Telnet Server service support.
******************************************************************************/
#define FNET_CFG_TELNET                     (0)

/*****************************************************************************
* DNS support by network interface.
******************************************************************************/
#define FNET_CFG_DNS                        (1)

/*****************************************************************************
* DNS address client/resolver service support.
******************************************************************************/
#define FNET_CFG_DNS_RESOLVER               (1)

/*****************************************************************************
* Flash Module driver support.
******************************************************************************/
#define FNET_CFG_FLASH                      (0)

#define FNET_CFG_DEBUG (0)
#define FNET_CFG_DEBUG_HTTP (0)

#endif
/*! @endcond */
