/**************************************************************************
* 
* Copyright 2005-2013 by Andrey Butok and Arturo Inzunza.
*                        Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_mpc_config.h
*
* @date Sep-5-2011
*
* @version 0.1.26.0
*
* @brief Bolero specific default configuration file.
*
***************************************************************************/

/************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 ************************************************************************/

#ifndef _FNET_MPC_CONFIG_H_

#define _FNET_MPC_CONFIG_H_

#include "fnet_user_config.h"

/*! @cond */
#if FNET_MPC
/*! @endcond */

/******************************************************************************
 *  Vector number of the Ethernet Receive Frame interrupt.
 *  NOTE: User application should not change this parameter. 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_CPU_ETH_VECTOR_NUMBER
	#define FNET_CFG_CPU_ETH_VECTOR_NUMBER      (218)
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_MPC_TIMER_DTIM
 * @brief    The DMA Timer (DTIM) module:
 *               - @c 1 = The platform uses the DMA Timer (DTIM) module 
 *                        as the FNET timer.
 *               - @c 0 = The platform does not have the DMA Timer (DTIM) 
 *                        module.
 *           @n @n NOTE: User application should not change this parameter. 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_MPC_TIMER_DTIM
/*! @endcond */
#define FNET_CFG_MPC_TIMER_DTIM             (1)
/*! @cond */
#endif
/*! @endcond */

/**************************************************************************
 *  Timer number used by the FNET. It can range from 0 to 7; this is PIT 0-7.
 *  PIT 3-7 could also be used, but they need to be from 127 (124+TIMER_NUMBER)
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_CPU_TIMER_NUMBER
#define FNET_CFG_CPU_TIMER_NUMBER           (0)
#endif
/*! @endcond */

/******************************************************************************
 *  Vector number of the timer interrupt.
 *  NOTE: User application should not change this parameter. 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_CPU_TIMER_VECTOR_NUMBER
		#define FNET_CFG_CPU_TIMER_VECTOR_NUMBER    (226 + FNET_CFG_CPU_TIMER_NUMBER)	
#endif
/*! @endcond */


/**************************************************************************/ /*!
 * @def      FNET_CFG_MPC_RCM
 * @brief    Reset Controller Module (RCM):
 *               - @c 1 = Current platform has the Reset Controller Module.
 *               - @c 0 = Current platform does not have the Reset Controller Module.
 *              @n @n NOTE: User application should not change this parameter.
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_MPC_RCM
/*! @endcond */
#define FNET_CFG_MPC_RCM                    (1)
/*! @cond */
#endif
/*! @endcond */


/**************************************************************************/ /*!
 * @def      FNET_CFG_MPC_UART
 * @brief    The Universal Asynchronous Receiver/Transmitters (UART) module:
 *               - @c 1 = The platform uses the UART module 
 *                        for serial-port input/output functions.
 *               - @c 0 = The platform does not have the UART module.
 *           @n @n NOTE: User application should not change this parameter. 
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_MPC_UART
/*! @endcond */
#define FNET_CFG_MPC_UART                   (1)
/*! @cond */
#endif
/*! @endcond */

/*! @} */
/*! @cond */
#endif /* FNET_MCF */
/*! @endcond */
#endif
