/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_dns_config.h
*
* @author Andrey Butok
*
* @date Jul-18-2011
*
* @version 0.0.2.0
*
* @brief DNS Resolver configuration file.
*
***************************************************************************/

/**************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 **************************************************************************/

#ifndef _FNET_DNS_CONFIG_H_

#define _FNET_DNS_CONFIG_H_

/*! @addtogroup fnet_services_config */
/*! @{ */

/**************************************************************************/ /*!
 * @def     FNET_CFG_DNS_PORT
 * @brief   Default DNS port number (in network byte order).@n
 *          The DNS client uses this port for sending and receiving of DNS messages.
 * @showinitializer 
 ******************************************************************************/  
/*! @cond */
#ifndef FNET_CFG_DNS_PORT
/*! @endcond */ 
#define FNET_CFG_DNS_PORT                       (FNET_HTONS(53))
/*! @cond */
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def     FNET_CFG_DNS_RETRANSMISSION_MAX
 * @brief   The maximum number of times the DNS client/resolver will retransmit
 *          the request message to a DNS server.
 * @showinitializer 
 ******************************************************************************/  
/*! @cond */
#ifndef FNET_CFG_DNS_RETRANSMISSION_MAX
/*! @endcond */ 
#define FNET_CFG_DNS_RETRANSMISSION_MAX         (5)
/*! @cond */
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_DNS_RETRANSMISSION_TIMEOUT
 * @brief    Timeout for the response from the remote DNS server (in seconds).@n
 *  @n 
 * The recommended value is @c 1 second.@n
 * If the DNS client does not receive any response from a DNS server, 
 * it sends new request message.
 * @showinitializer
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_DNS_RETRANSMISSION_TIMEOUT
/*! @endcond */ 
#define FNET_CFG_DNS_RETRANSMISSION_TIMEOUT     (1)  /* seconds */
/*! @cond */
#endif
/*! @endcond */

/*! @} */

#endif /* _FNET_DNS_CONFIG_H_ */
