/**************************************************************************
* 
* Copyright 2005-2011 by Andrey Butok. Freescale Semiconductor, Inc.
*
**********************************************************************/ /*!
*
* @file fnet_dhcp_config.h
*
* @author Andrey Butok
*
* @date Jul-18-2011
*
* @version 0.0.10.0
*
* @brief DHCP Client configuration file.
*
***************************************************************************/

/**************************************************************************
 * !!!DO NOT MODIFY THIS FILE!!!
 **************************************************************************/

#ifndef _FNET_DHCP_CONFIG_H_

#define _FNET_DHCP_CONFIG_H_

/*! @addtogroup fnet_services_config */
/*! @{ */

/**************************************************************************/ /*!
 * @def      FNET_CFG_DHCP_RESPONSE_TIMEOUT
 * @brief    Timeout for the response from the remote DHCP server (in seconds).@n
 *  @n 
 * The recommended value is from @c 1 till @c 10 seconds.@n
 * If the DHCP client does not receive any response from a DHCP server during this time, 
 * it sends new discover message.
 * @showinitializer
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_DHCP_RESPONSE_TIMEOUT
/*! @endcond */ 
#define FNET_CFG_DHCP_RESPONSE_TIMEOUT     (4) 
/*! @cond */
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_DHCP_OVERLOAD
 * @brief    DHCP "Option overload" support [RFC 2132 9.3]:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled (default value).@n
 * @n
 * It's recomended to disable this option, as it's not used in practice.@n @n
 * [RFC 2132 9.3]: "This option is used to indicate that the DHCP 'sname' or 'file'
 *  fields are being overloaded by using them to carry DHCP options. A
 *  DHCP server inserts this option if the returned parameters will
 *  exceed the usual space allotted for options.@n
 *  If this option is present, the client interprets the specified
 *  additional fields after it concludes interpretation of the standard
 *  option fields." 
 * @showinitializer
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_DHCP_OVERLOAD
/*! @endcond */

#define FNET_CFG_DHCP_OVERLOAD   (0)

/*! @cond */
#endif
/*! @endcond */

/**************************************************************************/ /*!
 * @def      FNET_CFG_DHCP_BROADCAST
 * @brief    DHCP "Broadcast Address Option" support [RFC 2132 5.3]:
 *               - @c 1 = is enabled.
 *               - @c 0 = is disabled (default value).@n
 * @n
 * [RFC 2132 9.3]: "This option specifies the broadcast address 
 * in use on the client's subnet." 
 * @showinitializer
 ******************************************************************************/
/*! @cond */
#ifndef FNET_CFG_DHCP_BROADCAST
/*! @endcond */

#define FNET_CFG_DHCP_BROADCAST (0)

/*! @cond */
#endif
/*! @endcond */


/*! @} */


#endif
