/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
* (c) Copyright 2015 MicroSys GmbH
*
********************************************************************************
*
* $File Name:       dspi.h$
* @file             dspi.h
*
* $Date:            Jan-30-2015$
* @date             Jan-30-2015
*
* $Version:         1.0$
* @version          1.0
*
* Description       DSPI driver header file
* @brief            DSPI driver header file
*
* --------------------------------------------------------------------
* $Name:  $
*******************************************************************************/
/****************************************************************************//*!
*
*  @mainpage DSPI driver for MPC5744
*
*  @section Intro Introduction
*
*	This package contains DSPI driver for MPC5744 allowing to 
*	initialize/configure DSPI module and process SPI communication.
*
*  The key features of this package are the following:
*  - Initialize DSPI module with the desired parameters
*  - Configure DSPI parameters
*  - Process SPI communication (reading/writing)
*  For more information about the functions and configuration items see these documents: 
*
*******************************************************************************
*
* @attention 
*            
*******************************************************************************/
/*==================================================================================================
*   Project              : SBC5744
*   Platform             : MPC5744
*   Dependencies         : MPC5744 - Basic SW drivers.
*   All Rights Reserved.
==================================================================================================*/

/*==================================================================================================
Revision History:
                             Modification     Function
Author (core ID)              Date D/M/Y       Name		  Description of Changes
B35993		 				  01/03/2012 	   ALL		  Driver created
MicroSys                      30/01/2015       ALL        Modifications for MPC5744

---------------------------   ----------    ------------  ------------------------------------------
==================================================================================================*/

#ifndef _DSPI_H_
#define _DSPI_H_

/*==================================================================================================
*   Configurable parameters
*	User shall change configuration in this section regarding needs of the application.
==================================================================================================*/
	#define	DSPI_0_CS0_EN	///enables Chip-Select number 0 for DSPI0
//	#define	DSPI_0_CS1_EN	///enables Chip-Select number 1 for DSPI0
//	#define	DSPI_0_CS2_EN	///enables Chip-Select number 2 for DSPI0
//	#define	DSPI_0_CS3_EN	///enables Chip-Select number 3 for DSPI0
		
	#define	DSPI_1_CS0_EN	///enables Chip-Select number 0 for DSPI1
//	#define	DSPI_1_CS1_EN	///enables Chip-Select number 1 for DSPI1
//	#define	DSPI_1_CS2_EN	///enables Chip-Select number 2 for DSPI1
//	#define	DSPI_1_CS3_EN	///enables Chip-Select number 3 for DSPI1
		
	#define	DSPI_2_CS0_EN	///enables Chip-Select number 0 for DSPI2
//	#define	DSPI_2_CS1_EN	///enables Chip-Select number 1 for DSPI2
//	#define	DSPI_2_CS2_EN	///enables Chip-Select number 2 for DSPI2
//	#define	DSPI_2_CS3_EN	///enables Chip-Select number 3 for DSPI2

/*==================================================================================================
*   NON - configurable parameters
*	User should not modify configuration in this section.
==================================================================================================*/
///DSPI basic defines
#define MASTER 1
#define SLAVE  0

#define PBR_VALUE1	2.
#define PBR_VALUE2	3.
#define PBR_VALUE3	5.
#define PBR_VALUE4	7.

#define PBR1	0b00		
#define PBR2	0b01
#define PBR3	0b10
#define PBR4	0b11

#define BR_VALUE1	2
#define BR_VALUE2	4
#define BR_VALUE3	6
#define BR_VALUE4	8
#define BR_VALUE5	16
#define BR_VALUE6	32
#define BR_VALUE7	64
#define BR_VALUE8	128
#define BR_VALUE9	256
#define BR_VALUE10	512
#define BR_VALUE11	1024
#define BR_VALUE12	2048
#define BR_VALUE13	4096
#define BR_VALUE14	8192
#define BR_VALUE15	16384
#define BR_VALUE16	32768

#define BR1					0b0000
#define BR2					0b0001
#define BR3					0b0010
#define BR4					0b0011
#define BR5					0b0100
#define BR6					0b0101
#define BR7					0b0110
#define BR8					0b0111
#define BR9					0b1000
#define BR10				0b1001
#define BR11				0b1010
#define BR12				0b1011
#define BR13				0b1100
#define BR14				0b1101
#define BR15				0b1110
#define BR16				0b1111
///Minimal values of the ratio (fsys/SCKbr) with different PBR setting
#define RATIO_MIN1	4					 	//PBR = 00
#define RATIO_MIN2	6						//PBR = 01
#define RATIO_MIN3	10						//PBR = 10
#define RATIO_MIN4	14						//PBR = 11
///Maximal values of the ratio (fsys/SCKbr) with different PBR setting
#define RATIO_MAX1	65536					//PBR = 00
#define RATIO_MAX2	98304					//PBR = 01
#define RATIO_MAX3	163840					//PBR = 10
#define RATIO_MAX4	229376					//PBR = 11
///CTAR defines
#define LOW_SCK				0				//CPOL
#define HIGH_SCK			1
#define CAPTURE_RISING		0				//CPHA
#define CAPTURE_FALLING		1				
#define NORMAL_BR			0				//DBR
#define DOUBLED_BR			1
///CTAR Prescalers
#define PRESC_VAL1		0b00			
#define PRESC_VAL3		0b01		
#define PRESC_VAL5		0b10
#define PRESC_VAL7		0b11
///CTAR Scalers
#define SCALER1		0b0000
#define SCALER2		0b0001
#define SCALER3		0b0010
#define SCALER4		0b0011
#define SCALER5		0b0100
#define SCALER6		0b0101
#define SCALER7		0b0110
#define SCALER8		0b0111
#define SCALER9		0b1000 
#define SCALER10	0b1001
#define SCALER11	0b1010
#define SCALER12	0b1011
#define SCALER13	0b1100
#define SCALER14	0b1101
#define SCALER15	0b1110
#define SCALER16	0b1111

///Interrupts
#define TCFRE	0x80000000
#define EOQFRE	0x10000000
#define TFUFRE	0x08000000
#define TFFFRE	0x02000000
#define RFOFRE	0x00080000
#define RFDFRE	0x00020000

///Offset definitions
#define CTAR0_OFF	0x000C	//till CTAR5 by 4 Bytes each
#define TXFR0_OFF	0x003C	//till TXFR3 by 4 Bytes each
#define RXFR0_OFF	0x007C	//till RXFR3 by 4 Bytes each

/*==================================================================================================
*   Function prototypes
==================================================================================================*/

void DSPI_Init(uint8_t,uint8_t, uint32_t, uint32_t, uint32_t);
void DSPI_Send(uint8_t,uint8_t,uint16_t);
uint32_t DSPI_Read(uint8_t);
uint32_t DSPI_RoundBaudRate(uint32_t);
void DSPI_SetPhase(uint8_t, uint8_t);
void DSPI_SetPolarity(uint8_t, uint8_t);
void DSPI_Enable(uint8_t);
void DSPI_Disable(uint8_t);

void changeBaudRateType(uint8_t DspiNumber, uint8_t typeBR);
void changeFrameSizeDSPIx(uint8_t DspiNumber, uint8_t frameSize);

void DSPI_EnableTxFIFO(uint8_t);
void DSPI_DisableTxFIFO(uint8_t);
void DSPI_EnableRxFIFO(uint8_t);
void DSPI_DisableRxFIFO(uint8_t);
void DSPI_SendWithInt(uint8_t,uint8_t,uint16_t);
uint32_t DSPI_ReadWithInt(uint8_t);
void DSPI_ClearRFDF(uint8_t);


#endif
